package software.amazon.awscdk.services.apigatewayv2;

/**
 * (experimental) Route class that creates the Route for API Gateway WebSocket API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketApi webSocketApi;
 * IWebSocketRouteAuthorizer webSocketRouteAuthorizer;
 * WebSocketRouteIntegration webSocketRouteIntegration;
 * WebSocketRoute webSocketRoute = WebSocketRoute.Builder.create(this, "MyWebSocketRoute")
 *         .integration(webSocketRouteIntegration)
 *         .routeKey("routeKey")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizer(webSocketRouteAuthorizer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.151Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2.WebSocketRoute")
public class WebSocketRoute extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute {

    protected WebSocketRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public WebSocketRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Id of the Route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteId() {
        return software.amazon.jsii.Kernel.get(this, "routeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The key to this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteKey() {
        return software.amazon.jsii.Kernel.get(this, "routeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The WebSocket API associated with this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
        return software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
    }

    /**
     * (experimental) Integration response ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntegrationResponseId() {
        return software.amazon.jsii.Kernel.get(this, "integrationResponseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.WebSocketRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.WebSocketRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.WebSocketRouteProps.Builder();
        }

        /**
         * (experimental) The integration to be configured on this route.
         * <p>
         * @return {@code this}
         * @param integration The integration to be configured on this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integration(final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * (experimental) The authorize to this route.
         * <p>
         * You can only set authorizer to a $connect route.
         * <p>
         * Default: - No Authorizer
         * <p>
         * @return {@code this}
         * @param authorizer The authorize to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizer(final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer) {
            this.props.authorizer(authorizer);
            return this;
        }

        /**
         * (experimental) The key to this route.
         * <p>
         * @return {@code this}
         * @param routeKey The key to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeKey(final java.lang.String routeKey) {
            this.props.routeKey(routeKey);
            return this;
        }

        /**
         * (experimental) The API the route is associated with.
         * <p>
         * @return {@code this}
         * @param webSocketApi The API the route is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder webSocketApi(final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.props.webSocketApi(webSocketApi);
            return this;
        }

        /**
         * (experimental) Whether the route requires an API Key to be provided.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param apiKeyRequired Whether the route requires an API Key to be provided. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.WebSocketRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.WebSocketRoute build() {
            return new software.amazon.awscdk.services.apigatewayv2.WebSocketRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
