package software.amazon.awscdk.services.apigatewayv2.integrations;

/**
 * (experimental) The HTTP Proxy integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.HttpLambdaAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.HttpLambdaResponseType;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * HttpLambdaAuthorizer authorizer = HttpLambdaAuthorizer.Builder.create("BooksAuthorizer", authHandler)
 *         .responseTypes(List.of(HttpLambdaResponseType.SIMPLE))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.myproxy.internal"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.205Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apigatewayv2_integrations.HttpUrlIntegration")
public class HttpUrlIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpUrlIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpUrlIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param url the URL to proxy to. This parameter is required.
     * @param props properties to configure the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpUrlIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String url, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(url, "url is required"), props });
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param url the URL to proxy to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpUrlIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String url) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * (experimental) Bind this integration to the route.
     * <p>
     * @param _ This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions _) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(_, "_ is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         * @param url the URL to proxy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String id, final java.lang.String url) {
            return new Builder(id, url);
        }

        private final java.lang.String id;
        private final java.lang.String url;
        private software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegrationProps.Builder props;

        private Builder(final java.lang.String id, final java.lang.String url) {
            this.id = id;
            this.url = url;
        }

        /**
         * (experimental) The HTTP method that must be used to invoke the underlying HTTP proxy.
         * <p>
         * Default: HttpMethod.ANY
         * <p>
         * @return {@code this}
         * @param method The HTTP method that must be used to invoke the underlying HTTP proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder method(final software.amazon.awscdk.services.apigatewayv2.HttpMethod method) {
            this.props().method(method);
            return this;
        }

        /**
         * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: undefined requests are sent to the backend unmodified
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props().parameterMapping(parameterMapping);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration build() {
            return new software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegration(
                this.id,
                this.url,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegrationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.integrations.HttpUrlIntegrationProps.Builder();
            }
            return this.props;
        }
    }
}
