package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) How adjustment numbers are interpreted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ScalableAttribute capacity;
 * Metric cpuUtilization;
 * capacity.scaleOnMetric("ScaleToCPU", BasicStepScalingPolicyProps.builder()
 *         .metric(cpuUtilization)
 *         .scalingSteps(List.of(ScalingInterval.builder().upper(10).change(-1).build(), ScalingInterval.builder().lower(50).change(+1).build(), ScalingInterval.builder().lower(70).change(+3).build()))
 *         // Change this to AdjustmentType.PercentChangeInCapacity to interpret the
 *         // 'change' numbers before as percentages instead of capacity counts.
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.455Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_applicationautoscaling.AdjustmentType")
public enum AdjustmentType {
    /**
     * (experimental) Add the adjustment number to the current capacity.
     * <p>
     * A positive number increases capacity, a negative number decreases capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CHANGE_IN_CAPACITY,
    /**
     * (experimental) Add this percentage of the current capacity to itself.
     * <p>
     * The number must be between -100 and 100; a positive number increases
     * capacity and a negative number decreases it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PERCENT_CHANGE_IN_CAPACITY,
    /**
     * (experimental) Make the capacity equal to the exact number given.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EXACT_CAPACITY,
}
