package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) Define a scalable target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Code code;
 * Function handler = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.PYTHON_3_7)
 *         .handler("index.handler")
 *         .code(code)
 *         .reservedConcurrentExecutions(2)
 *         .build();
 * Version fnVer = handler.getCurrentVersion();
 * ScalableTarget target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(ServiceNamespace.LAMBDA)
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * target.scaleToTrackMetric("PceTracking", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(0.9)
 *         .predefinedMetric(PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.510Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_applicationautoscaling.ScalableTarget")
public class ScalableTarget extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.applicationautoscaling.IScalableTarget {

    protected ScalableTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScalableTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ScalableTarget(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param scalableTargetId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.IScalableTarget fromScalableTargetId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String scalableTargetId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.applicationautoscaling.ScalableTarget.class, "fromScalableTargetId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(scalableTargetId, "scalableTargetId is required") });
    }

    /**
     * (experimental) Add a policy statement to the role's policy.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Scale out or in, in response to a metric.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy scaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BasicStepScalingPolicyProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Scale out or in based on time.
     * <p>
     * @param id This parameter is required.
     * @param action This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void scaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.ScalingSchedule action) {
        software.amazon.jsii.Kernel.call(this, "scaleOnSchedule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(action, "action is required") });
    }

    /**
     * (experimental) Scale out or in in order to keep a metric around a target value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy scaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BasicTargetTrackingScalingPolicyProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleToTrackMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The role used to give AutoScaling permissions to your resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) ID of the Scalable Target.
     * <p>
     * Example value: <code>service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH|ecs:service:DesiredCount|ecs</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalableTargetId() {
        return software.amazon.jsii.Kernel.get(this, "scalableTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.ScalableTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.ScalableTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps.Builder();
        }

        /**
         * (experimental) The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * <p>
         * @return {@code this}
         * @param maxCapacity The maximum value that Application Auto Scaling can use to scale a target during a scaling activity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * (experimental) The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
         * <p>
         * @return {@code this}
         * @param minCapacity The minimum value that Application Auto Scaling can use to scale a target during a scaling activity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * (experimental) The resource identifier to associate with this scalable target.
         * <p>
         * This string consists of the resource type and unique identifier.
         * <p>
         * Example value: <code>service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH</code>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html</a>
         * @param resourceId The resource identifier to associate with this scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * (experimental) The scalable dimension that's associated with the scalable target.
         * <p>
         * Specify the service namespace, resource type, and scaling property.
         * <p>
         * Example value: <code>ecs:service:DesiredCount</code>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ScalingPolicy.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ScalingPolicy.html</a>
         * @param scalableDimension The scalable dimension that's associated with the scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scalableDimension(final java.lang.String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        /**
         * (experimental) The namespace of the AWS service that provides the resource or custom-resource for a resource provided by your own application or service.
         * <p>
         * For valid AWS service namespace values, see the RegisterScalableTarget
         * action in the Application Auto Scaling API Reference.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html</a>
         * @param serviceNamespace The namespace of the AWS service that provides the resource or custom-resource for a resource provided by your own application or service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceNamespace(final software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        /**
         * (experimental) Role that allows Application Auto Scaling to modify your scalable target.
         * <p>
         * Default: A role is automatically created
         * <p>
         * @return {@code this}
         * @param role Role that allows Application Auto Scaling to modify your scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.ScalableTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.ScalableTarget build() {
            return new software.amazon.awscdk.services.applicationautoscaling.ScalableTarget(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
