package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) The service that supports Application AutoScaling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Code code;
 * Function handler = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.PYTHON_3_7)
 *         .handler("index.handler")
 *         .code(code)
 *         .reservedConcurrentExecutions(2)
 *         .build();
 * Version fnVer = handler.getCurrentVersion();
 * ScalableTarget target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(ServiceNamespace.LAMBDA)
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * target.scaleToTrackMetric("PceTracking", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(0.9)
 *         .predefinedMetric(PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_applicationautoscaling.ServiceNamespace")
public enum ServiceNamespace {
    /**
     * (experimental) Elastic Container Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ECS,
    /**
     * (experimental) Elastic Map Reduce.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ELASTIC_MAP_REDUCE,
    /**
     * (experimental) Elastic Compute Cloud.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EC2,
    /**
     * (experimental) App Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    APPSTREAM,
    /**
     * (experimental) Dynamo DB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DYNAMODB,
    /**
     * (experimental) Relational Database Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RDS,
    /**
     * (experimental) SageMaker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SAGEMAKER,
    /**
     * (experimental) Custom Resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CUSTOM_RESOURCE,
    /**
     * (experimental) Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LAMBDA,
    /**
     * (experimental) Comprehend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPREHEND,
    /**
     * (experimental) Kafka.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KAFKA,
    /**
     * (experimental) ElastiCache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ELASTICACHE,
}
