package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Represents the properties needed to define backend defaults.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * Tags.of(node).add("Environment", "Dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.624Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.BackendDefaults")
@software.amazon.jsii.Jsii.Proxy(BackendDefaults.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BackendDefaults extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) TLS properties for Client policy for backend defaults.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.TlsClientPolicy getTlsClientPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackendDefaults}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackendDefaults}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BackendDefaults> {
        software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy;

        /**
         * Sets the value of {@link BackendDefaults#getTlsClientPolicy}
         * @param tlsClientPolicy TLS properties for Client policy for backend defaults.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tlsClientPolicy(software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy) {
            this.tlsClientPolicy = tlsClientPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackendDefaults}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BackendDefaults build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackendDefaults}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackendDefaults {
        private final software.amazon.awscdk.services.appmesh.TlsClientPolicy tlsClientPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tlsClientPolicy = software.amazon.jsii.Kernel.get(this, "tlsClientPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsClientPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tlsClientPolicy = builder.tlsClientPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsClientPolicy getTlsClientPolicy() {
            return this.tlsClientPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTlsClientPolicy() != null) {
                data.set("tlsClientPolicy", om.valueToTree(this.getTlsClientPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appmesh.BackendDefaults"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackendDefaults.Jsii$Proxy that = (BackendDefaults.Jsii$Proxy) o;

            return this.tlsClientPolicy != null ? this.tlsClientPolicy.equals(that.tlsClientPolicy) : that.tlsClientPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tlsClientPolicy != null ? this.tlsClientPolicy.hashCode() : 0;
            return result;
        }
    }
}
