package software.amazon.awscdk.services.appmesh;

/**
 * Properties for defining a `CfnVirtualNode`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnVirtualNodeProps cfnVirtualNodeProps = CfnVirtualNodeProps.builder()
 *         .meshName("meshName")
 *         .spec(VirtualNodeSpecProperty.builder()
 *                 .backendDefaults(BackendDefaultsProperty.builder()
 *                         .clientPolicy(ClientPolicyProperty.builder()
 *                                 .tls(ClientPolicyTlsProperty.builder()
 *                                         .validation(TlsValidationContextProperty.builder()
 *                                                 .trust(TlsValidationContextTrustProperty.builder()
 *                                                         .acm(TlsValidationContextAcmTrustProperty.builder()
 *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                 .build())
 *                                                         .file(TlsValidationContextFileTrustProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .build())
 *                                                         .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                 .exact(List.of("exact"))
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .certificate(ClientTlsCertificateProperty.builder()
 *                                                 .file(ListenerTlsFileCertificateProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .privateKey("privateKey")
 *                                                         .build())
 *                                                 .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         .enforce(false)
 *                                         .ports(List.of(123))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .backends(List.of(BackendProperty.builder()
 *                         .virtualService(VirtualServiceBackendProperty.builder()
 *                                 .virtualServiceName("virtualServiceName")
 *                                 // the properties below are optional
 *                                 .clientPolicy(ClientPolicyProperty.builder()
 *                                         .tls(ClientPolicyTlsProperty.builder()
 *                                                 .validation(TlsValidationContextProperty.builder()
 *                                                         .trust(TlsValidationContextTrustProperty.builder()
 *                                                                 .acm(TlsValidationContextAcmTrustProperty.builder()
 *                                                                         .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                         .build())
 *                                                                 .file(TlsValidationContextFileTrustProperty.builder()
 *                                                                         .certificateChain("certificateChain")
 *                                                                         .build())
 *                                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                                         .secretName("secretName")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                         .exact(List.of("exact"))
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .certificate(ClientTlsCertificateProperty.builder()
 *                                                         .file(ListenerTlsFileCertificateProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .privateKey("privateKey")
 *                                                                 .build())
 *                                                         .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .enforce(false)
 *                                                 .ports(List.of(123))
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .listeners(List.of(ListenerProperty.builder()
 *                         .portMapping(PortMappingProperty.builder()
 *                                 .port(123)
 *                                 .protocol("protocol")
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectionPool(VirtualNodeConnectionPoolProperty.builder()
 *                                 .grpc(VirtualNodeGrpcConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .http(VirtualNodeHttpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         // the properties below are optional
 *                                         .maxPendingRequests(123)
 *                                         .build())
 *                                 .http2(VirtualNodeHttp2ConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .tcp(VirtualNodeTcpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         .build())
 *                                 .build())
 *                         .healthCheck(HealthCheckProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalMillis(123)
 *                                 .protocol("protocol")
 *                                 .timeoutMillis(123)
 *                                 .unhealthyThreshold(123)
 *                                 // the properties below are optional
 *                                 .path("path")
 *                                 .port(123)
 *                                 .build())
 *                         .outlierDetection(OutlierDetectionProperty.builder()
 *                                 .baseEjectionDuration(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .interval(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .maxEjectionPercent(123)
 *                                 .maxServerErrors(123)
 *                                 .build())
 *                         .timeout(ListenerTimeoutProperty.builder()
 *                                 .grpc(GrpcTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .http(HttpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .http2(HttpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .perRequest(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .tcp(TcpTimeoutProperty.builder()
 *                                         .idle(DurationProperty.builder()
 *                                                 .unit("unit")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .tls(ListenerTlsProperty.builder()
 *                                 .certificate(ListenerTlsCertificateProperty.builder()
 *                                         .acm(ListenerTlsAcmCertificateProperty.builder()
 *                                                 .certificateArn("certificateArn")
 *                                                 .build())
 *                                         .file(ListenerTlsFileCertificateProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .privateKey("privateKey")
 *                                                 .build())
 *                                         .sds(ListenerTlsSdsCertificateProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 .mode("mode")
 *                                 // the properties below are optional
 *                                 .validation(ListenerTlsValidationContextProperty.builder()
 *                                         .trust(ListenerTlsValidationContextTrustProperty.builder()
 *                                                 .file(TlsValidationContextFileTrustProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .build())
 *                                                 .sds(TlsValidationContextSdsTrustProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                         .exact(List.of("exact"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .logging(LoggingProperty.builder()
 *                         .accessLog(AccessLogProperty.builder()
 *                                 .file(FileAccessLogProperty.builder()
 *                                         .path("path")
 *                                         // the properties below are optional
 *                                         .format(LoggingFormatProperty.builder()
 *                                                 .json(List.of(JsonFormatRefProperty.builder()
 *                                                         .key("key")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .text("text")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .serviceDiscovery(ServiceDiscoveryProperty.builder()
 *                         .awsCloudMap(AwsCloudMapServiceDiscoveryProperty.builder()
 *                                 .namespaceName("namespaceName")
 *                                 .serviceName("serviceName")
 *                                 // the properties below are optional
 *                                 .attributes(List.of(AwsCloudMapInstanceAttributeProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .ipPreference("ipPreference")
 *                                 .build())
 *                         .dns(DnsServiceDiscoveryProperty.builder()
 *                                 .hostname("hostname")
 *                                 // the properties below are optional
 *                                 .ipPreference("ipPreference")
 *                                 .responseType("responseType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualNodeName("virtualNodeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.862Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.CfnVirtualNodeProps")
@software.amazon.jsii.Jsii.Proxy(CfnVirtualNodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVirtualNodeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the service mesh to create the virtual node in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshName();

    /**
     * The virtual node specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpec();

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return null;
    }

    /**
     * Optional metadata that you can apply to the virtual node to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The name to use for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualNodeName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVirtualNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVirtualNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVirtualNodeProps> {
        java.lang.String meshName;
        java.lang.Object spec;
        java.lang.String meshOwner;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String virtualNodeName;

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getMeshName}
         * @param meshName The name of the service mesh to create the virtual node in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(java.lang.String meshName) {
            this.meshName = meshName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getSpec}
         * @param spec The virtual node specification to apply. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.services.appmesh.CfnVirtualNode.VirtualNodeSpecProperty spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getSpec}
         * @param spec The virtual node specification to apply. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.core.IResolvable spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getMeshOwner}
         * @param meshOwner The AWS IAM account ID of the service mesh owner.
         *                  If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(java.lang.String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getTags}
         * @param tags Optional metadata that you can apply to the virtual node to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualNodeProps#getVirtualNodeName}
         * @param virtualNodeName The name to use for the virtual node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeName(java.lang.String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVirtualNodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVirtualNodeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVirtualNodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVirtualNodeProps {
        private final java.lang.String meshName;
        private final java.lang.Object spec;
        private final java.lang.String meshOwner;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String virtualNodeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meshName = software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.meshOwner = software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.virtualNodeName = software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meshName = java.util.Objects.requireNonNull(builder.meshName, "meshName is required");
            this.spec = java.util.Objects.requireNonNull(builder.spec, "spec is required");
            this.meshOwner = builder.meshOwner;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.virtualNodeName = builder.virtualNodeName;
        }

        @Override
        public final java.lang.String getMeshName() {
            return this.meshName;
        }

        @Override
        public final java.lang.Object getSpec() {
            return this.spec;
        }

        @Override
        public final java.lang.String getMeshOwner() {
            return this.meshOwner;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meshName", om.valueToTree(this.getMeshName()));
            data.set("spec", om.valueToTree(this.getSpec()));
            if (this.getMeshOwner() != null) {
                data.set("meshOwner", om.valueToTree(this.getMeshOwner()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVirtualNodeName() != null) {
                data.set("virtualNodeName", om.valueToTree(this.getVirtualNodeName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appmesh.CfnVirtualNodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVirtualNodeProps.Jsii$Proxy that = (CfnVirtualNodeProps.Jsii$Proxy) o;

            if (!meshName.equals(that.meshName)) return false;
            if (!spec.equals(that.spec)) return false;
            if (this.meshOwner != null ? !this.meshOwner.equals(that.meshOwner) : that.meshOwner != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.virtualNodeName != null ? this.virtualNodeName.equals(that.virtualNodeName) : that.virtualNodeName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.meshName.hashCode();
            result = 31 * result + (this.spec.hashCode());
            result = 31 * result + (this.meshOwner != null ? this.meshOwner.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.virtualNodeName != null ? this.virtualNodeName.hashCode() : 0);
            return result;
        }
    }
}
