package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * GatewayRouteSpec gatewayRouteSpec;
 * VirtualGateway virtualGateway;
 * GatewayRoute gatewayRoute = GatewayRoute.Builder.create(this, "MyGatewayRoute")
 *         .routeSpec(gatewayRouteSpec)
 *         .virtualGateway(virtualGateway)
 *         // the properties below are optional
 *         .gatewayRouteName("gatewayRouteName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.879Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.GatewayRoute")
public class GatewayRoute extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.appmesh.IGatewayRoute {

    protected GatewayRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GatewayRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GatewayRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing GatewayRoute given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param gatewayRouteArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IGatewayRoute fromGatewayRouteArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String gatewayRouteArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRoute.class, "fromGatewayRouteArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IGatewayRoute.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(gatewayRouteArn, "gatewayRouteArn is required") });
    }

    /**
     * (experimental) Import an existing GatewayRoute given attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IGatewayRoute fromGatewayRouteAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRoute.class, "fromGatewayRouteAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IGatewayRoute.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) The Amazon Resource Name (ARN) for the GatewayRoute.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getGatewayRouteArn() {
        return software.amazon.jsii.Kernel.get(this, "gatewayRouteArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the GatewayRoute.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getGatewayRouteName() {
        return software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The VirtualGateway this GatewayRoute is a part of.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway getVirtualGateway() {
        return software.amazon.jsii.Kernel.get(this, "virtualGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appmesh.GatewayRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.GatewayRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.GatewayRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.GatewayRouteProps.Builder();
        }

        /**
         * (experimental) What protocol the route uses.
         * <p>
         * @return {@code this}
         * @param routeSpec What protocol the route uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeSpec(final software.amazon.awscdk.services.appmesh.GatewayRouteSpec routeSpec) {
            this.props.routeSpec(routeSpec);
            return this;
        }

        /**
         * (experimental) The name of the GatewayRoute.
         * <p>
         * Default: - an automatically generated name
         * <p>
         * @return {@code this}
         * @param gatewayRouteName The name of the GatewayRoute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gatewayRouteName(final java.lang.String gatewayRouteName) {
            this.props.gatewayRouteName(gatewayRouteName);
            return this;
        }

        /**
         * (experimental) The VirtualGateway this GatewayRoute is associated with.
         * <p>
         * @return {@code this}
         * @param virtualGateway The VirtualGateway this GatewayRoute is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualGateway(final software.amazon.awscdk.services.appmesh.IVirtualGateway virtualGateway) {
            this.props.virtualGateway(virtualGateway);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.GatewayRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appmesh.GatewayRoute build() {
            return new software.amazon.awscdk.services.appmesh.GatewayRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
