package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) gRPC events.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-grpc-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.grpc(GrpcRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .match(GrpcRouteMatch.builder().serviceName("servicename").build())
 *                 .retryPolicy(GrpcRetryPolicy.builder()
 *                         .tcpRetryEvents(List.of(TcpRetryEvent.CONNECTION_ERROR))
 *                         .httpRetryEvents(List.of(HttpRetryEvent.GATEWAY_ERROR))
 *                         // Retry if gRPC responds that the request was cancelled, a resource
 *                         // was exhausted, or if the service is unavailable
 *                         .grpcRetryEvents(List.of(GrpcRetryEvent.CANCELLED, GrpcRetryEvent.RESOURCE_EXHAUSTED, GrpcRetryEvent.UNAVAILABLE))
 *                         .retryAttempts(5)
 *                         .retryTimeout(Duration.seconds(1))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.917Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.GrpcRetryEvent")
public enum GrpcRetryEvent {
    /**
     * (experimental) Request was cancelled.
     * <p>
     * @see <a href="https://grpc.github.io/grpc/core/md_doc_statuscodes.html">https://grpc.github.io/grpc/core/md_doc_statuscodes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CANCELLED,
    /**
     * (experimental) The deadline was exceeded.
     * <p>
     * @see <a href="https://grpc.github.io/grpc/core/md_doc_statuscodes.html">https://grpc.github.io/grpc/core/md_doc_statuscodes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DEADLINE_EXCEEDED,
    /**
     * (experimental) Internal error.
     * <p>
     * @see <a href="https://grpc.github.io/grpc/core/md_doc_statuscodes.html">https://grpc.github.io/grpc/core/md_doc_statuscodes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INTERNAL_ERROR,
    /**
     * (experimental) A resource was exhausted.
     * <p>
     * @see <a href="https://grpc.github.io/grpc/core/md_doc_statuscodes.html">https://grpc.github.io/grpc/core/md_doc_statuscodes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RESOURCE_EXHAUSTED,
    /**
     * (experimental) The service is unavailable.
     * <p>
     * @see <a href="https://grpc.github.io/grpc/core/md_doc_statuscodes.html">https://grpc.github.io/grpc/core/md_doc_statuscodes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UNAVAILABLE,
}
