package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Supported values for matching routes based on the HTTP request method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.exactly("/exact"))
 *                         .method(HttpRouteMethod.POST)
 *                         .protocol(HttpRouteProtocol.HTTPS)
 *                         .headers(List.of(HeaderMatch.valueIs("Content-Type", "application/json"), HeaderMatch.valueIsNot("Content-Type", "application/json")))
 *                         .queryParameters(List.of(QueryParameterMatch.valueIs("query-field", "value")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.948Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.HttpRouteMethod")
public enum HttpRouteMethod {
    /**
     * (experimental) GET request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GET,
    /**
     * (experimental) HEAD request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    HEAD,
    /**
     * (experimental) POST request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    POST,
    /**
     * (experimental) PUT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PUT,
    /**
     * (experimental) DELETE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DELETE,
    /**
     * (experimental) CONNECT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CONNECT,
    /**
     * (experimental) OPTIONS request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OPTIONS,
    /**
     * (experimental) TRACE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TRACE,
    /**
     * (experimental) PATCH request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PATCH,
}
