package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Used to generate query parameter matching methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.exactly("/exact"))
 *                         .method(HttpRouteMethod.POST)
 *                         .protocol(HttpRouteProtocol.HTTPS)
 *                         .headers(List.of(HeaderMatch.valueIs("Content-Type", "application/json"), HeaderMatch.valueIsNot("Content-Type", "application/json")))
 *                         .queryParameters(List.of(QueryParameterMatch.valueIs("query-field", "value")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:54.972Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.QueryParameterMatch")
public abstract class QueryParameterMatch extends software.amazon.jsii.JsiiObject {

    protected QueryParameterMatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueryParameterMatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected QueryParameterMatch() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) The value of the query parameter with the given name in the request must match the specified value exactly.
     * <p>
     * @param queryParameterName the name of the query parameter to match against. This parameter is required.
     * @param queryParameterValue The exact value to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.QueryParameterMatch valueIs(final @org.jetbrains.annotations.NotNull java.lang.String queryParameterName, final @org.jetbrains.annotations.NotNull java.lang.String queryParameterValue) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.QueryParameterMatch.class, "valueIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.QueryParameterMatch.class), new Object[] { java.util.Objects.requireNonNull(queryParameterName, "queryParameterName is required"), java.util.Objects.requireNonNull(queryParameterValue, "queryParameterValue is required") });
    }

    /**
     * (experimental) Returns the query parameter match configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.QueryParameterMatchConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.QueryParameterMatch {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Returns the query parameter match configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.QueryParameterMatchConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.QueryParameterMatchConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
