package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Provides the Service Discovery method a VirtualNode uses.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.ServiceDiscovery")
public abstract class ServiceDiscovery extends software.amazon.jsii.JsiiObject {

    protected ServiceDiscovery(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServiceDiscovery(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected ServiceDiscovery() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Returns Cloud Map based service discovery.
     * <p>
     * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
     * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery cloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> instanceAttributes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "cloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required"), instanceAttributes });
    }

    /**
     * (experimental) Returns Cloud Map based service discovery.
     * <p>
     * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery cloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService service) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "cloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * (experimental) Returns DNS based service discovery.
     * <p>
     * @param hostname This parameter is required.
     * @param responseType Specifies the DNS response type for the virtual node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery dns(final @org.jetbrains.annotations.NotNull java.lang.String hostname, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.DnsResponseType responseType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "dns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(hostname, "hostname is required"), responseType });
    }

    /**
     * (experimental) Returns DNS based service discovery.
     * <p>
     * @param hostname This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscovery dns(final @org.jetbrains.annotations.NotNull java.lang.String hostname) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class, "dns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class), new Object[] { java.util.Objects.requireNonNull(hostname, "hostname is required") });
    }

    /**
     * (experimental) Binds the current object when adding Service Discovery to a VirtualNode.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.ServiceDiscovery {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Binds the current object when adding Service Discovery to a VirtualNode.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscoveryConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
