package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) TCP events on which you may retry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .retryPolicy(HttpRetryPolicy.builder()
 *                         // Retry if the connection failed
 *                         .tcpRetryEvents(List.of(TcpRetryEvent.CONNECTION_ERROR))
 *                         // Retry if HTTP responds with a gateway error (502, 503, 504)
 *                         .httpRetryEvents(List.of(HttpRetryEvent.GATEWAY_ERROR))
 *                         // Retry five times
 *                         .retryAttempts(5)
 *                         // Use a 1 second timeout per retry
 *                         .retryTimeout(Duration.seconds(1))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appmesh.TcpRetryEvent")
public enum TcpRetryEvent {
    /**
     * (experimental) A connection error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CONNECTION_ERROR,
}
