package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the CodeRepository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * GitHubConnection gitHubConnection;
 * Runtime runtime;
 * CodeRepositoryProps codeRepositoryProps = CodeRepositoryProps.builder()
 *         .codeConfiguration(CodeConfiguration.builder()
 *                 .configurationSource(ConfigurationSourceType.REPOSITORY)
 *                 // the properties below are optional
 *                 .configurationValues(CodeConfigurationValues.builder()
 *                         .runtime(runtime)
 *                         // the properties below are optional
 *                         .buildCommand("buildCommand")
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .port("port")
 *                         .startCommand("startCommand")
 *                         .build())
 *                 .build())
 *         .connection(gitHubConnection)
 *         .repositoryUrl("repositoryUrl")
 *         .sourceCodeVersion(SourceCodeVersion.builder()
 *                 .type("type")
 *                 .value("value")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.124Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.CodeRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(CodeRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Configuration for building and running the service from a source code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CodeConfiguration getCodeConfiguration();

    /**
     * (experimental) The App Runner connection for GitHub.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GitHubConnection getConnection();

    /**
     * (experimental) The location of the repository that contains the source code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

    /**
     * (experimental) The version that should be used within the source code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.SourceCodeVersion getSourceCodeVersion();

    /**
     * @return a {@link Builder} of {@link CodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProps> {
        software.amazon.awscdk.services.apprunner.CodeConfiguration codeConfiguration;
        software.amazon.awscdk.services.apprunner.GitHubConnection connection;
        java.lang.String repositoryUrl;
        software.amazon.awscdk.services.apprunner.SourceCodeVersion sourceCodeVersion;

        /**
         * Sets the value of {@link CodeRepositoryProps#getCodeConfiguration}
         * @param codeConfiguration Configuration for building and running the service from a source code repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeConfiguration(software.amazon.awscdk.services.apprunner.CodeConfiguration codeConfiguration) {
            this.codeConfiguration = codeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CodeRepositoryProps#getConnection}
         * @param connection The App Runner connection for GitHub. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(software.amazon.awscdk.services.apprunner.GitHubConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link CodeRepositoryProps#getRepositoryUrl}
         * @param repositoryUrl The location of the repository that contains the source code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryUrl(java.lang.String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        /**
         * Sets the value of {@link CodeRepositoryProps#getSourceCodeVersion}
         * @param sourceCodeVersion The version that should be used within the source code repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sourceCodeVersion(software.amazon.awscdk.services.apprunner.SourceCodeVersion sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProps {
        private final software.amazon.awscdk.services.apprunner.CodeConfiguration codeConfiguration;
        private final software.amazon.awscdk.services.apprunner.GitHubConnection connection;
        private final java.lang.String repositoryUrl;
        private final software.amazon.awscdk.services.apprunner.SourceCodeVersion sourceCodeVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.codeConfiguration = software.amazon.jsii.Kernel.get(this, "codeConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.CodeConfiguration.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.GitHubConnection.class));
            this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceCodeVersion = software.amazon.jsii.Kernel.get(this, "sourceCodeVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.SourceCodeVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.codeConfiguration = java.util.Objects.requireNonNull(builder.codeConfiguration, "codeConfiguration is required");
            this.connection = java.util.Objects.requireNonNull(builder.connection, "connection is required");
            this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
            this.sourceCodeVersion = java.util.Objects.requireNonNull(builder.sourceCodeVersion, "sourceCodeVersion is required");
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.CodeConfiguration getCodeConfiguration() {
            return this.codeConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.GitHubConnection getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.SourceCodeVersion getSourceCodeVersion() {
            return this.sourceCodeVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("codeConfiguration", om.valueToTree(this.getCodeConfiguration()));
            data.set("connection", om.valueToTree(this.getConnection()));
            data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));
            data.set("sourceCodeVersion", om.valueToTree(this.getSourceCodeVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.CodeRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeRepositoryProps.Jsii$Proxy that = (CodeRepositoryProps.Jsii$Proxy) o;

            if (!codeConfiguration.equals(that.codeConfiguration)) return false;
            if (!connection.equals(that.connection)) return false;
            if (!repositoryUrl.equals(that.repositoryUrl)) return false;
            return this.sourceCodeVersion.equals(that.sourceCodeVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.codeConfiguration.hashCode();
            result = 31 * result + (this.connection.hashCode());
            result = 31 * result + (this.repositoryUrl.hashCode());
            result = 31 * result + (this.sourceCodeVersion.hashCode());
            return result;
        }
    }
}
