package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Represents the service source from ECR.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * import software.amazon.awscdk.services.ecr.*;
 * Repository repository;
 * EcrSource ecrSource = EcrSource.Builder.create()
 *         .repository(repository)
 *         // the properties below are optional
 *         .imageConfiguration(ImageConfiguration.builder()
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .port(123)
 *                 .startCommand("startCommand")
 *                 .build())
 *         .tag("tag")
 *         .tagOrDigest("tagOrDigest")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.EcrSource")
public class EcrSource extends software.amazon.awscdk.services.apprunner.Source {

    protected EcrSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcrSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EcrSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.EcrProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.SourceConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.SourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apprunner.EcrSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.EcrSource> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.apprunner.EcrProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.apprunner.EcrProps.Builder();
        }

        /**
         * (experimental) Represents the ECR repository.
         * <p>
         * @return {@code this}
         * @param repository Represents the ECR repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repository(final software.amazon.awscdk.services.ecr.IRepository repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * (experimental) The image configuration for the image from ECR.
         * <p>
         * Default: - no image configuration will be passed. The default `port` will be 8080.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-imageconfiguration.html#cfn-apprunner-service-imageconfiguration-port</a>
         * @param imageConfiguration The image configuration for the image from ECR. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageConfiguration(final software.amazon.awscdk.services.apprunner.ImageConfiguration imageConfiguration) {
            this.props.imageConfiguration(imageConfiguration);
            return this;
        }

        /**
         * (deprecated) Image tag.
         * <p>
         * Default: - 'latest'
         * <p>
         * @return {@code this}
         * @deprecated use `tagOrDigest`
         * @param tag Image tag. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder tag(final java.lang.String tag) {
            this.props.tag(tag);
            return this;
        }

        /**
         * (experimental) Image tag or digest (digests must start with `sha256:`).
         * <p>
         * Default: - 'latest'
         * <p>
         * @return {@code this}
         * @param tagOrDigest Image tag or digest (digests must start with `sha256:`). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tagOrDigest(final java.lang.String tagOrDigest) {
            this.props.tagOrDigest(tagOrDigest);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.EcrSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apprunner.EcrSource build() {
            return new software.amazon.awscdk.services.apprunner.EcrSource(
                this.props.build()
            );
        }
    }
}
