package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Properties of the Github repository for `Source.fromGitHub()`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromGitHub(GithubRepositoryProps.builder()
 *                 .repositoryUrl("https://github.com/aws-containers/hello-app-runner")
 *                 .branch("main")
 *                 .configurationSource(ConfigurationSourceType.REPOSITORY)
 *                 .connection(GitHubConnection.fromConnectionArn("CONNECTION_ARN"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.132Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.GithubRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(GithubRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface GithubRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The source of the App Runner configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.ConfigurationSourceType getConfigurationSource();

    /**
     * (experimental) ARN of the connection to Github.
     * <p>
     * Only required for Github source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.GitHubConnection getConnection();

    /**
     * (experimental) The location of the repository that contains the source code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

    /**
     * (experimental) The branch name that represents a specific version for the repository.
     * <p>
     * Default: main
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranch() {
        return null;
    }

    /**
     * (experimental) The code configuration values.
     * <p>
     * Will be ignored if configurationSource is <code>REPOSITORY</code>.
     * <p>
     * Default: - no values will be passed. The `apprunner.yaml` from the github reopsitory will be used instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apprunner.CodeConfigurationValues getCodeConfigurationValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GithubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GithubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<GithubRepositoryProps> {
        software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource;
        software.amazon.awscdk.services.apprunner.GitHubConnection connection;
        java.lang.String repositoryUrl;
        java.lang.String branch;
        software.amazon.awscdk.services.apprunner.CodeConfigurationValues codeConfigurationValues;

        /**
         * Sets the value of {@link GithubRepositoryProps#getConfigurationSource}
         * @param configurationSource The source of the App Runner configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationSource(software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        /**
         * Sets the value of {@link GithubRepositoryProps#getConnection}
         * @param connection ARN of the connection to Github. This parameter is required.
         *                   Only required for Github source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(software.amazon.awscdk.services.apprunner.GitHubConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link GithubRepositoryProps#getRepositoryUrl}
         * @param repositoryUrl The location of the repository that contains the source code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryUrl(java.lang.String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        /**
         * Sets the value of {@link GithubRepositoryProps#getBranch}
         * @param branch The branch name that represents a specific version for the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder branch(java.lang.String branch) {
            this.branch = branch;
            return this;
        }

        /**
         * Sets the value of {@link GithubRepositoryProps#getCodeConfigurationValues}
         * @param codeConfigurationValues The code configuration values.
         *                                Will be ignored if configurationSource is <code>REPOSITORY</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeConfigurationValues(software.amazon.awscdk.services.apprunner.CodeConfigurationValues codeConfigurationValues) {
            this.codeConfigurationValues = codeConfigurationValues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GithubRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public GithubRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GithubRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GithubRepositoryProps {
        private final software.amazon.awscdk.services.apprunner.ConfigurationSourceType configurationSource;
        private final software.amazon.awscdk.services.apprunner.GitHubConnection connection;
        private final java.lang.String repositoryUrl;
        private final java.lang.String branch;
        private final software.amazon.awscdk.services.apprunner.CodeConfigurationValues codeConfigurationValues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSource = software.amazon.jsii.Kernel.get(this, "configurationSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.ConfigurationSourceType.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.GitHubConnection.class));
            this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeConfigurationValues = software.amazon.jsii.Kernel.get(this, "codeConfigurationValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apprunner.CodeConfigurationValues.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSource = java.util.Objects.requireNonNull(builder.configurationSource, "configurationSource is required");
            this.connection = java.util.Objects.requireNonNull(builder.connection, "connection is required");
            this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
            this.branch = builder.branch;
            this.codeConfigurationValues = builder.codeConfigurationValues;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.ConfigurationSourceType getConfigurationSource() {
            return this.configurationSource;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.GitHubConnection getConnection() {
            return this.connection;
        }

        @Override
        public final java.lang.String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Override
        public final java.lang.String getBranch() {
            return this.branch;
        }

        @Override
        public final software.amazon.awscdk.services.apprunner.CodeConfigurationValues getCodeConfigurationValues() {
            return this.codeConfigurationValues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationSource", om.valueToTree(this.getConfigurationSource()));
            data.set("connection", om.valueToTree(this.getConnection()));
            data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));
            if (this.getBranch() != null) {
                data.set("branch", om.valueToTree(this.getBranch()));
            }
            if (this.getCodeConfigurationValues() != null) {
                data.set("codeConfigurationValues", om.valueToTree(this.getCodeConfigurationValues()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.GithubRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GithubRepositoryProps.Jsii$Proxy that = (GithubRepositoryProps.Jsii$Proxy) o;

            if (!configurationSource.equals(that.configurationSource)) return false;
            if (!connection.equals(that.connection)) return false;
            if (!repositoryUrl.equals(that.repositoryUrl)) return false;
            if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
            return this.codeConfigurationValues != null ? this.codeConfigurationValues.equals(that.codeConfigurationValues) : that.codeConfigurationValues == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSource.hashCode();
            result = 31 * result + (this.connection.hashCode());
            result = 31 * result + (this.repositoryUrl.hashCode());
            result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
            result = 31 * result + (this.codeConfigurationValues != null ? this.codeConfigurationValues.hashCode() : 0);
            return result;
        }
    }
}
