package software.amazon.awscdk.services.apprunner;

/**
 * (experimental) Attributes for the App Runner Service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * ServiceAttributes serviceAttributes = ServiceAttributes.builder()
 *         .serviceArn("serviceArn")
 *         .serviceName("serviceName")
 *         .serviceStatus("serviceStatus")
 *         .serviceUrl("serviceUrl")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.142Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_apprunner.ServiceAttributes")
@software.amazon.jsii.Jsii.Proxy(ServiceAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ServiceAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The ARN of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceArn();

    /**
     * (experimental) The name of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

    /**
     * (experimental) The status of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceStatus();

    /**
     * (experimental) The URL of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceUrl();

    /**
     * @return a {@link Builder} of {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceAttributes> {
        java.lang.String serviceArn;
        java.lang.String serviceName;
        java.lang.String serviceStatus;
        java.lang.String serviceUrl;

        /**
         * Sets the value of {@link ServiceAttributes#getServiceArn}
         * @param serviceArn The ARN of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceArn(java.lang.String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceName}
         * @param serviceName The name of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceStatus}
         * @param serviceStatus The status of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceStatus(java.lang.String serviceStatus) {
            this.serviceStatus = serviceStatus;
            return this;
        }

        /**
         * Sets the value of {@link ServiceAttributes#getServiceUrl}
         * @param serviceUrl The URL of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceUrl(java.lang.String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ServiceAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceAttributes {
        private final java.lang.String serviceArn;
        private final java.lang.String serviceName;
        private final java.lang.String serviceStatus;
        private final java.lang.String serviceUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceArn = software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceStatus = software.amazon.jsii.Kernel.get(this, "serviceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceUrl = software.amazon.jsii.Kernel.get(this, "serviceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceArn = java.util.Objects.requireNonNull(builder.serviceArn, "serviceArn is required");
            this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
            this.serviceStatus = java.util.Objects.requireNonNull(builder.serviceStatus, "serviceStatus is required");
            this.serviceUrl = java.util.Objects.requireNonNull(builder.serviceUrl, "serviceUrl is required");
        }

        @Override
        public final java.lang.String getServiceArn() {
            return this.serviceArn;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final java.lang.String getServiceStatus() {
            return this.serviceStatus;
        }

        @Override
        public final java.lang.String getServiceUrl() {
            return this.serviceUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceArn", om.valueToTree(this.getServiceArn()));
            data.set("serviceName", om.valueToTree(this.getServiceName()));
            data.set("serviceStatus", om.valueToTree(this.getServiceStatus()));
            data.set("serviceUrl", om.valueToTree(this.getServiceUrl()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_apprunner.ServiceAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceAttributes.Jsii$Proxy that = (ServiceAttributes.Jsii$Proxy) o;

            if (!serviceArn.equals(that.serviceArn)) return false;
            if (!serviceName.equals(that.serviceName)) return false;
            if (!serviceStatus.equals(that.serviceStatus)) return false;
            return this.serviceUrl.equals(that.serviceUrl);
        }

        @Override
        public final int hashCode() {
            int result = this.serviceArn.hashCode();
            result = 31 * result + (this.serviceName.hashCode());
            result = 31 * result + (this.serviceStatus.hashCode());
            result = 31 * result + (this.serviceUrl.hashCode());
            return result;
        }
    }
}
