package software.amazon.awscdk.services.appsync;

/**
 * (experimental) the CDK properties for AppSync Functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("appsync_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.AppsyncFunctionProps")
@software.amazon.jsii.Jsii.Proxy(AppsyncFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AppsyncFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.BaseAppsyncFunctionProps {

    /**
     * (experimental) the GraphQL Api linked to this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getApi();

    /**
     * (experimental) the data source linked to this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseDataSource getDataSource();

    /**
     * @return a {@link Builder} of {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AppsyncFunctionProps> {
        software.amazon.awscdk.services.appsync.IGraphqlApi api;
        software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        java.lang.String name;
        java.lang.String description;
        software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;

        /**
         * Sets the value of {@link AppsyncFunctionProps#getApi}
         * @param api the GraphQL Api linked to this AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getDataSource}
         * @param dataSource the data source linked to this AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getName}
         * @param name the name of the AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getDescription}
         * @param description the description for this AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getRequestMappingTemplate}
         * @param requestMappingTemplate the request mapping template for the AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getResponseMappingTemplate}
         * @param responseMappingTemplate the response mapping template for the AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppsyncFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AppsyncFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppsyncFunctionProps {
        private final software.amazon.awscdk.services.appsync.IGraphqlApi api;
        private final software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        private final java.lang.String name;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        private final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.BaseDataSource.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.responseMappingTemplate = builder.responseMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IGraphqlApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            data.set("dataSource", om.valueToTree(this.getDataSource()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appsync.AppsyncFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppsyncFunctionProps.Jsii$Proxy that = (AppsyncFunctionProps.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (!dataSource.equals(that.dataSource)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            return this.responseMappingTemplate != null ? this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.dataSource.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            return result;
        }
    }
}
