package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Configuration of the API authorization modes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .schema(Schema.fromAsset(join(__dirname, "schema.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.IAM)
 *                         .build())
 *                 .build())
 *         .xrayEnabled(true)
 *         .build();
 * Table demoTable = Table.Builder.create(this, "DemoTable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * DynamoDbDataSource demoDS = api.addDynamoDbDataSource("demoDataSource", demoTable);
 * // Resolver for the Query "getDemos" that scans the DynamoDb table and returns the entire list.
 * demoDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemos")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable())
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * // Resolver for the Mutation "addDemo" that puts the item into the DynamoDb table.
 * demoDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemo")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbPutItem(PrimaryKey.partition("id").auto(), Values.projecting("input")))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultItem())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.288Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.AuthorizationConfig")
@software.amazon.jsii.Jsii.Proxy(AuthorizationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AuthorizationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Additional authorization modes.
     * <p>
     * Default: - No other modes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> getAdditionalAuthorizationModes() {
        return null;
    }

    /**
     * (experimental) Optional authorization configuration.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AuthorizationMode getDefaultAuthorization() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfig> {
        java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes;
        software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization;

        /**
         * Sets the value of {@link AuthorizationConfig#getAdditionalAuthorizationModes}
         * @param additionalAuthorizationModes Additional authorization modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder additionalAuthorizationModes(java.util.List<? extends software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes) {
            this.additionalAuthorizationModes = (java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode>)additionalAuthorizationModes;
            return this;
        }

        /**
         * Sets the value of {@link AuthorizationConfig#getDefaultAuthorization}
         * @param defaultAuthorization Optional authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultAuthorization(software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization) {
            this.defaultAuthorization = defaultAuthorization;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthorizationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AuthorizationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AuthorizationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfig {
        private final java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> additionalAuthorizationModes;
        private final software.amazon.awscdk.services.appsync.AuthorizationMode defaultAuthorization;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalAuthorizationModes = software.amazon.jsii.Kernel.get(this, "additionalAuthorizationModes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationMode.class)));
            this.defaultAuthorization = software.amazon.jsii.Kernel.get(this, "defaultAuthorization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalAuthorizationModes = (java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode>)builder.additionalAuthorizationModes;
            this.defaultAuthorization = builder.defaultAuthorization;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AuthorizationMode> getAdditionalAuthorizationModes() {
            return this.additionalAuthorizationModes;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AuthorizationMode getDefaultAuthorization() {
            return this.defaultAuthorization;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalAuthorizationModes() != null) {
                data.set("additionalAuthorizationModes", om.valueToTree(this.getAdditionalAuthorizationModes()));
            }
            if (this.getDefaultAuthorization() != null) {
                data.set("defaultAuthorization", om.valueToTree(this.getDefaultAuthorization()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appsync.AuthorizationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthorizationConfig.Jsii$Proxy that = (AuthorizationConfig.Jsii$Proxy) o;

            if (this.additionalAuthorizationModes != null ? !this.additionalAuthorizationModes.equals(that.additionalAuthorizationModes) : that.additionalAuthorizationModes != null) return false;
            return this.defaultAuthorization != null ? this.defaultAuthorization.equals(that.defaultAuthorization) : that.defaultAuthorization == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalAuthorizationModes != null ? this.additionalAuthorizationModes.hashCode() : 0;
            result = 31 * result + (this.defaultAuthorization != null ? this.defaultAuthorization.hashCode() : 0);
            return result;
        }
    }
}
