package software.amazon.awscdk.services.appsync;

/**
 * (experimental) An AppSync GraphQL API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .build();
 * ObjectType demo = ObjectType.Builder.create("Demo")
 *         .definition(Map.of(
 *                 "id", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build()),
 *                 "version", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build())))
 *         .build();
 * api.addType(demo);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.GraphqlApi")
public class GraphqlApi extends software.amazon.awscdk.services.appsync.GraphqlApiBase {

    protected GraphqlApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GraphqlApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import a GraphQL API through this function.
     * <p>
     * @param scope scope. This parameter is required.
     * @param id id. This parameter is required.
     * @param attrs GraphQL API Attributes of an API. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi fromGraphqlApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlApi.class, "fromGraphqlApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Add a mutation field to the schema's Mutation. CDK will create an Object Type called 'Mutation'. For example,.
     * <p>
     * type Mutation {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the Mutation. This parameter is required.
     * @param field the resolvable field to for this Mutation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addMutation(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableField field) {
        return software.amazon.jsii.Kernel.call(this, "addMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Add a query field to the schema's Query. CDK will create an Object Type called 'Query'. For example,.
     * <p>
     * type Query {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the query. This parameter is required.
     * @param field the resolvable field to for this query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addQuery(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableField field) {
        return software.amazon.jsii.Kernel.call(this, "addQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Add schema dependency to a given construct.
     * <p>
     * @param construct the dependee. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addSchemaDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResource construct) {
        return software.amazon.jsii.Kernel.call(this, "addSchemaDependency", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * (experimental) Add a subscription field to the schema's Subscription. CDK will create an Object Type called 'Subscription'. For example,.
     * <p>
     * type Subscription {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the Subscription. This parameter is required.
     * @param field the resolvable field to for this Subscription. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addSubscription(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableField field) {
        return software.amazon.jsii.Kernel.call(this, "addSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Escape hatch to append to Schema as desired.
     * <p>
     * Will always result
     * in a newline.
     * <p>
     * Default: - ''
     * <p>
     * @param addition the addition to add to schema. This parameter is required.
     * @param delimiter the delimiter between schema and addition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToSchema(final @org.jetbrains.annotations.NotNull java.lang.String addition, final @org.jetbrains.annotations.Nullable java.lang.String delimiter) {
        software.amazon.jsii.Kernel.call(this, "addToSchema", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(addition, "addition is required"), delimiter });
    }

    /**
     * (experimental) Escape hatch to append to Schema as desired.
     * <p>
     * Will always result
     * in a newline.
     * <p>
     * Default: - ''
     * <p>
     * @param addition the addition to add to schema. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToSchema(final @org.jetbrains.annotations.NotNull java.lang.String addition) {
        software.amazon.jsii.Kernel.call(this, "addToSchema", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(addition, "addition is required") });
    }

    /**
     * (experimental) Add type to the schema.
     * <p>
     * @param type the intermediate type to add to the schema. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IIntermediateType addType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IIntermediateType type) {
        return software.amazon.jsii.Kernel.call(this, "addType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IIntermediateType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...). This parameter is required.
     * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Mutations (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantMutation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Queries (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Subscriptions (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * (experimental) an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the ARN of the API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the URL of the endpoint created by AppSync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getGraphqlUrl() {
        return software.amazon.jsii.Kernel.get(this, "graphqlUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The Authorization Types for this GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))));
    }

    /**
     * (experimental) the name of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the schema attached to this api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Schema getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Schema.class));
    }

    /**
     * (experimental) the configured API key, if present.
     * <p>
     * Default: - no api key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiKey() {
        return software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.GraphqlApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.GraphqlApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.GraphqlApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.GraphqlApiProps.Builder();
        }

        /**
         * (experimental) the name of the GraphQL API.
         * <p>
         * @return {@code this}
         * @param name the name of the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) Optional authorization configuration.
         * <p>
         * Default: - API Key authorization
         * <p>
         * @return {@code this}
         * @param authorizationConfig Optional authorization configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizationConfig(final software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        /**
         * (experimental) The domain name configuration for the GraphQL API.
         * <p>
         * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         * enable custom domain URL
         * <p>
         * Default: - no domain name
         * <p>
         * @return {@code this}
         * @param domainName The domain name configuration for the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final software.amazon.awscdk.services.appsync.DomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) Logging configuration for this api.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param logConfig Logging configuration for this api. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * (experimental) GraphQL schema definition. Specify how you want to define your schema.
         * <p>
         * Schema.fromFile(filePath: string) allows schema definition through schema.graphql file
         * <p>
         * Default: - schema will be generated code-first (i.e. addType, addObjectType, etc.)
         * <p>
         * @return {@code this}
         * @param schema GraphQL schema definition. Specify how you want to define your schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder schema(final software.amazon.awscdk.services.appsync.Schema schema) {
            this.props.schema(schema);
            return this;
        }

        /**
         * (experimental) A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param xrayEnabled A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder xrayEnabled(final java.lang.Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.GraphqlApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.GraphqlApi build() {
            return new software.amazon.awscdk.services.appsync.GraphqlApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
