package software.amazon.awscdk.services.appsync;

/**
 * (experimental) The GraphQL Types in AppSync's GraphQL.
 * <p>
 * GraphQL Types are the
 * building blocks for object types, queries, mutations, etc. They are
 * types like String, Int, Id or even Object Types you create.
 * <p>
 * i.e. <code>String</code>, <code>String!</code>, <code>[String]</code>, <code>[String!]</code>, <code>[String]!</code>
 * <p>
 * GraphQL Types are used to define the entirety of schema.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * ObjectType info = ObjectType.Builder.create("Info")
 *         .definition(Map.of(
 *                 "node", ResolvableField.Builder.create()
 *                         .returnType(GraphqlType.string())
 *                         .args(Map.of(
 *                                 "id", GraphqlType.string()))
 *                         .dataSource(api.addNoneDataSource("none"))
 *                         .requestMappingTemplate(dummyRequest)
 *                         .responseMappingTemplate(dummyResponse)
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.417Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.GraphqlType")
public class GraphqlType extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appsync.IField {

    protected GraphqlType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param type This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected GraphqlType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Type type, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.GraphqlTypeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), options });
    }

    /**
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected GraphqlType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Type type) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     * <p>
     * In other words, accepts date strings in the form of <code>YYYY-MM-DD</code>. It accepts time zone offsets.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsDate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsDate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     * <p>
     * In other words, accepts date strings in the form of <code>YYYY-MM-DD</code>. It accepts time zone offsets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsDate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsDate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     * <p>
     * In other words, accepts date strings in the form of <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. It accepts time zone offsets.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsDateTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsDateTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     * <p>
     * In other words, accepts date strings in the form of <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. It accepts time zone offsets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsDateTime() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsDateTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`).
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsEmail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsEmail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsEmail() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsEmail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsIpAddress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsIpAddress", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsIpAddress() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsIpAddress", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSJson` scalar type represents a JSON string.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSJson` scalar type represents a JSON string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsJson() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     * <p>
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsPhone(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsPhone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     * <p>
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsPhone() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsPhone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     * <p>
     * In other words, accepts date strings in the form of <code>hh:mm:ss.sss</code>. It accepts time zone offsets.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     * <p>
     * In other words, accepts date strings in the form of <code>hh:mm:ss.sss</code>. It accepts time zone offsets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsTime() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     * <p>
     * Timestamps are serialized and deserialized as numbers.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsTimestamp(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     * <p>
     * Timestamps are serialized and deserialized as numbers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsTimestamp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `AWSURL` scalar type represetns a valid URL string.
     * <p>
     * URLs wihtout schemes or contain double slashes are considered invalid.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsUrl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `AWSURL` scalar type represetns a valid URL string.
     * <p>
     * URLs wihtout schemes or contain double slashes are considered invalid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType awsUrl() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "awsUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `Boolean` scalar type is a boolean value: true or false.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doBoolean(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "boolean", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `Boolean` scalar type is a boolean value: true or false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doBoolean() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "boolean", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `Float` scalar type is a signed double-precision fractional value.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doFloat(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "float", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `Float` scalar type is a signed double-precision fractional value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doFloat() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "float", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     * <p>
     * Often used as a key for a cache and not intended to be human-readable.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType id(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "id", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     * <p>
     * Often used as a key for a cache and not intended to be human-readable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType id() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "id", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `Int` scalar type is a signed non-fractional numerical value.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doInt(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "int", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `Int` scalar type is a signed non-fractional numerical value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType doInt() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "int", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) an intermediate type to be added as an attribute (i.e. an interface or an object type).
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList - intermediateType.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType intermediate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.GraphqlTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "intermediate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) an intermediate type to be added as an attribute (i.e. an interface or an object type).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType intermediate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "intermediate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) `String` scalar type is a free-form human-readable text.
     * <p>
     * @param options the options to configure this attribute - isList - isRequired - isRequiredList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType string(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "string", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) `String` scalar type is a free-form human-readable text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType string() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlType.class, "string", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) Generate the arguments for this field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String argsToString() {
        return software.amazon.jsii.Kernel.call(this, "argsToString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Generate the directives for this field.
     * <p>
     * @param _modes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String directivesToString(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> _modes) {
        return software.amazon.jsii.Kernel.call(this, "directivesToString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { _modes });
    }

    /**
     * (experimental) Generate the directives for this field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String directivesToString() {
        return software.amazon.jsii.Kernel.call(this, "directivesToString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Generate the string for this attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) property determining if this attribute is a list i.e. if true, attribute would be `[Type]`.
     * <p>
     * Default: - false
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsList() {
        return software.amazon.jsii.Kernel.get(this, "isList", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) property determining if this attribute is non-nullable i.e. if true, attribute would be `Type!` and this attribute must always have a value.
     * <p>
     * Default: - false
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsRequired() {
        return software.amazon.jsii.Kernel.get(this, "isRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) property determining if this attribute is a non-nullable list i.e. if true, attribute would be `[ Type ]!` and this attribute's list must always have a value.
     * <p>
     * Default: - false
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsRequiredList() {
        return software.amazon.jsii.Kernel.get(this, "isRequiredList", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) the type of attribute.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Type getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Type.class));
    }

    /**
     * (experimental) the intermediate type linked to this attribute (i.e. an interface or an object).
     * <p>
     * Default: - no intermediate type
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.IIntermediateType getIntermediateType() {
        return software.amazon.jsii.Kernel.get(this, "intermediateType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IIntermediateType.class));
    }
}
