package software.amazon.awscdk.services.appsync;

/**
 * (experimental) A class used to generate resource arns for AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("lambda.amazonaws.com"))
 *         .build();
 * api.grant(role, IamResource.custom("types/Mutation/fields/updateExample"), "appsync:GraphQL");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.426Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.IamResource")
public class IamResource extends software.amazon.jsii.JsiiObject {

    protected IamResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IamResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Generate the resource names that accepts all types: `*`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.IamResource.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IamResource.class));
    }

    /**
     * (experimental) Generate the resource names given custom arns.
     * <p>
     * @param arns The custom arns that need to be permissioned. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource custom(final @org.jetbrains.annotations.NotNull java.lang.String... arns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.IamResource.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IamResource.class), java.util.Arrays.<Object>stream(arns).toArray(Object[]::new));
    }

    /**
     * (experimental) Generate the resource names given a type and fields.
     * <p>
     * @param type The type that needs to be allowed. This parameter is required.
     * @param fields The fields that need to be allowed, if empty grant permissions to ALL fields. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource ofType(final @org.jetbrains.annotations.NotNull java.lang.String type, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.IamResource.class, "ofType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IamResource.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(type, "type is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * (experimental) Return the Resource ARN.
     * <p>
     * @param api The GraphQL API to give permissions. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> resourceArns(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApi api) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(api, "api is required") }));
    }
}
