package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Properties for configuring an Intermediate Type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InterfaceType node = InterfaceType.Builder.create("Node")
 *         .definition(Map.of(
 *                 "id", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build())))
 *         .build();
 * ObjectType demo = ObjectType.Builder.create("Demo")
 *         .interfaceTypes(List.of(node))
 *         .definition(Map.of(
 *                 "version", GraphqlType.string(BaseTypeOptions.builder().isRequired(true).build())))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.429Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.IntermediateTypeOptions")
@software.amazon.jsii.Jsii.Proxy(IntermediateTypeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IntermediateTypeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) the attributes of this type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> getDefinition();

    /**
     * (experimental) the directives for this object type.
     * <p>
     * Default: - no directives
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntermediateTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntermediateTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IntermediateTypeOptions> {
        java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> definition;
        java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Sets the value of {@link IntermediateTypeOptions#getDefinition}
         * @param definition the attributes of this type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder definition(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.IField> definition) {
            this.definition = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField>)definition;
            return this;
        }

        /**
         * Sets the value of {@link IntermediateTypeOptions#getDirectives}
         * @param directives the directives for this object type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder directives(java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)directives;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntermediateTypeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IntermediateTypeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntermediateTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntermediateTypeOptions {
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> definition;
        private final java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IField.class)));
            this.directives = software.amazon.jsii.Kernel.get(this, "directives", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.definition = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField>)java.util.Objects.requireNonNull(builder.definition, "definition is required");
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)builder.directives;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> getDefinition() {
            return this.definition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
            return this.directives;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("definition", om.valueToTree(this.getDefinition()));
            if (this.getDirectives() != null) {
                data.set("directives", om.valueToTree(this.getDirectives()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appsync.IntermediateTypeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntermediateTypeOptions.Jsii$Proxy that = (IntermediateTypeOptions.Jsii$Proxy) o;

            if (!definition.equals(that.definition)) return false;
            return this.directives != null ? this.directives.equals(that.directives) : that.directives == null;
        }

        @Override
        public final int hashCode() {
            int result = this.definition.hashCode();
            result = 31 * result + (this.directives != null ? this.directives.hashCode() : 0);
            return result;
        }
    }
}
