package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Configuration for Lambda authorization in AppSync.
 * <p>
 * Note that you can only have a single AWS Lambda function configured to authorize your API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Function authFunction;
 * GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .schema(Schema.fromAsset(join(__dirname, "appsync.test.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.LAMBDA)
 *                         .lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder()
 *                                 .handler(authFunction)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.LambdaAuthorizerConfig")
@software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LambdaAuthorizerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The authorizer lambda function.
     * <p>
     * Note: This Lambda function must have the following resource-based policy assigned to it.
     * When configuring Lambda authorizers in the console, this is done for you.
     * To do so with the AWS CLI, run the following:
     * <p>
     * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getHandler();

    /**
     * (experimental) How long the results are cached.
     * <p>
     * Disable caching by setting this to 0.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getResultsCacheTtl() {
        return null;
    }

    /**
     * (experimental) A regular expression for validation of tokens before the Lambda function is called.
     * <p>
     * Default: - no regex filter will be applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getValidationRegex() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerConfig> {
        software.amazon.awscdk.services.lambda.IFunction handler;
        software.amazon.awscdk.core.Duration resultsCacheTtl;
        java.lang.String validationRegex;

        /**
         * Sets the value of {@link LambdaAuthorizerConfig#getHandler}
         * @param handler The authorizer lambda function. This parameter is required.
         *                Note: This Lambda function must have the following resource-based policy assigned to it.
         *                When configuring Lambda authorizers in the console, this is done for you.
         *                To do so with the AWS CLI, run the following:
         *                <p>
         *                <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link LambdaAuthorizerConfig#getResultsCacheTtl}
         * @param resultsCacheTtl How long the results are cached.
         *                        Disable caching by setting this to 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultsCacheTtl(software.amazon.awscdk.core.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Sets the value of {@link LambdaAuthorizerConfig#getValidationRegex}
         * @param validationRegex A regular expression for validation of tokens before the Lambda function is called.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder validationRegex(java.lang.String validationRegex) {
            this.validationRegex = validationRegex;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaAuthorizerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LambdaAuthorizerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerConfig {
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final software.amazon.awscdk.core.Duration resultsCacheTtl;
        private final java.lang.String validationRegex;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.validationRegex = software.amazon.jsii.Kernel.get(this, "validationRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.handler = java.util.Objects.requireNonNull(builder.handler, "handler is required");
            this.resultsCacheTtl = builder.resultsCacheTtl;
            this.validationRegex = builder.validationRegex;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getHandler() {
            return this.handler;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        public final java.lang.String getValidationRegex() {
            return this.validationRegex;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("handler", om.valueToTree(this.getHandler()));
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }
            if (this.getValidationRegex() != null) {
                data.set("validationRegex", om.valueToTree(this.getValidationRegex()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_appsync.LambdaAuthorizerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaAuthorizerConfig.Jsii$Proxy that = (LambdaAuthorizerConfig.Jsii$Proxy) o;

            if (!handler.equals(that.handler)) return false;
            if (this.resultsCacheTtl != null ? !this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl != null) return false;
            return this.validationRegex != null ? this.validationRegex.equals(that.validationRegex) : that.validationRegex == null;
        }

        @Override
        public final int hashCode() {
            int result = this.handler.hashCode();
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            result = 31 * result + (this.validationRegex != null ? this.validationRegex.hashCode() : 0);
            return result;
        }
    }
}
