package software.amazon.awscdk.services.appsync;

/**
 * (experimental) An AppSync resolver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction;
 * Resolver pipelineResolver = Resolver.Builder.create(this, "pipeline")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .typeName("typeName")
 *         .fieldName("fieldName")
 *         .requestMappingTemplate(MappingTemplate.fromFile("beforeRequest.vtl"))
 *         .pipelineConfig(List.of(appsyncFunction))
 *         .responseMappingTemplate(MappingTemplate.fromFile("afterResponse.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.457Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.Resolver")
public class Resolver extends software.amazon.awscdk.core.Construct {

    protected Resolver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Resolver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Resolver(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) the ARN of the resolver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.Resolver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.Resolver> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.ResolverProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.ResolverProps.Builder();
        }

        /**
         * (experimental) name of the GraphQL field in the given type this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param fieldName name of the GraphQL field in the given type this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fieldName(final java.lang.String fieldName) {
            this.props.fieldName(fieldName);
            return this;
        }

        /**
         * (experimental) name of the GraphQL type this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param typeName name of the GraphQL type this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder typeName(final java.lang.String typeName) {
            this.props.typeName(typeName);
            return this;
        }

        /**
         * (experimental) The caching configuration for this resolver.
         * <p>
         * Default: - No caching configuration
         * <p>
         * @return {@code this}
         * @param cachingConfig The caching configuration for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cachingConfig(final software.amazon.awscdk.services.appsync.CachingConfig cachingConfig) {
            this.props.cachingConfig(cachingConfig);
            return this;
        }

        /**
         * (experimental) configuration of the pipeline resolver.
         * <p>
         * Default: - no pipeline resolver configuration
         * An empty array | undefined sets resolver to be of kind, unit
         * <p>
         * @return {@code this}
         * @param pipelineConfig configuration of the pipeline resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineConfig(final java.util.List<? extends software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig) {
            this.props.pipelineConfig(pipelineConfig);
            return this;
        }

        /**
         * (experimental) The request mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate The request mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * (experimental) The response mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate The response mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * (experimental) The data source this resolver is using.
         * <p>
         * Default: - No datasource
         * <p>
         * @return {@code this}
         * @param dataSource The data source this resolver is using. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(final software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        /**
         * (experimental) The API this resolver is attached to.
         * <p>
         * @return {@code this}
         * @param api The API this resolver is attached to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.Resolver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.Resolver build() {
            return new software.amazon.awscdk.services.appsync.Resolver(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
