package software.amazon.awscdk.services.appsync;

/**
 * (experimental) The Schema for a GraphQL Api.
 * <p>
 * If no options are configured, schema will be generated
 * code-first.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .schema(Schema.fromAsset(join(__dirname, "schema.graphql")))
 *         .build();
 * HttpDataSource httpDs = api.addHttpDataSource("ds", "https://states.amazonaws.com", HttpDataSourceOptions.builder()
 *         .name("httpDsWithStepF")
 *         .description("from appsync to StepFunctions Workflow")
 *         .authorizationConfig(AwsIamConfig.builder()
 *                 .signingRegion("us-east-1")
 *                 .signingServiceName("states")
 *                 .build())
 *         .build());
 * httpDs.createResolver(BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("callStepFunction")
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.459Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.Schema")
public class Schema extends software.amazon.jsii.JsiiObject {

    protected Schema(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schema(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Schema(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.SchemaOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Schema() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Generate a Schema from file.
     * <p>
     * @return `SchemaAsset` with immutable schema defintion
     * @param filePath the file path of the schema file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Schema fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String filePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Schema.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Schema.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required") });
    }

    /**
     * (experimental) Add a mutation field to the schema's Mutation. CDK will create an Object Type called 'Mutation'. For example,.
     * <p>
     * type Mutation {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the Mutation. This parameter is required.
     * @param field the resolvable field to for this Mutation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addMutation(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableField field) {
        return software.amazon.jsii.Kernel.call(this, "addMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Add a query field to the schema's Query. CDK will create an Object Type called 'Query'. For example,.
     * <p>
     * type Query {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the query. This parameter is required.
     * @param field the resolvable field to for this query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addQuery(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableField field) {
        return software.amazon.jsii.Kernel.call(this, "addQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Add a subscription field to the schema's Subscription. CDK will create an Object Type called 'Subscription'. For example,.
     * <p>
     * type Subscription {
     * fieldName: Field.returnType
     * }
     * <p>
     * @param fieldName the name of the Subscription. This parameter is required.
     * @param field the resolvable field to for this Subscription. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ObjectType addSubscription(final @org.jetbrains.annotations.NotNull java.lang.String fieldName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Field field) {
        return software.amazon.jsii.Kernel.call(this, "addSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ObjectType.class), new Object[] { java.util.Objects.requireNonNull(fieldName, "fieldName is required"), java.util.Objects.requireNonNull(field, "field is required") });
    }

    /**
     * (experimental) Escape hatch to add to Schema as desired.
     * <p>
     * Will always result
     * in a newline.
     * <p>
     * Default: - ''
     * <p>
     * @param addition the addition to add to schema. This parameter is required.
     * @param delimiter the delimiter between schema and addition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToSchema(final @org.jetbrains.annotations.NotNull java.lang.String addition, final @org.jetbrains.annotations.Nullable java.lang.String delimiter) {
        software.amazon.jsii.Kernel.call(this, "addToSchema", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(addition, "addition is required"), delimiter });
    }

    /**
     * (experimental) Escape hatch to add to Schema as desired.
     * <p>
     * Will always result
     * in a newline.
     * <p>
     * Default: - ''
     * <p>
     * @param addition the addition to add to schema. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToSchema(final @org.jetbrains.annotations.NotNull java.lang.String addition) {
        software.amazon.jsii.Kernel.call(this, "addToSchema", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(addition, "addition is required") });
    }

    /**
     * (experimental) Add type to the schema.
     * <p>
     * @param type the intermediate type to add to the schema. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IIntermediateType addType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IIntermediateType type) {
        return software.amazon.jsii.Kernel.call(this, "addType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IIntermediateType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) Called when the GraphQL Api is initialized to allow this object to bind to the stack.
     * <p>
     * @param api The binding GraphQL Api. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnGraphQLSchema bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApi api) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CfnGraphQLSchema.class), new Object[] { java.util.Objects.requireNonNull(api, "api is required") });
    }

    /**
     * (experimental) The definition for this schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The definition for this schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDefinition(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.Schema}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.Schema> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.appsync.SchemaOptions.Builder options;

        private Builder() {
        }

        /**
         * (experimental) The file path for the schema.
         * <p>
         * When this option is
         * configured, then the schema will be generated from an
         * existing file from disk.
         * <p>
         * Default: - schema not configured through disk asset
         * <p>
         * @return {@code this}
         * @param filePath The file path for the schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder filePath(final java.lang.String filePath) {
            this.options().filePath(filePath);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.Schema}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.Schema build() {
            return new software.amazon.awscdk.services.appsync.Schema(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.appsync.SchemaOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.appsync.SchemaOptions.Builder();
            }
            return this.options;
        }
    }
}
