package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Union Types are abstract types that are similar to Interface Types, but they cannot to specify any common fields between types.
 * <p>
 * Note that fields of a union type need to be object types. In other words,
 * you can't create a union type out of interfaces, other unions, or inputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * GraphqlType string = GraphqlType.string();
 * ObjectType human = ObjectType.Builder.create("Human").definition(Map.of("name", string)).build();
 * ObjectType droid = ObjectType.Builder.create("Droid").definition(Map.of("name", string)).build();
 * ObjectType starship = ObjectType.Builder.create("Starship").definition(Map.of("name", string)).build();
 * UnionType search = UnionType.Builder.create("Search")
 *         .definition(List.of(human, droid, starship))
 *         .build();
 * api.addType(search);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:55.463Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_appsync.UnionType")
public class UnionType extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appsync.IIntermediateType {

    protected UnionType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UnionType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param name This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UnionType(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.UnionTypeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Add a field to this Union Type.
     * <p>
     * Input Types must have field options and the IField must be an Object Type.
     * <p>
     * @param options the options to add a field. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addField(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AddFieldOptions options) {
        software.amazon.jsii.Kernel.call(this, "addField", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Create a GraphQL Type representing this Union Type.
     * <p>
     * @param options the options to configure this attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType attribute(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseTypeOptions options) {
        return software.amazon.jsii.Kernel.call(this, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class), new Object[] { options });
    }

    /**
     * (experimental) Create a GraphQL Type representing this Union Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType attribute() {
        return software.amazon.jsii.Kernel.call(this, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
    }

    /**
     * (experimental) Generate the string of this Union type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the attributes of this type.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> getDefinition() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IField.class))));
    }

    /**
     * (experimental) the name of this type.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the authorization modes supported by this intermediate type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType>)(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) the authorization modes supported by this intermediate type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setModes(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> value) {
        software.amazon.jsii.Kernel.set(this, "modes", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.UnionType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.UnionType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String name) {
            return new Builder(name);
        }

        private final java.lang.String name;
        private final software.amazon.awscdk.services.appsync.UnionTypeOptions.Builder options;

        private Builder(final java.lang.String name) {
            this.name = name;
            this.options = new software.amazon.awscdk.services.appsync.UnionTypeOptions.Builder();
        }

        /**
         * (experimental) the object types for this union type.
         * <p>
         * @return {@code this}
         * @param definition the object types for this union type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder definition(final java.util.List<? extends software.amazon.awscdk.services.appsync.IIntermediateType> definition) {
            this.options.definition(definition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.UnionType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.UnionType build() {
            return new software.amazon.awscdk.services.appsync.UnionType(
                this.name,
                this.options.build()
            );
        }
    }
}
