package software.amazon.awscdk.services.batch;

/**
 * (experimental) Batch Job Definition.
 * <p>
 * Defines a batch job definition to execute a specific batch job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * IRepository repo = Repository.fromRepositoryName(this, "batch-job-repo", "todo-list");
 * JobDefinition.Builder.create(this, "batch-job-def-from-ecr")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(new EcrImage(repo, "latest"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.056Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.JobDefinition")
public class JobDefinition extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.batch.IJobDefinition {

    protected JobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public JobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Imports an existing batch job definition by its amazon resource name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobDefinition fromJobDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobDefinition.class, "fromJobDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required") });
    }

    /**
     * (experimental) Imports an existing batch job definition by its name.
     * <p>
     * If name is specified without a revision then the latest active revision is used.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobDefinitionName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobDefinition fromJobDefinitionName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobDefinition.class, "fromJobDefinitionName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobDefinitionName, "jobDefinitionName is required") });
    }

    /**
     * (experimental) The ARN of this batch job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the batch job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.batch.JobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.JobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.JobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.JobDefinitionProps.Builder();
        }

        /**
         * (experimental) An object with various properties specific to container-based jobs.
         * <p>
         * @return {@code this}
         * @param container An object with various properties specific to container-based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder container(final software.amazon.awscdk.services.batch.JobDefinitionContainer container) {
            this.props.container(container);
            return this;
        }

        /**
         * (experimental) The name of the job definition.
         * <p>
         * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * Default: Cloudformation-generated name
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * (experimental) An object with various properties specific to multi-node parallel jobs.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param nodeProps An object with various properties specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder nodeProps(final software.amazon.awscdk.services.batch.IMultiNodeProps nodeProps) {
            this.props.nodeProps(nodeProps);
            return this;
        }

        /**
         * (experimental) When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters.
         * <p>
         * Parameters
         * in job submission requests take precedence over the defaults in a job definition.
         * This allows you to use the same job definition for multiple jobs that use the same
         * format, and programmatically change values in the command at submission time.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param parameters When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * (experimental) The platform capabilities required by the job definition.
         * <p>
         * Default: - EC2
         * <p>
         * @return {@code this}
         * @param platformCapabilities The platform capabilities required by the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platformCapabilities(final java.util.List<? extends software.amazon.awscdk.services.batch.PlatformCapabilities> platformCapabilities) {
            this.props.platformCapabilities(platformCapabilities);
            return this;
        }

        /**
         * (experimental) The number of times to move a job to the RUNNABLE status.
         * <p>
         * You may specify between 1 and
         * 10 attempts. If the value of attempts is greater than one, the job is retried on failure
         * the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param retryAttempts The number of times to move a job to the RUNNABLE status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) The timeout configuration for jobs that are submitted with this job definition.
         * <p>
         * You can specify
         * a timeout duration after which AWS Batch terminates your jobs if they have not finished.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param timeout The timeout configuration for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.JobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.batch.JobDefinition build() {
            return new software.amazon.awscdk.services.batch.JobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
