package software.amazon.awscdk.services.batch;

/**
 * (experimental) Construction properties of the {@link JobDefinition} construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * JobDefinition.Builder.create(this, "job-def")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(EcrImage.fromRegistry("docker/whalesay"))
 *                 .logConfiguration(LogConfiguration.builder()
 *                         .logDriver(LogDriver.AWSLOGS)
 *                         .options(Map.of("awslogs-region", "us-east-1"))
 *                         .secretOptions(List.of(ExposedSecret.fromParametersStore("xyz", StringParameter.fromStringParameterName(this, "parameter", "xyz"))))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.JobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(JobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) An object with various properties specific to container-based jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobDefinitionContainer getContainer();

    /**
     * (experimental) The name of the job definition.
     * <p>
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * Default: Cloudformation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * (experimental) An object with various properties specific to multi-node parallel jobs.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.IMultiNodeProps getNodeProps() {
        return null;
    }

    /**
     * (experimental) When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters.
     * <p>
     * Parameters
     * in job submission requests take precedence over the defaults in a job definition.
     * This allows you to use the same job definition for multiple jobs that use the same
     * format, and programmatically change values in the command at submission time.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * (experimental) The platform capabilities required by the job definition.
     * <p>
     * Default: - EC2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities> getPlatformCapabilities() {
        return null;
    }

    /**
     * (experimental) The number of times to move a job to the RUNNABLE status.
     * <p>
     * You may specify between 1 and
     * 10 attempts. If the value of attempts is greater than one, the job is retried on failure
     * the same number of attempts as the value.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * (experimental) The timeout configuration for jobs that are submitted with this job definition.
     * <p>
     * You can specify
     * a timeout duration after which AWS Batch terminates your jobs if they have not finished.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobDefinitionProps> {
        software.amazon.awscdk.services.batch.JobDefinitionContainer container;
        java.lang.String jobDefinitionName;
        software.amazon.awscdk.services.batch.IMultiNodeProps nodeProps;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities> platformCapabilities;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link JobDefinitionProps#getContainer}
         * @param container An object with various properties specific to container-based jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder container(software.amazon.awscdk.services.batch.JobDefinitionContainer container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of the job definition.
         *                          Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getNodeProps}
         * @param nodeProps An object with various properties specific to multi-node parallel jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder nodeProps(software.amazon.awscdk.services.batch.IMultiNodeProps nodeProps) {
            this.nodeProps = nodeProps;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getParameters}
         * @param parameters When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters.
         *                   Parameters
         *                   in job submission requests take precedence over the defaults in a job definition.
         *                   This allows you to use the same job definition for multiple jobs that use the same
         *                   format, and programmatically change values in the command at submission time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getPlatformCapabilities}
         * @param platformCapabilities The platform capabilities required by the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder platformCapabilities(java.util.List<? extends software.amazon.awscdk.services.batch.PlatformCapabilities> platformCapabilities) {
            this.platformCapabilities = (java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities>)platformCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getRetryAttempts}
         * @param retryAttempts The number of times to move a job to the RUNNABLE status.
         *                      You may specify between 1 and
         *                      10 attempts. If the value of attempts is greater than one, the job is retried on failure
         *                      the same number of attempts as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionProps#getTimeout}
         * @param timeout The timeout configuration for jobs that are submitted with this job definition.
         *                You can specify
         *                a timeout duration after which AWS Batch terminates your jobs if they have not finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDefinitionProps {
        private final software.amazon.awscdk.services.batch.JobDefinitionContainer container;
        private final java.lang.String jobDefinitionName;
        private final software.amazon.awscdk.services.batch.IMultiNodeProps nodeProps;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities> platformCapabilities;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.JobDefinitionContainer.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeProps = software.amazon.jsii.Kernel.get(this, "nodeProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IMultiNodeProps.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.platformCapabilities = software.amazon.jsii.Kernel.get(this, "platformCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.PlatformCapabilities.class)));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.container = java.util.Objects.requireNonNull(builder.container, "container is required");
            this.jobDefinitionName = builder.jobDefinitionName;
            this.nodeProps = builder.nodeProps;
            this.parameters = builder.parameters;
            this.platformCapabilities = (java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities>)builder.platformCapabilities;
            this.retryAttempts = builder.retryAttempts;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.batch.JobDefinitionContainer getContainer() {
            return this.container;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final software.amazon.awscdk.services.batch.IMultiNodeProps getNodeProps() {
            return this.nodeProps;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.PlatformCapabilities> getPlatformCapabilities() {
            return this.platformCapabilities;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("container", om.valueToTree(this.getContainer()));
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getNodeProps() != null) {
                data.set("nodeProps", om.valueToTree(this.getNodeProps()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPlatformCapabilities() != null) {
                data.set("platformCapabilities", om.valueToTree(this.getPlatformCapabilities()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_batch.JobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDefinitionProps.Jsii$Proxy that = (JobDefinitionProps.Jsii$Proxy) o;

            if (!container.equals(that.container)) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.nodeProps != null ? !this.nodeProps.equals(that.nodeProps) : that.nodeProps != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.platformCapabilities != null ? !this.platformCapabilities.equals(that.platformCapabilities) : that.platformCapabilities != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.nodeProps != null ? this.nodeProps.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.platformCapabilities != null ? this.platformCapabilities.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
