package software.amazon.awscdk.services.batch;

/**
 * (experimental) Batch Job Queue.
 * <p>
 * Defines a batch job queue to define how submitted batch jobs
 * should be ran based on specified batch compute environments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ComputeEnvironment sharedComputeEnvs;
 * JobQueue highPrioQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(JobQueueComputeEnvironment.builder()
 *                 .computeEnvironment(sharedComputeEnvs)
 *                 .order(1)
 *                 .build()))
 *         .priority(2)
 *         .build();
 * JobQueue lowPrioQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(JobQueueComputeEnvironment.builder()
 *                 .computeEnvironment(sharedComputeEnvs)
 *                 .order(1)
 *                 .build()))
 *         .priority(1)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.061Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.JobQueue")
public class JobQueue extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.batch.IJobQueue {

    protected JobQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public JobQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.JobQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Fetches an existing batch job queue by its amazon resource name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobQueueArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobQueue fromJobQueueArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobQueueArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobQueue.class, "fromJobQueueArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobQueue.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required") });
    }

    /**
     * (experimental) The ARN of this batch job queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn() {
        return software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A name for the job queue.
     * <p>
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName() {
        return software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.batch.JobQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.JobQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.JobQueueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.JobQueueProps.Builder();
        }

        /**
         * (experimental) The set of compute environments mapped to a job queue and their order relative to each other.
         * <p>
         * The job scheduler uses this parameter to
         * determine which compute environment should execute a given job. Compute environments must be in the VALID state before you can associate them
         * with a job queue. You can associate up to three compute environments with a job queue.
         * <p>
         * @return {@code this}
         * @param computeEnvironments The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironments(final java.util.List<? extends software.amazon.awscdk.services.batch.JobQueueComputeEnvironment> computeEnvironments) {
            this.props.computeEnvironments(computeEnvironments);
            return this;
        }

        /**
         * (experimental) The state of the job queue.
         * <p>
         * If set to true, it is able to accept jobs.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled The state of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * (experimental) A name for the job queue.
         * <p>
         * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * Default: - Cloudformation-generated name
         * <p>
         * @return {@code this}
         * @param jobQueueName A name for the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobQueueName(final java.lang.String jobQueueName) {
            this.props.jobQueueName(jobQueueName);
            return this;
        }

        /**
         * (experimental) The priority of the job queue.
         * <p>
         * Job queues with a higher priority (or a higher integer value for the priority parameter) are evaluated first
         * when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value
         * of 10 is given scheduling preference over a job queue with a priority value of 1.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param priority The priority of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.JobQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.batch.JobQueue build() {
            return new software.amazon.awscdk.services.batch.JobQueue(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
