package software.amazon.awscdk.services.batch;

/**
 * (experimental) Log configuration options to send to a custom log driver for the container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * JobDefinition.Builder.create(this, "job-def")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(EcrImage.fromRegistry("docker/whalesay"))
 *                 .logConfiguration(LogConfiguration.builder()
 *                         .logDriver(LogDriver.AWSLOGS)
 *                         .options(Map.of("awslogs-region", "us-east-1"))
 *                         .secretOptions(List.of(ExposedSecret.fromParametersStore("xyz", StringParameter.fromStringParameterName(this, "parameter", "xyz"))))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.066Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_batch.LogConfiguration")
@software.amazon.jsii.Jsii.Proxy(LogConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LogConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The log driver to use for the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.LogDriver getLogDriver();

    /**
     * (experimental) The configuration options to send to the log driver.
     * <p>
     * Default: - No configuration options are sent
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * (experimental) The secrets to pass to the log configuration as options.
     * <p>
     * For more information, see https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data-secrets.html#secrets-logconfig
     * <p>
     * Default: - No secrets are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.ExposedSecret> getSecretOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LogConfiguration> {
        software.amazon.awscdk.services.batch.LogDriver logDriver;
        java.lang.Object options;
        java.util.List<software.amazon.awscdk.services.batch.ExposedSecret> secretOptions;

        /**
         * Sets the value of {@link LogConfiguration#getLogDriver}
         * @param logDriver The log driver to use for the container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logDriver(software.amazon.awscdk.services.batch.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link LogConfiguration#getOptions}
         * @param options The configuration options to send to the log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder options(java.lang.Object options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link LogConfiguration#getSecretOptions}
         * @param secretOptions The secrets to pass to the log configuration as options.
         *                      For more information, see https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data-secrets.html#secrets-logconfig
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder secretOptions(java.util.List<? extends software.amazon.awscdk.services.batch.ExposedSecret> secretOptions) {
            this.secretOptions = (java.util.List<software.amazon.awscdk.services.batch.ExposedSecret>)secretOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LogConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfiguration {
        private final software.amazon.awscdk.services.batch.LogDriver logDriver;
        private final java.lang.Object options;
        private final java.util.List<software.amazon.awscdk.services.batch.ExposedSecret> secretOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LogDriver.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ExposedSecret.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
            this.options = builder.options;
            this.secretOptions = (java.util.List<software.amazon.awscdk.services.batch.ExposedSecret>)builder.secretOptions;
        }

        @Override
        public final software.amazon.awscdk.services.batch.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.ExposedSecret> getSecretOptions() {
            return this.secretOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDriver", om.valueToTree(this.getLogDriver()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSecretOptions() != null) {
                data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_batch.LogConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogConfiguration.Jsii$Proxy that = (LogConfiguration.Jsii$Proxy) o;

            if (!logDriver.equals(that.logDriver)) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDriver.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
            return result;
        }
    }
}
