package software.amazon.awscdk.services.billingconductor;

/**
 * A CloudFormation `AWS::BillingConductor::PricingRule`.
 * <p>
 * Creates a pricing rule which can be associated with a pricing plan, or a set of pricing plans.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnPricingRule cfnPricingRule = CfnPricingRule.Builder.create(this, "MyCfnPricingRule")
 *         .name("name")
 *         .scope("scope")
 *         .type("type")
 *         // the properties below are optional
 *         .billingEntity("billingEntity")
 *         .description("description")
 *         .modifierPercentage(123)
 *         .service("service")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tiering(TieringProperty.builder()
 *                 .freeTier(FreeTierProperty.builder()
 *                         .activated(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.084Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnPricingRule")
public class CfnPricingRule extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPricingRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPricingRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.billingconductor.CfnPricingRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::BillingConductor::PricingRule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPricingRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.billingconductor.CfnPricingRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The pricing plans count that this pricing rule is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAssociatedPricingPlanCount() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociatedPricingPlanCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time the pricing rule was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The most recent time the pricing rule was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scope", java.util.Objects.requireNonNull(value, "scope is required"));
    }

    /**
     * The type of pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingEntity() {
        return software.amazon.jsii.Kernel.get(this, "billingEntity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingEntity(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingEntity", value);
    }

    /**
     * The pricing rule description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The pricing rule description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A percentage modifier applied on the public pricing rates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getModifierPercentage() {
        return software.amazon.jsii.Kernel.get(this, "modifierPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A percentage modifier applied on the public pricing rates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModifierPercentage(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "modifierPercentage", value);
    }

    /**
     * If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setService(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "service", value);
    }

    /**
     * The set of tiering configurations for the pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTiering() {
        return software.amazon.jsii.Kernel.get(this, "tiering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of tiering configurations for the pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTiering(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.billingconductor.CfnPricingRule.TieringProperty value) {
        software.amazon.jsii.Kernel.set(this, "tiering", value);
    }

    /**
     * The set of tiering configurations for the pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTiering(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tiering", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * FreeTierProperty freeTierProperty = FreeTierProperty.builder()
     *         .activated(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnPricingRule.FreeTierProperty")
    @software.amazon.jsii.Jsii.Proxy(FreeTierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FreeTierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPricingRule.FreeTierProperty.Activated`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActivated();

        /**
         * @return a {@link Builder} of {@link FreeTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FreeTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FreeTierProperty> {
            java.lang.Object activated;

            /**
             * Sets the value of {@link FreeTierProperty#getActivated}
             * @param activated `CfnPricingRule.FreeTierProperty.Activated`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activated(java.lang.Boolean activated) {
                this.activated = activated;
                return this;
            }

            /**
             * Sets the value of {@link FreeTierProperty#getActivated}
             * @param activated `CfnPricingRule.FreeTierProperty.Activated`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activated(software.amazon.awscdk.core.IResolvable activated) {
                this.activated = activated;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FreeTierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FreeTierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FreeTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FreeTierProperty {
            private final java.lang.Object activated;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activated = software.amazon.jsii.Kernel.get(this, "activated", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activated = java.util.Objects.requireNonNull(builder.activated, "activated is required");
            }

            @Override
            public final java.lang.Object getActivated() {
                return this.activated;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("activated", om.valueToTree(this.getActivated()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnPricingRule.FreeTierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FreeTierProperty.Jsii$Proxy that = (FreeTierProperty.Jsii$Proxy) o;

                return this.activated.equals(that.activated);
            }

            @Override
            public final int hashCode() {
                int result = this.activated.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.billingconductor.*;
     * TieringProperty tieringProperty = TieringProperty.builder()
     *         .freeTier(FreeTierProperty.builder()
     *                 .activated(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnPricingRule.TieringProperty")
    @software.amazon.jsii.Jsii.Proxy(TieringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TieringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPricingRule.TieringProperty.FreeTier`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFreeTier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TieringProperty> {
            java.lang.Object freeTier;

            /**
             * Sets the value of {@link TieringProperty#getFreeTier}
             * @param freeTier `CfnPricingRule.TieringProperty.FreeTier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder freeTier(software.amazon.awscdk.services.billingconductor.CfnPricingRule.FreeTierProperty freeTier) {
                this.freeTier = freeTier;
                return this;
            }

            /**
             * Sets the value of {@link TieringProperty#getFreeTier}
             * @param freeTier `CfnPricingRule.TieringProperty.FreeTier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder freeTier(software.amazon.awscdk.core.IResolvable freeTier) {
                this.freeTier = freeTier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TieringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TieringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TieringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TieringProperty {
            private final java.lang.Object freeTier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.freeTier = software.amazon.jsii.Kernel.get(this, "freeTier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.freeTier = builder.freeTier;
            }

            @Override
            public final java.lang.Object getFreeTier() {
                return this.freeTier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFreeTier() != null) {
                    data.set("freeTier", om.valueToTree(this.getFreeTier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnPricingRule.TieringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TieringProperty.Jsii$Proxy that = (TieringProperty.Jsii$Proxy) o;

                return this.freeTier != null ? this.freeTier.equals(that.freeTier) : that.freeTier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.freeTier != null ? this.freeTier.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.billingconductor.CfnPricingRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.billingconductor.CfnPricingRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.billingconductor.CfnPricingRuleProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.billingconductor.CfnPricingRuleProps.Builder();
        }

        /**
         * The name of a pricing rule.
         * <p>
         * @return {@code this}
         * @param name The name of a pricing rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         * <p>
         * @return {@code this}
         * @param scope The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final java.lang.String scope) {
            this.props.scope(scope);
            return this;
        }

        /**
         * The type of pricing rule.
         * <p>
         * @return {@code this}
         * @param type The type of pricing rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace .
         * <p>
         * @return {@code this}
         * @param billingEntity The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingEntity(final java.lang.String billingEntity) {
            this.props.billingEntity(billingEntity);
            return this;
        }

        /**
         * The pricing rule description.
         * <p>
         * @return {@code this}
         * @param description The pricing rule description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A percentage modifier applied on the public pricing rates.
         * <p>
         * @return {@code this}
         * @param modifierPercentage A percentage modifier applied on the public pricing rates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modifierPercentage(final java.lang.Number modifierPercentage) {
            this.props.modifierPercentage(modifierPercentage);
            return this;
        }

        /**
         * If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for.
         * <p>
         * @return {@code this}
         * @param service If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * A map that contains tag keys and tag values that are attached to a pricing rule.
         * <p>
         * @return {@code this}
         * @param tags A map that contains tag keys and tag values that are attached to a pricing rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The set of tiering configurations for the pricing rule.
         * <p>
         * @return {@code this}
         * @param tiering The set of tiering configurations for the pricing rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tiering(final software.amazon.awscdk.services.billingconductor.CfnPricingRule.TieringProperty tiering) {
            this.props.tiering(tiering);
            return this;
        }
        /**
         * The set of tiering configurations for the pricing rule.
         * <p>
         * @return {@code this}
         * @param tiering The set of tiering configurations for the pricing rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tiering(final software.amazon.awscdk.core.IResolvable tiering) {
            this.props.tiering(tiering);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.billingconductor.CfnPricingRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.billingconductor.CfnPricingRule build() {
            return new software.amazon.awscdk.services.billingconductor.CfnPricingRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
