package software.amazon.awscdk.services.billingconductor;

/**
 * Properties for defining a `CfnPricingRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnPricingRuleProps cfnPricingRuleProps = CfnPricingRuleProps.builder()
 *         .name("name")
 *         .scope("scope")
 *         .type("type")
 *         // the properties below are optional
 *         .billingEntity("billingEntity")
 *         .description("description")
 *         .modifierPercentage(123)
 *         .service("service")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tiering(TieringProperty.builder()
 *                 .freeTier(FreeTierProperty.builder()
 *                         .activated(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.088Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_billingconductor.CfnPricingRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnPricingRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPricingRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * The type of pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingEntity() {
        return null;
    }

    /**
     * The pricing rule description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A percentage modifier applied on the public pricing rates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getModifierPercentage() {
        return null;
    }

    /**
     * If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getService() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * The set of tiering configurations for the pricing rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTiering() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPricingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPricingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPricingRuleProps> {
        java.lang.String name;
        java.lang.String scope;
        java.lang.String type;
        java.lang.String billingEntity;
        java.lang.String description;
        java.lang.Number modifierPercentage;
        java.lang.String service;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object tiering;

        /**
         * Sets the value of {@link CfnPricingRuleProps#getName}
         * @param name The name of a pricing rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getScope}
         * @param scope The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getType}
         * @param type The type of pricing rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getBillingEntity}
         * @param billingEntity The seller of services provided by AWS , their affiliates, or third-party providers selling services via AWS Marketplace .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingEntity(java.lang.String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getDescription}
         * @param description The pricing rule description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getModifierPercentage}
         * @param modifierPercentage A percentage modifier applied on the public pricing rates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modifierPercentage(java.lang.Number modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getService}
         * @param service If the `Scope` attribute is `SERVICE` , this attribute indicates which service the `PricingRule` is applicable for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to a pricing rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getTiering}
         * @param tiering The set of tiering configurations for the pricing rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tiering(software.amazon.awscdk.services.billingconductor.CfnPricingRule.TieringProperty tiering) {
            this.tiering = tiering;
            return this;
        }

        /**
         * Sets the value of {@link CfnPricingRuleProps#getTiering}
         * @param tiering The set of tiering configurations for the pricing rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tiering(software.amazon.awscdk.core.IResolvable tiering) {
            this.tiering = tiering;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPricingRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPricingRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPricingRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPricingRuleProps {
        private final java.lang.String name;
        private final java.lang.String scope;
        private final java.lang.String type;
        private final java.lang.String billingEntity;
        private final java.lang.String description;
        private final java.lang.Number modifierPercentage;
        private final java.lang.String service;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object tiering;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.billingEntity = software.amazon.jsii.Kernel.get(this, "billingEntity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modifierPercentage = software.amazon.jsii.Kernel.get(this, "modifierPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.tiering = software.amazon.jsii.Kernel.get(this, "tiering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.billingEntity = builder.billingEntity;
            this.description = builder.description;
            this.modifierPercentage = builder.modifierPercentage;
            this.service = builder.service;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.tiering = builder.tiering;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getBillingEntity() {
            return this.billingEntity;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getModifierPercentage() {
            return this.modifierPercentage;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTiering() {
            return this.tiering;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("scope", om.valueToTree(this.getScope()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getBillingEntity() != null) {
                data.set("billingEntity", om.valueToTree(this.getBillingEntity()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getModifierPercentage() != null) {
                data.set("modifierPercentage", om.valueToTree(this.getModifierPercentage()));
            }
            if (this.getService() != null) {
                data.set("service", om.valueToTree(this.getService()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTiering() != null) {
                data.set("tiering", om.valueToTree(this.getTiering()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_billingconductor.CfnPricingRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPricingRuleProps.Jsii$Proxy that = (CfnPricingRuleProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!scope.equals(that.scope)) return false;
            if (!type.equals(that.type)) return false;
            if (this.billingEntity != null ? !this.billingEntity.equals(that.billingEntity) : that.billingEntity != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.modifierPercentage != null ? !this.modifierPercentage.equals(that.modifierPercentage) : that.modifierPercentage != null) return false;
            if (this.service != null ? !this.service.equals(that.service) : that.service != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.tiering != null ? this.tiering.equals(that.tiering) : that.tiering == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.billingEntity != null ? this.billingEntity.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.modifierPercentage != null ? this.modifierPercentage.hashCode() : 0);
            result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tiering != null ? this.tiering.hashCode() : 0);
            return result;
        }
    }
}
