package software.amazon.awscdk.services.cloudfront;

/**
 * (experimental) Options for creating a new behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Adding an existing Lambda&#64;Edge function created in a different stack
 * // to a CloudFront distribution.
 * Bucket s3Bucket;
 * IVersion functionVersion = Version.fromVersionArn(this, "Version", "arn:aws:lambda:us-east-1:123456789012:function:functionName:1");
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .edgeLambdas(List.of(EdgeLambda.builder()
 *                         .functionVersion(functionVersion)
 *                         .eventType(LambdaEdgeEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.396Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.BehaviorOptions")
@software.amazon.jsii.Jsii.Proxy(BehaviorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BehaviorOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.AddBehaviorOptions {

    /**
     * (experimental) The origin that you want CloudFront to route requests to when they match this behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin getOrigin();

    /**
     * @return a {@link Builder} of {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BehaviorOptions> {
        software.amazon.awscdk.services.cloudfront.IOrigin origin;
        software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        java.lang.Boolean compress;
        java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        java.lang.Boolean smoothStreaming;
        java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Sets the value of {@link BehaviorOptions#getOrigin}
         * @param origin The origin that you want CloudFront to route requests to when they match this behavior. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder origin(software.amazon.awscdk.services.cloudfront.IOrigin origin) {
            this.origin = origin;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getAllowedMethods}
         * @param allowedMethods HTTP methods to allow for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCachedMethods}
         * @param cachedMethods HTTP methods to cache for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCachePolicy}
         * @param cachePolicy The cache policy for this behavior.
         *                    The cache policy determines what values are included in the cache key,
         *                    and the time-to-live (TTL) values for the cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cachePolicy(software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCompress}
         * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
         *                 See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
         *                 for file types CloudFront will compress.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getEdgeLambdas}
         * @param edgeLambdas The Lambda@Edge functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder edgeLambdas(java.util.List<? extends software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas) {
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)edgeLambdas;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getFunctionAssociations}
         * @param functionAssociations The CloudFront functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder functionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations) {
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)functionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getOriginRequestPolicy}
         * @param originRequestPolicy The origin request policy for this behavior.
         *                            The origin request policy determines which values (e.g., headers, cookies)
         *                            are included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originRequestPolicy(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getResponseHeadersPolicy}
         * @param responseHeadersPolicy The response headers policy for this behavior.
         *                              The response headers policy determines which headers are included in responses
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseHeadersPolicy(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getSmoothStreaming}
         * @param smoothStreaming Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getTrustedKeyGroups}
         * @param trustedKeyGroups A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder trustedKeyGroups(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups) {
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getViewerProtocolPolicy}
         * @param viewerProtocolPolicy The protocol that viewers can use to access the files controlled by this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder viewerProtocolPolicy(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BehaviorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BehaviorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BehaviorOptions {
        private final software.amazon.awscdk.services.cloudfront.IOrigin origin;
        private final software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        private final software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        private final java.lang.Boolean compress;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        private final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        private final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        private final java.lang.Boolean smoothStreaming;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.origin = software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class));
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
            this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CachedMethods.class));
            this.cachePolicy = software.amazon.jsii.Kernel.get(this, "cachePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ICachePolicy.class));
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.edgeLambdas = software.amazon.jsii.Kernel.get(this, "edgeLambdas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.EdgeLambda.class)));
            this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionAssociation.class)));
            this.originRequestPolicy = software.amazon.jsii.Kernel.get(this, "originRequestPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
            this.responseHeadersPolicy = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
            this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyGroup.class)));
            this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.origin = java.util.Objects.requireNonNull(builder.origin, "origin is required");
            this.allowedMethods = builder.allowedMethods;
            this.cachedMethods = builder.cachedMethods;
            this.cachePolicy = builder.cachePolicy;
            this.compress = builder.compress;
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)builder.edgeLambdas;
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)builder.functionAssociations;
            this.originRequestPolicy = builder.originRequestPolicy;
            this.responseHeadersPolicy = builder.responseHeadersPolicy;
            this.smoothStreaming = builder.smoothStreaming;
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)builder.trustedKeyGroups;
            this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOrigin getOrigin() {
            return this.origin;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ICachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
            return this.edgeLambdas;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
            return this.functionAssociations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy getOriginRequestPolicy() {
            return this.originRequestPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy getResponseHeadersPolicy() {
            return this.responseHeadersPolicy;
        }

        @Override
        public final java.lang.Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
            return this.trustedKeyGroups;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("origin", om.valueToTree(this.getOrigin()));
            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCachePolicy() != null) {
                data.set("cachePolicy", om.valueToTree(this.getCachePolicy()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getEdgeLambdas() != null) {
                data.set("edgeLambdas", om.valueToTree(this.getEdgeLambdas()));
            }
            if (this.getFunctionAssociations() != null) {
                data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
            }
            if (this.getOriginRequestPolicy() != null) {
                data.set("originRequestPolicy", om.valueToTree(this.getOriginRequestPolicy()));
            }
            if (this.getResponseHeadersPolicy() != null) {
                data.set("responseHeadersPolicy", om.valueToTree(this.getResponseHeadersPolicy()));
            }
            if (this.getSmoothStreaming() != null) {
                data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
            }
            if (this.getTrustedKeyGroups() != null) {
                data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
            }
            if (this.getViewerProtocolPolicy() != null) {
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cloudfront.BehaviorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BehaviorOptions.Jsii$Proxy that = (BehaviorOptions.Jsii$Proxy) o;

            if (!origin.equals(that.origin)) return false;
            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.cachePolicy != null ? !this.cachePolicy.equals(that.cachePolicy) : that.cachePolicy != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.edgeLambdas != null ? !this.edgeLambdas.equals(that.edgeLambdas) : that.edgeLambdas != null) return false;
            if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
            if (this.originRequestPolicy != null ? !this.originRequestPolicy.equals(that.originRequestPolicy) : that.originRequestPolicy != null) return false;
            if (this.responseHeadersPolicy != null ? !this.responseHeadersPolicy.equals(that.responseHeadersPolicy) : that.responseHeadersPolicy != null) return false;
            if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
            if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
            return this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.equals(that.viewerProtocolPolicy) : that.viewerProtocolPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.cachePolicy != null ? this.cachePolicy.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.edgeLambdas != null ? this.edgeLambdas.hashCode() : 0);
            result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
            result = 31 * result + (this.originRequestPolicy != null ? this.originRequestPolicy.hashCode() : 0);
            result = 31 * result + (this.responseHeadersPolicy != null ? this.responseHeadersPolicy.hashCode() : 0);
            result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
            result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
            result = 31 * result + (this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.hashCode() : 0);
            return result;
        }
    }
}
