package software.amazon.awscdk.services.cloudfront;

/**
 * (experimental) Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creating a custom cache policy for a Distribution -- all parameters optional
 * S3Origin bucketOrigin;
 * CachePolicy myCachePolicy = CachePolicy.Builder.create(this, "myCachePolicy")
 *         .cachePolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .defaultTtl(Duration.days(2))
 *         .minTtl(Duration.minutes(1))
 *         .maxTtl(Duration.days(10))
 *         .cookieBehavior(CacheCookieBehavior.all())
 *         .headerBehavior(CacheHeaderBehavior.allowList("X-CustomHeader"))
 *         .queryStringBehavior(CacheQueryStringBehavior.denyList("username"))
 *         .enableAcceptEncodingGzip(true)
 *         .enableAcceptEncodingBrotli(true)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .cachePolicy(myCachePolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.CacheQueryStringBehavior")
public class CacheQueryStringBehavior extends software.amazon.jsii.JsiiObject {

    protected CacheQueryStringBehavior(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheQueryStringBehavior(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) All query strings in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class));
    }

    /**
     * (experimental) Only the provided `queryStrings` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param queryStrings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior allowList(final @org.jetbrains.annotations.NotNull java.lang.String... queryStrings) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class, "allowList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class), java.util.Arrays.<Object>stream(queryStrings).toArray(Object[]::new));
    }

    /**
     * (experimental) All query strings except the provided `queryStrings` are included in the cache key and automatically included in requests that CloudFront sends to the origin.
     * <p>
     * @param queryStrings This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior denyList(final @org.jetbrains.annotations.NotNull java.lang.String... queryStrings) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class, "denyList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class), java.util.Arrays.<Object>stream(queryStrings).toArray(Object[]::new));
    }

    /**
     * (experimental) Query strings in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CacheQueryStringBehavior.class));
    }

    /**
     * (experimental) The behavior of query strings -- allow all, none, only an allow list, or a deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBehavior() {
        return software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The query strings to allow or deny, if the behavior is an allow or deny list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStrings() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "queryStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
