package software.amazon.awscdk.services.cloudfront;

/**
 * (experimental) The SSL method CloudFront will use for your distribution.
 * <p>
 * Server Name Indication (SNI) - is an extension to the TLS computer networking protocol by which a client indicates
 * which hostname it is attempting to connect to at the start of the handshaking process. This allows a server to present
 * multiple certificates on the same IP address and TCP port number and hence allows multiple secure (HTTPS) websites
 * (or any other service over TLS) to be served by the same IP address without requiring all those sites to use the same certificate.
 * <p>
 * CloudFront can use SNI to host multiple distributions on the same IP - which a large majority of clients will support.
 * <p>
 * If your clients cannot support SNI however - CloudFront can use dedicated IPs for your distribution - but there is a prorated monthly charge for
 * using this feature. By default, we use SNI - but you can optionally enable dedicated IPs (VIP).
 * <p>
 * See the CloudFront SSL for more details about pricing : https://aws.amazon.com/cloudfront/custom-ssl-domains/
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3BucketSource = new Bucket(this, "Bucket");
 * CloudFrontWebDistribution distribution = CloudFrontWebDistribution.Builder.create(this, "AnAmazingWebsiteProbably")
 *         .originConfigs(List.of(SourceConfiguration.builder()
 *                 .s3OriginSource(S3OriginConfig.builder().s3BucketSource(s3BucketSource).build())
 *                 .behaviors(List.of(Behavior.builder().isDefaultBehavior(true).build()))
 *                 .build()))
 *         .viewerCertificate(ViewerCertificate.fromIamCertificate("certificateId", ViewerCertificateOptions.builder()
 *                 .aliases(List.of("example.com"))
 *                 .securityPolicy(SecurityPolicyProtocol.SSL_V3) // default
 *                 .sslMethod(SSLMethod.SNI)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.670Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudfront.SSLMethod")
public enum SSLMethod {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SNI,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VIP,
}
