package software.amazon.awscdk.services.cloudtrail;

/**
 * A CloudFormation `AWS::CloudTrail::EventDataStore`.
 * <p>
 * Creates a new event data store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStore cfnEventDataStore = CfnEventDataStore.Builder.create(this, "MyCfnEventDataStore")
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudtrail.CfnEventDataStore")
public class CfnEventDataStore extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * `Ref` returns the time stamp of the creation of the event data store, such as `1248496624` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `Ref` returns the ARN of the CloudTrail event data store, such as `arn:aws:cloudtrail:us-east-1:12345678910:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEventDataStoreArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEventDataStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `Ref` returns the status of the event data store, such as `ENABLED` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `Ref` returns the time stamp that updates were made to an event data store, such as `1598296624` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     * <p>
     * You can configure up to five advanced event selectors for each event data store.
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     * <p>
     * You can configure up to five advanced event selectors for each event data store.
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * The advanced event selectors to use to select the events for the data store.
     * <p>
     * You can configure up to five advanced event selectors for each event data store.
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * <p>
     * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * <blockquote>
     * <p>
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     * <p>
     * </blockquote>
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li><code>alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
     * <li><code>12345678-1234-1234-1234-123456789012</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * <blockquote>
     * <p>
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
     * <p>
     * </blockquote>
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li><code>alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
     * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
     * <li><code>12345678-1234-1234-1234-123456789012</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * The name of the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the event data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * The retention period of the event data store, in days.
     * <p>
     * You can set a retention period of up to 2557 days, the equivalent of seven years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The retention period of the event data store, in days.
     * <p>
     * You can set a retention period of up to 2557 days, the equivalent of seven years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     * <p>
     * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     * <p>
     * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }

    /**
     * Specifies whether termination protection is enabled for the event data store.
     * <p>
     * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }
    /**
     * Advanced event selectors let you create fine-grained selectors for the following AWS CloudTrail event record ﬁelds.
     * <p>
     * They help you control costs by logging only those events that are important to you. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events for trails</a> in the <em>AWS CloudTrail User Guide</em> .
     * <p>
     * <ul>
     * <li><code>readOnly</code></li>
     * <li><code>eventSource</code></li>
     * <li><code>eventName</code></li>
     * <li><code>eventCategory</code></li>
     * <li><code>resources.type</code></li>
     * <li><code>resources.ARN</code></li>
     * </ul>
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedEventSelectorProperty advancedEventSelectorProperty = AdvancedEventSelectorProperty.builder()
     *         .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
     *                 .field("field")
     *                 // the properties below are optional
     *                 .endsWith(List.of("endsWith"))
     *                 .equalTo(List.of("equalTo"))
     *                 .notEndsWith(List.of("notEndsWith"))
     *                 .notEquals(List.of("notEquals"))
     *                 .notStartsWith(List.of("notStartsWith"))
     *                 .startsWith(List.of("startsWith"))
     *                 .build()))
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedEventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedEventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains all selector statements in an advanced event selector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldSelectors();

        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedEventSelectorProperty> {
            java.lang.Object fieldSelectors;
            java.lang.String name;

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(software.amazon.awscdk.core.IResolvable fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(java.util.List<? extends java.lang.Object> fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getName}
             * @param name An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedEventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedEventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedEventSelectorProperty {
            private final java.lang.Object fieldSelectors;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldSelectors = software.amazon.jsii.Kernel.get(this, "fieldSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldSelectors = java.util.Objects.requireNonNull(builder.fieldSelectors, "fieldSelectors is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getFieldSelectors() {
                return this.fieldSelectors;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldSelectors", om.valueToTree(this.getFieldSelectors()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedEventSelectorProperty.Jsii$Proxy that = (AdvancedEventSelectorProperty.Jsii$Proxy) o;

                if (!fieldSelectors.equals(that.fieldSelectors)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldSelectors.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single selector statement in an advanced event selector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedFieldSelectorProperty advancedFieldSelectorProperty = AdvancedFieldSelectorProperty.builder()
     *         .field("field")
     *         // the properties below are optional
     *         .endsWith(List.of("endsWith"))
     *         .equalTo(List.of("equalTo"))
     *         .notEndsWith(List.of("notEndsWith"))
     *         .notEquals(List.of("notEquals"))
     *         .notStartsWith(List.of("notStartsWith"))
     *         .startsWith(List.of("startsWith"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedFieldSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedFieldSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field in a CloudTrail event record on which to filter events to be logged.
         * <p>
         * For event data stores for AWS Config configuration items, the field is used only for selecting configuration items as filtering is not supported.
         * <p>
         * For CloudTrail event records, supported fields include <code>readOnly</code> , <code>eventCategory</code> , <code>eventSource</code> (for management events), <code>eventName</code> , <code>resources.type</code> , and <code>resources.ARN</code> .
         * <p>
         * For AWS Config configuration item records, the only supported field is <code>eventCategory</code> .
         * <p>
         * <ul>
         * <li><em><code>readOnly</code></em> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
         * <li><em><code>eventSource</code></em> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code> .</li>
         * <li><em><code>eventName</code></em> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code> . You can have multiple values for this ﬁeld, separated by commas.</li>
         * <li><em><code>eventCategory</code></em> - This is required and must be set to <code>Equals</code> . For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code> . For AWS Config configuration item records, the value must be <code>ConfigurationItem</code> .</li>
         * <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</li>
         * <li><code>AWS::S3::Object</code></li>
         * <li><code>AWS::Lambda::Function</code></li>
         * <li><code>AWS::DynamoDB::Table</code></li>
         * <li><code>AWS::S3Outposts::Object</code></li>
         * <li><code>AWS::ManagedBlockchain::Node</code></li>
         * <li><code>AWS::S3ObjectLambda::AccessPoint</code></li>
         * <li><code>AWS::EC2::Snapshot</code></li>
         * <li><code>AWS::S3::AccessPoint</code></li>
         * <li><code>AWS::DynamoDB::Stream</code></li>
         * <li><code>AWS::Glue::Table</code></li>
         * <li><code>AWS::FinSpace::Environment</code></li>
         * <li><code>AWS::SageMaker::ExperimentTrialComponent</code></li>
         * <li><code>AWS::SageMaker::FeatureGroup</code></li>
         * </ul>
         * <p>
         * You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.
         * <p>
         * <ul>
         * <li><em><code>resources.ARN</code></em> - You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code> , the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
         * </ul>
         * <p>
         * The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information.
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code></li>
         * <li><code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code></li>
         * <li><code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code></li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::Lambda::Function</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code></li>
         * </ul>
         * <p>
         * When resources.type equals <code>AWS::DynamoDB::Table</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::Glue::Table</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code></li>
         * </ul>
         * <p>
         * When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
         * <p>
         * <ul>
         * <li><code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getField();

        /**
         * An operator that includes events that match the last few characters of the event record field specified as the value of `Field` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the exact value of the event record field specified as the value of `Field` .
         * <p>
         * This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEqualTo() {
            return null;
        }

        /**
         * An operator that excludes events that match the last few characters of the event record field specified as the value of `Field` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEndsWith() {
            return null;
        }

        /**
         * An operator that excludes events that match the exact value of the event record field specified as the value of `Field` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEquals() {
            return null;
        }

        /**
         * An operator that excludes events that match the first few characters of the event record field specified as the value of `Field` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotStartsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the first few characters of the event record field specified as the value of `Field` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartsWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedFieldSelectorProperty> {
            java.lang.String field;
            java.util.List<java.lang.String> endsWith;
            java.util.List<java.lang.String> equalTo;
            java.util.List<java.lang.String> notEndsWith;
            java.util.List<java.lang.String> notEquals;
            java.util.List<java.lang.String> notStartsWith;
            java.util.List<java.lang.String> startsWith;

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getField}
             * @param field A field in a CloudTrail event record on which to filter events to be logged. This parameter is required.
             *              For event data stores for AWS Config configuration items, the field is used only for selecting configuration items as filtering is not supported.
             *              <p>
             *              For CloudTrail event records, supported fields include <code>readOnly</code> , <code>eventCategory</code> , <code>eventSource</code> (for management events), <code>eventName</code> , <code>resources.type</code> , and <code>resources.ARN</code> .
             *              <p>
             *              For AWS Config configuration item records, the only supported field is <code>eventCategory</code> .
             *              <p>
             *              <ul>
             *              <li><em><code>readOnly</code></em> - Optional. Can be set to <code>Equals</code> a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
             *              <li><em><code>eventSource</code></em> - For filtering management events only. This can be set only to <code>NotEquals</code> <code>kms.amazonaws.com</code> .</li>
             *              <li><em><code>eventName</code></em> - Can use any operator. You can use it to ﬁlter in or ﬁlter out any data event logged to CloudTrail, such as <code>PutBucket</code> or <code>GetSnapshotBlock</code> . You can have multiple values for this ﬁeld, separated by commas.</li>
             *              <li><em><code>eventCategory</code></em> - This is required and must be set to <code>Equals</code> . For CloudTrail event records, the value must be <code>Management</code> or <code>Data</code> . For AWS Config configuration item records, the value must be <code>ConfigurationItem</code> .</li>
             *              <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator, and the value can be one of the following:</li>
             *              <li><code>AWS::S3::Object</code></li>
             *              <li><code>AWS::Lambda::Function</code></li>
             *              <li><code>AWS::DynamoDB::Table</code></li>
             *              <li><code>AWS::S3Outposts::Object</code></li>
             *              <li><code>AWS::ManagedBlockchain::Node</code></li>
             *              <li><code>AWS::S3ObjectLambda::AccessPoint</code></li>
             *              <li><code>AWS::EC2::Snapshot</code></li>
             *              <li><code>AWS::S3::AccessPoint</code></li>
             *              <li><code>AWS::DynamoDB::Stream</code></li>
             *              <li><code>AWS::Glue::Table</code></li>
             *              <li><code>AWS::FinSpace::Environment</code></li>
             *              <li><code>AWS::SageMaker::ExperimentTrialComponent</code></li>
             *              <li><code>AWS::SageMaker::FeatureGroup</code></li>
             *              </ul>
             *              <p>
             *              You can have only one <code>resources.type</code> ﬁeld per selector. To log data events on more than one resource type, add another selector.
             *              <p>
             *              <ul>
             *              <li><em><code>resources.ARN</code></em> - You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. For example, if resources.type equals <code>AWS::S3::Object</code> , the ARN must be in one of the following formats. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
             *              </ul>
             *              <p>
             *              The trailing slash is intentional; do not exclude it. Replace the text between less than and greater than symbols (&lt;&gt;) with resource-specific information.
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/</code></li>
             *              <li><code>arn:&lt;partition&gt;:s3:::&lt;bucket_name&gt;/&lt;object_path&gt;/</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::S3::AccessPoint</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in one of the following formats. To log events on all objects in an S3 access point, we recommend that you use only the access point ARN, don’t include the object path, and use the <code>StartsWith</code> or <code>NotStartsWith</code> operators.
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code></li>
             *              <li><code>arn:&lt;partition&gt;:s3:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;/object/&lt;object_path&gt;</code></li>
             *              </ul>
             *              <p>
             *              When resources.type equals <code>AWS::Lambda::Function</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:lambda:&lt;region&gt;:&lt;account_ID&gt;:function:&lt;function_name&gt;</code></li>
             *              </ul>
             *              <p>
             *              When resources.type equals <code>AWS::DynamoDB::Table</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::S3Outposts::Object</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:s3-outposts:&lt;region&gt;:&lt;account_ID&gt;:&lt;object_path&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::ManagedBlockchain::Node</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:managedblockchain:&lt;region&gt;:&lt;account_ID&gt;:nodes/&lt;node_ID&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::S3ObjectLambda::AccessPoint</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:s3-object-lambda:&lt;region&gt;:&lt;account_ID&gt;:accesspoint/&lt;access_point_name&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::EC2::Snapshot</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:ec2:&lt;region&gt;::snapshot/&lt;snapshot_ID&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::DynamoDB::Stream</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:dynamodb:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;table_name&gt;/stream/&lt;date_time&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::Glue::Table</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:glue:&lt;region&gt;:&lt;account_ID&gt;:table/&lt;database_name&gt;/&lt;table_name&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::FinSpace::Environment</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:finspace:&lt;region&gt;:&lt;account_ID&gt;:environment/&lt;environment_ID&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::SageMaker::ExperimentTrialComponent</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:experiment-trial-component/&lt;experiment_trial_component_name&gt;</code></li>
             *              </ul>
             *              <p>
             *              When <code>resources.type</code> equals <code>AWS::SageMaker::FeatureGroup</code> , and the operator is set to <code>Equals</code> or <code>NotEquals</code> , the ARN must be in the following format:
             *              <p>
             *              <ul>
             *              <li><code>arn:&lt;partition&gt;:sagemaker:&lt;region&gt;:&lt;account_ID&gt;:feature-group/&lt;feature_group_name&gt;</code></li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEndsWith}
             * @param endsWith An operator that includes events that match the last few characters of the event record field specified as the value of `Field` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endsWith(java.util.List<java.lang.String> endsWith) {
                this.endsWith = endsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEqualTo}
             * @param equalTo An operator that includes events that match the exact value of the event record field specified as the value of `Field` .
             *                This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEndsWith}
             * @param notEndsWith An operator that excludes events that match the last few characters of the event record field specified as the value of `Field` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEndsWith(java.util.List<java.lang.String> notEndsWith) {
                this.notEndsWith = notEndsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEquals}
             * @param notEquals An operator that excludes events that match the exact value of the event record field specified as the value of `Field` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEquals(java.util.List<java.lang.String> notEquals) {
                this.notEquals = notEquals;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotStartsWith}
             * @param notStartsWith An operator that excludes events that match the first few characters of the event record field specified as the value of `Field` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStartsWith(java.util.List<java.lang.String> notStartsWith) {
                this.notStartsWith = notStartsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getStartsWith}
             * @param startsWith An operator that includes events that match the first few characters of the event record field specified as the value of `Field` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startsWith(java.util.List<java.lang.String> startsWith) {
                this.startsWith = startsWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedFieldSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedFieldSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedFieldSelectorProperty {
            private final java.lang.String field;
            private final java.util.List<java.lang.String> endsWith;
            private final java.util.List<java.lang.String> equalTo;
            private final java.util.List<java.lang.String> notEndsWith;
            private final java.util.List<java.lang.String> notEquals;
            private final java.util.List<java.lang.String> notStartsWith;
            private final java.util.List<java.lang.String> startsWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endsWith = software.amazon.jsii.Kernel.get(this, "endsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEndsWith = software.amazon.jsii.Kernel.get(this, "notEndsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEquals = software.amazon.jsii.Kernel.get(this, "notEquals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notStartsWith = software.amazon.jsii.Kernel.get(this, "notStartsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.startsWith = software.amazon.jsii.Kernel.get(this, "startsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
                this.endsWith = builder.endsWith;
                this.equalTo = builder.equalTo;
                this.notEndsWith = builder.notEndsWith;
                this.notEquals = builder.notEquals;
                this.notStartsWith = builder.notStartsWith;
                this.startsWith = builder.startsWith;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.util.List<java.lang.String> getEndsWith() {
                return this.endsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEndsWith() {
                return this.notEndsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEquals() {
                return this.notEquals;
            }

            @Override
            public final java.util.List<java.lang.String> getNotStartsWith() {
                return this.notStartsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getStartsWith() {
                return this.startsWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("field", om.valueToTree(this.getField()));
                if (this.getEndsWith() != null) {
                    data.set("endsWith", om.valueToTree(this.getEndsWith()));
                }
                if (this.getEqualTo() != null) {
                    data.set("equalTo", om.valueToTree(this.getEqualTo()));
                }
                if (this.getNotEndsWith() != null) {
                    data.set("notEndsWith", om.valueToTree(this.getNotEndsWith()));
                }
                if (this.getNotEquals() != null) {
                    data.set("notEquals", om.valueToTree(this.getNotEquals()));
                }
                if (this.getNotStartsWith() != null) {
                    data.set("notStartsWith", om.valueToTree(this.getNotStartsWith()));
                }
                if (this.getStartsWith() != null) {
                    data.set("startsWith", om.valueToTree(this.getStartsWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedFieldSelectorProperty.Jsii$Proxy that = (AdvancedFieldSelectorProperty.Jsii$Proxy) o;

                if (!field.equals(that.field)) return false;
                if (this.endsWith != null ? !this.endsWith.equals(that.endsWith) : that.endsWith != null) return false;
                if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) return false;
                if (this.notEndsWith != null ? !this.notEndsWith.equals(that.notEndsWith) : that.notEndsWith != null) return false;
                if (this.notEquals != null ? !this.notEquals.equals(that.notEquals) : that.notEquals != null) return false;
                if (this.notStartsWith != null ? !this.notStartsWith.equals(that.notStartsWith) : that.notStartsWith != null) return false;
                return this.startsWith != null ? this.startsWith.equals(that.startsWith) : that.startsWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field.hashCode();
                result = 31 * result + (this.endsWith != null ? this.endsWith.hashCode() : 0);
                result = 31 * result + (this.equalTo != null ? this.equalTo.hashCode() : 0);
                result = 31 * result + (this.notEndsWith != null ? this.notEndsWith.hashCode() : 0);
                result = 31 * result + (this.notEquals != null ? this.notEquals.hashCode() : 0);
                result = 31 * result + (this.notStartsWith != null ? this.notStartsWith.hashCode() : 0);
                result = 31 * result + (this.startsWith != null ? this.startsWith.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnEventDataStore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The advanced event selectors to use to select the events for the data store.
         * <p>
         * You can configure up to five advanced event selectors for each event data store.
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * <p>
         * @return {@code this}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final software.amazon.awscdk.core.IResolvable advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }
        /**
         * The advanced event selectors to use to select the events for the data store.
         * <p>
         * You can configure up to five advanced event selectors for each event data store.
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced">Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * <p>
         * For more information about how to use advanced event selectors to include AWS Config configuration items in your event data store, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-cli-create-eds-config.html">Create an event data store for AWS Config configuration items</a> in the CloudTrail User Guide.
         * <p>
         * @return {@code this}
         * @param advancedEventSelectors The advanced event selectors to use to select the events for the data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }

        /**
         * Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail.
         * <p>
         * The value can be an alias name prefixed by <code>alias/</code> , a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         * <p>
         * <blockquote>
         * <p>
         * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from logging events to the event data store, and prevents users from querying the data in the event data store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up your event data store.
         * <p>
         * </blockquote>
         * <p>
         * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li><code>alias/MyAliasName</code></li>
         * <li><code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code></li>
         * <li><code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
         * <li><code>12345678-1234-1234-1234-123456789012</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the events delivered by CloudTrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
         * <p>
         * @return {@code this}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final java.lang.Boolean multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }
        /**
         * Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created.
         * <p>
         * @return {@code this}
         * @param multiRegionEnabled Specifies whether the event data store includes events from all regions, or only from the region in which the event data store is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final software.amazon.awscdk.core.IResolvable multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }

        /**
         * The name of the event data store.
         * <p>
         * @return {@code this}
         * @param name The name of the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * <p>
         * @return {@code this}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final java.lang.Boolean organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }
        /**
         * Specifies whether an event data store collects events logged for an organization in AWS Organizations .
         * <p>
         * @return {@code this}
         * @param organizationEnabled Specifies whether an event data store collects events logged for an organization in AWS Organizations . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final software.amazon.awscdk.core.IResolvable organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }

        /**
         * The retention period of the event data store, in days.
         * <p>
         * You can set a retention period of up to 2557 days, the equivalent of seven years.
         * <p>
         * @return {@code this}
         * @param retentionPeriod The retention period of the event data store, in days. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final java.lang.Number retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * A list of tags.
         * <p>
         * @return {@code this}
         * @param tags A list of tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies whether termination protection is enabled for the event data store.
         * <p>
         * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final java.lang.Boolean terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }
        /**
         * Specifies whether termination protection is enabled for the event data store.
         * <p>
         * If termination protection is enabled, you cannot delete the event data store until termination protection is disabled.
         * <p>
         * @return {@code this}
         * @param terminationProtectionEnabled Specifies whether termination protection is enabled for the event data store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final software.amazon.awscdk.core.IResolvable terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnEventDataStore build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnEventDataStore(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder();
            }
            return this.props;
        }
    }
}
