package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) Specify how missing data points are treated during alarm evaluation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .timeout(Duration.minutes(5))
 *         .build();
 * if (fn.getTimeout()) {
 *     Alarm.Builder.create(this, "MyAlarm")
 *             .metric(fn.metricDuration().with(MetricOptions.builder()
 *                     .statistic("Maximum")
 *                     .build()))
 *             .evaluationPeriods(1)
 *             .datapointsToAlarm(1)
 *             .threshold(fn.timeout.toMilliseconds())
 *             .treatMissingData(TreatMissingData.IGNORE)
 *             .alarmName("My Lambda Timeout")
 *             .build();
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:56.926Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cloudwatch.TreatMissingData")
public enum TreatMissingData {
    /**
     * (experimental) Missing data points are treated as breaching the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BREACHING,
    /**
     * (experimental) Missing data points are treated as being within the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOT_BREACHING,
    /**
     * (experimental) The current alarm state is maintained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    IGNORE,
    /**
     * (experimental) The alarm does not consider missing data points when evaluating whether to change state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MISSING,
}
