package software.amazon.awscdk.services.codebuild;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Project codebuildProject = Project.Builder.create(this, "Project")
 *         .projectName("MyTestProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("echo \"Hello, CodeBuild!\""))))))
 *         .build();
 * CodeBuildStartBuild task = CodeBuildStartBuild.Builder.create(this, "Task")
 *         .project(codebuildProject)
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .environmentVariablesOverride(Map.of(
 *                 "ZONE", BuildEnvironmentVariable.builder()
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .value(JsonPath.stringAt("$.envVariables.zone"))
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.011Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.BuildEnvironmentVariableType")
public enum BuildEnvironmentVariableType {
    /**
     * (experimental) An environment variable in plaintext format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PLAINTEXT,
    /**
     * (experimental) An environment variable stored in Systems Manager Parameter Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PARAMETER_STORE,
    /**
     * (experimental) An environment variable stored in AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SECRETS_MANAGER,
}
