package software.amazon.awscdk.services.codebuild;

/**
 * (experimental) Local cache modes to enable for the CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project.Builder.create(this, "Project")
 *         .source(Source.gitHubEnterprise(GitHubEnterpriseSourceProps.builder()
 *                 .httpsCloneUrl("https://my-github-enterprise.com/owner/repo")
 *                 .build()))
 *         // Enable Docker AND custom caching
 *         .cache(Cache.local(LocalCacheMode.DOCKER_LAYER, LocalCacheMode.CUSTOM))
 *         // BuildSpec with a 'cache' section necessary for 'CUSTOM' caching. This can
 *         // also come from 'buildspec.yml' in your source.
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("..."))),
 *                 "cache", Map.of(
 *                         "paths", List.of("/root/cachedir/**&#47;*")))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.131Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codebuild.LocalCacheMode")
public enum LocalCacheMode {
    /**
     * (experimental) Caches Git metadata for primary and secondary sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SOURCE,
    /**
     * (experimental) Caches existing Docker layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DOCKER_LAYER,
    /**
     * (experimental) Caches directories you specify in the buildspec file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CUSTOM,
}
