package software.amazon.awscdk.services.codepipeline;

/**
 * Properties for defining a `CfnPipeline`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Object configuration;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .roleArn("roleArn")
 *         .stages(List.of(StageDeclarationProperty.builder()
 *                 .actions(List.of(ActionDeclarationProperty.builder()
 *                         .actionTypeId(ActionTypeIdProperty.builder()
 *                                 .category("category")
 *                                 .owner("owner")
 *                                 .provider("provider")
 *                                 .version("version")
 *                                 .build())
 *                         .name("name")
 *                         // the properties below are optional
 *                         .configuration(configuration)
 *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .outputArtifacts(List.of(OutputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .region("region")
 *                         .roleArn("roleArn")
 *                         .runOrder(123)
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .blockers(List.of(BlockerDeclarationProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .artifactStore(ArtifactStoreProperty.builder()
 *                 .location("location")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .encryptionKey(EncryptionKeyProperty.builder()
 *                         .id("id")
 *                         .type("type")
 *                         .build())
 *                 .build())
 *         .artifactStores(List.of(ArtifactStoreMapProperty.builder()
 *                 .artifactStore(ArtifactStoreProperty.builder()
 *                         .location("location")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .encryptionKey(EncryptionKeyProperty.builder()
 *                                 .id("id")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .region("region")
 *                 .build()))
 *         .disableInboundStageTransitions(List.of(StageTransitionProperty.builder()
 *                 .reason("reason")
 *                 .stageName("stageName")
 *                 .build()))
 *         .name("name")
 *         .restartExecutionOnUpdate(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codepipeline.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStages();

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStore() {
        return null;
    }

    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStores() {
        return null;
    }

    /**
     * Represents the input of a `DisableStageTransition` action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableInboundStageTransitions() {
        return null;
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRestartExecutionOnUpdate() {
        return null;
    }

    /**
     * Specifies the tags applied to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.String roleArn;
        java.lang.Object stages;
        java.lang.Object artifactStore;
        java.lang.Object artifactStores;
        java.lang.Object disableInboundStageTransitions;
        java.lang.String name;
        java.lang.Object restartExecutionOnUpdate;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPipelineProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getStages}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(software.amazon.awscdk.core.IResolvable stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getStages}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(java.util.List<? extends java.lang.Object> stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStore}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored.
         *                      <blockquote>
         *                      <p>
         *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStore}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored.
         *                      <blockquote>
         *                      <p>
         *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(software.amazon.awscdk.core.IResolvable artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStores}
         * @param artifactStores A mapping of `artifactStore` objects and their corresponding AWS Regions.
         *                       There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(software.amazon.awscdk.core.IResolvable artifactStores) {
            this.artifactStores = artifactStores;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStores}
         * @param artifactStores A mapping of `artifactStore` objects and their corresponding AWS Regions.
         *                       There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(java.util.List<? extends java.lang.Object> artifactStores) {
            this.artifactStores = artifactStores;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getDisableInboundStageTransitions}
         * @param disableInboundStageTransitions Represents the input of a `DisableStageTransition` action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(software.amazon.awscdk.core.IResolvable disableInboundStageTransitions) {
            this.disableInboundStageTransitions = disableInboundStageTransitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getDisableInboundStageTransitions}
         * @param disableInboundStageTransitions Represents the input of a `DisableStageTransition` action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(java.util.List<? extends java.lang.Object> disableInboundStageTransitions) {
            this.disableInboundStageTransitions = disableInboundStageTransitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getName}
         * @param name The name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(java.lang.Boolean restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(software.amazon.awscdk.core.IResolvable restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTags}
         * @param tags Specifies the tags applied to the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.String roleArn;
        private final java.lang.Object stages;
        private final java.lang.Object artifactStore;
        private final java.lang.Object artifactStores;
        private final java.lang.Object disableInboundStageTransitions;
        private final java.lang.String name;
        private final java.lang.Object restartExecutionOnUpdate;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.artifactStore = software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.artifactStores = software.amazon.jsii.Kernel.get(this, "artifactStores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.disableInboundStageTransitions = software.amazon.jsii.Kernel.get(this, "disableInboundStageTransitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restartExecutionOnUpdate = software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.stages = java.util.Objects.requireNonNull(builder.stages, "stages is required");
            this.artifactStore = builder.artifactStore;
            this.artifactStores = builder.artifactStores;
            this.disableInboundStageTransitions = builder.disableInboundStageTransitions;
            this.name = builder.name;
            this.restartExecutionOnUpdate = builder.restartExecutionOnUpdate;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getStages() {
            return this.stages;
        }

        @Override
        public final java.lang.Object getArtifactStore() {
            return this.artifactStore;
        }

        @Override
        public final java.lang.Object getArtifactStores() {
            return this.artifactStores;
        }

        @Override
        public final java.lang.Object getDisableInboundStageTransitions() {
            return this.disableInboundStageTransitions;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRestartExecutionOnUpdate() {
            return this.restartExecutionOnUpdate;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("stages", om.valueToTree(this.getStages()));
            if (this.getArtifactStore() != null) {
                data.set("artifactStore", om.valueToTree(this.getArtifactStore()));
            }
            if (this.getArtifactStores() != null) {
                data.set("artifactStores", om.valueToTree(this.getArtifactStores()));
            }
            if (this.getDisableInboundStageTransitions() != null) {
                data.set("disableInboundStageTransitions", om.valueToTree(this.getDisableInboundStageTransitions()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRestartExecutionOnUpdate() != null) {
                data.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_codepipeline.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (!stages.equals(that.stages)) return false;
            if (this.artifactStore != null ? !this.artifactStore.equals(that.artifactStore) : that.artifactStore != null) return false;
            if (this.artifactStores != null ? !this.artifactStores.equals(that.artifactStores) : that.artifactStores != null) return false;
            if (this.disableInboundStageTransitions != null ? !this.disableInboundStageTransitions.equals(that.disableInboundStageTransitions) : that.disableInboundStageTransitions != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.restartExecutionOnUpdate != null ? !this.restartExecutionOnUpdate.equals(that.restartExecutionOnUpdate) : that.restartExecutionOnUpdate != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.stages.hashCode());
            result = 31 * result + (this.artifactStore != null ? this.artifactStore.hashCode() : 0);
            result = 31 * result + (this.artifactStores != null ? this.artifactStores.hashCode() : 0);
            result = 31 * result + (this.disableInboundStageTransitions != null ? this.disableInboundStageTransitions.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.restartExecutionOnUpdate != null ? this.restartExecutionOnUpdate.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
