package software.amazon.awscdk.services.codepipeline.actions;

/**
 * (experimental) CodePipeline Action to deploy an ECS Service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * FargateService service;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact buildOutput = new Artifact();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(
 *             EcsDeployAction.Builder.create()
 *                     .actionName("DeployAction")
 *                     .service(service)
 *                     // if your file is called imagedefinitions.json,
 *                     // use the `input` property,
 *                     // and leave out the `imageFile` property
 *                     .input(buildOutput)
 *                     // if your file name is _not_ imagedefinitions.json,
 *                     // use the `imageFile` property,
 *                     // and leave out the `input` property
 *                     .imageFile(buildOutput.atPath("imageDef.json"))
 *                     .deploymentTimeout(Duration.minutes(60))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.606Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codepipeline_actions.EcsDeployAction")
public class EcsDeployAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected EcsDeployAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsDeployAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EcsDeployAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.EcsDeployActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     * <p>
     * @param _scope This parameter is required.
     * @param _stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage _stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_stage, "_stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.EcsDeployAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.EcsDeployAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.EcsDeployActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.EcsDeployActionProps.Builder();
        }

        /**
         * (experimental) The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * (experimental) The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * (experimental) The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * (experimental) The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your {&#64;link IAction.bind}
         * method in the {&#64;link ActionBindOptions.role} property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The ECS Service to deploy.
         * <p>
         * @return {@code this}
         * @param service The ECS Service to deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(final software.amazon.awscdk.services.ecs.IBaseService service) {
            this.props.service(service);
            return this;
        }

        /**
         * (experimental) Timeout for the ECS deployment in minutes.
         * <p>
         * Value must be between 1-60.
         * <p>
         * Default: - 60 minutes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-ECS.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-ECS.html</a>
         * @param deploymentTimeout Timeout for the ECS deployment in minutes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deploymentTimeout(final software.amazon.awscdk.core.Duration deploymentTimeout) {
            this.props.deploymentTimeout(deploymentTimeout);
            return this;
        }

        /**
         * (experimental) The name of the JSON image definitions file to use for deployments.
         * <p>
         * The JSON file is a list of objects,
         * each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
         * and <code>imageUri</code> is the Docker image URI you want to update your service with.
         * Use this property if you want to use a different name for this file than the default 'imagedefinitions.json'.
         * If you use this property, you don't need to specify the <code>input</code> property.
         * <p>
         * Default: - one of this property, or `input`, is required
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions</a>
         * @param imageFile The name of the JSON image definitions file to use for deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder imageFile(final software.amazon.awscdk.services.codepipeline.ArtifactPath imageFile) {
            this.props.imageFile(imageFile);
            return this;
        }

        /**
         * (experimental) The input artifact that contains the JSON image definitions file to use for deployments.
         * <p>
         * The JSON file is a list of objects,
         * each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
         * and <code>imageUri</code> is the Docker image URI you want to update your service with.
         * If you use this property, it's assumed the file is called 'imagedefinitions.json'.
         * If your build uses a different file, leave this property empty,
         * and use the <code>imageFile</code> property instead.
         * <p>
         * Default: - one of this property, or `imageFile`, is required
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions</a>
         * @param input The input artifact that contains the JSON image definitions file to use for deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.EcsDeployAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.EcsDeployAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.EcsDeployAction(
                this.props.build()
            );
        }
    }
}
