package software.amazon.awscdk.services.codestar;

/**
 * (experimental) The GitHubRepository resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * GitHubRepository.Builder.create(this, "GitHubRepo")
 *         .owner("aws")
 *         .repositoryName("aws-cdk")
 *         .accessToken(SecretValue.secretsManager("my-github-token", SecretsManagerSecretOptions.builder()
 *                 .jsonField("token")
 *                 .build()))
 *         .contentsBucket(Bucket.fromBucketName(this, "Bucket", "bucket-name"))
 *         .contentsKey("import.zip")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_codestar.GitHubRepository")
public class GitHubRepository extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.codestar.IGitHubRepository {

    protected GitHubRepository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GitHubRepository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GitHubRepository(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestar.GitHubRepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) the repository owner.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getOwner() {
        return software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) the repository name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepo() {
        return software.amazon.jsii.Kernel.get(this, "repo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codestar.GitHubRepository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codestar.GitHubRepository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codestar.GitHubRepositoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codestar.GitHubRepositoryProps.Builder();
        }

        /**
         * (experimental) The GitHub user's personal access token for the GitHub repository.
         * <p>
         * @return {@code this}
         * @param accessToken The GitHub user's personal access token for the GitHub repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessToken(final software.amazon.awscdk.core.SecretValue accessToken) {
            this.props.accessToken(accessToken);
            return this;
        }

        /**
         * (experimental) The name of the Amazon S3 bucket that contains the ZIP file with the content to be committed to the new repository.
         * <p>
         * @return {@code this}
         * @param contentsBucket The name of the Amazon S3 bucket that contains the ZIP file with the content to be committed to the new repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsBucket(final software.amazon.awscdk.services.s3.IBucket contentsBucket) {
            this.props.contentsBucket(contentsBucket);
            return this;
        }

        /**
         * (experimental) The S3 object key or file name for the ZIP file.
         * <p>
         * @return {@code this}
         * @param contentsKey The S3 object key or file name for the ZIP file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsKey(final java.lang.String contentsKey) {
            this.props.contentsKey(contentsKey);
            return this;
        }

        /**
         * (experimental) The GitHub user name for the owner of the GitHub repository to be created.
         * <p>
         * If this
         * repository should be owned by a GitHub organization, provide its name
         * <p>
         * @return {@code this}
         * @param owner The GitHub user name for the owner of the GitHub repository to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder owner(final java.lang.String owner) {
            this.props.owner(owner);
            return this;
        }

        /**
         * (experimental) The name of the repository you want to create in GitHub with AWS CloudFormation stack creation.
         * <p>
         * @return {@code this}
         * @param repositoryName The name of the repository you want to create in GitHub with AWS CloudFormation stack creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * (experimental) The object version of the ZIP file, if versioning is enabled for the Amazon S3 bucket.
         * <p>
         * Default: - not specified
         * <p>
         * @return {@code this}
         * @param contentsS3Version The object version of the ZIP file, if versioning is enabled for the Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentsS3Version(final java.lang.String contentsS3Version) {
            this.props.contentsS3Version(contentsS3Version);
            return this;
        }

        /**
         * (experimental) A comment or description about the new repository.
         * <p>
         * This description is displayed in GitHub after the repository
         * is created.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A comment or description about the new repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Indicates whether to enable issues for the GitHub repository.
         * <p>
         * You can use GitHub issues to track information
         * and bugs for your repository.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableIssues Indicates whether to enable issues for the GitHub repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableIssues(final java.lang.Boolean enableIssues) {
            this.props.enableIssues(enableIssues);
            return this;
        }

        /**
         * (experimental) Indicates whether the GitHub repository is a private repository.
         * <p>
         * If so, you choose who can see and commit to
         * this repository.
         * <p>
         * Default: RepositoryVisibility.PUBLIC
         * <p>
         * @return {@code this}
         * @param visibility Indicates whether the GitHub repository is a private repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibility(final software.amazon.awscdk.services.codestar.RepositoryVisibility visibility) {
            this.props.visibility(visibility);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codestar.GitHubRepository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codestar.GitHubRepository build() {
            return new software.amazon.awscdk.services.codestar.GitHubRepository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
