package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::UserPool`.
 * <p>
 * The <code>AWS::Cognito::UserPool</code> resource creates an Amazon Cognito user pool. For more information on working with Amazon Cognito user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a> and <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html">CreateUserPool</a> .
 * <p>
 * <blockquote>
 * <p>
 * If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object userPoolTags;
 * CfnUserPool cfnUserPool = CfnUserPool.Builder.create(this, "MyCfnUserPool")
 *         .accountRecoverySetting(AccountRecoverySettingProperty.builder()
 *                 .recoveryMechanisms(List.of(RecoveryOptionProperty.builder()
 *                         .name("name")
 *                         .priority(123)
 *                         .build()))
 *                 .build())
 *         .adminCreateUserConfig(AdminCreateUserConfigProperty.builder()
 *                 .allowAdminCreateUserOnly(false)
 *                 .inviteMessageTemplate(InviteMessageTemplateProperty.builder()
 *                         .emailMessage("emailMessage")
 *                         .emailSubject("emailSubject")
 *                         .smsMessage("smsMessage")
 *                         .build())
 *                 .unusedAccountValidityDays(123)
 *                 .build())
 *         .aliasAttributes(List.of("aliasAttributes"))
 *         .autoVerifiedAttributes(List.of("autoVerifiedAttributes"))
 *         .deletionProtection("deletionProtection")
 *         .deviceConfiguration(DeviceConfigurationProperty.builder()
 *                 .challengeRequiredOnNewDevice(false)
 *                 .deviceOnlyRememberedOnUserPrompt(false)
 *                 .build())
 *         .emailConfiguration(EmailConfigurationProperty.builder()
 *                 .configurationSet("configurationSet")
 *                 .emailSendingAccount("emailSendingAccount")
 *                 .from("from")
 *                 .replyToEmailAddress("replyToEmailAddress")
 *                 .sourceArn("sourceArn")
 *                 .build())
 *         .emailVerificationMessage("emailVerificationMessage")
 *         .emailVerificationSubject("emailVerificationSubject")
 *         .enabledMfas(List.of("enabledMfas"))
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .createAuthChallenge("createAuthChallenge")
 *                 .customEmailSender(CustomEmailSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .customMessage("customMessage")
 *                 .customSmsSender(CustomSMSSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .defineAuthChallenge("defineAuthChallenge")
 *                 .kmsKeyId("kmsKeyId")
 *                 .postAuthentication("postAuthentication")
 *                 .postConfirmation("postConfirmation")
 *                 .preAuthentication("preAuthentication")
 *                 .preSignUp("preSignUp")
 *                 .preTokenGeneration("preTokenGeneration")
 *                 .userMigration("userMigration")
 *                 .verifyAuthChallengeResponse("verifyAuthChallengeResponse")
 *                 .build())
 *         .mfaConfiguration("mfaConfiguration")
 *         .policies(PoliciesProperty.builder()
 *                 .passwordPolicy(PasswordPolicyProperty.builder()
 *                         .minimumLength(123)
 *                         .requireLowercase(false)
 *                         .requireNumbers(false)
 *                         .requireSymbols(false)
 *                         .requireUppercase(false)
 *                         .temporaryPasswordValidityDays(123)
 *                         .build())
 *                 .build())
 *         .schema(List.of(SchemaAttributeProperty.builder()
 *                 .attributeDataType("attributeDataType")
 *                 .developerOnlyAttribute(false)
 *                 .mutable(false)
 *                 .name("name")
 *                 .numberAttributeConstraints(NumberAttributeConstraintsProperty.builder()
 *                         .maxValue("maxValue")
 *                         .minValue("minValue")
 *                         .build())
 *                 .required(false)
 *                 .stringAttributeConstraints(StringAttributeConstraintsProperty.builder()
 *                         .maxLength("maxLength")
 *                         .minLength("minLength")
 *                         .build())
 *                 .build()))
 *         .smsAuthenticationMessage("smsAuthenticationMessage")
 *         .smsConfiguration(SmsConfigurationProperty.builder()
 *                 .externalId("externalId")
 *                 .snsCallerArn("snsCallerArn")
 *                 .snsRegion("snsRegion")
 *                 .build())
 *         .smsVerificationMessage("smsVerificationMessage")
 *         .userAttributeUpdateSettings(UserAttributeUpdateSettingsProperty.builder()
 *                 .attributesRequireVerificationBeforeUpdate(List.of("attributesRequireVerificationBeforeUpdate"))
 *                 .build())
 *         .usernameAttributes(List.of("usernameAttributes"))
 *         .usernameConfiguration(UsernameConfigurationProperty.builder()
 *                 .caseSensitive(false)
 *                 .build())
 *         .userPoolAddOns(UserPoolAddOnsProperty.builder()
 *                 .advancedSecurityMode("advancedSecurityMode")
 *                 .build())
 *         .userPoolName("userPoolName")
 *         .userPoolTags(userPoolTags)
 *         .verificationMessageTemplate(VerificationMessageTemplateProperty.builder()
 *                 .defaultEmailOption("defaultEmailOption")
 *                 .emailMessage("emailMessage")
 *                 .emailMessageByLink("emailMessageByLink")
 *                 .emailSubject("emailSubject")
 *                 .emailSubjectByLink("emailSubjectByLink")
 *                 .smsMessage("smsMessage")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool")
public class CfnUserPool extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnUserPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Cognito::UserPool`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Cognito::UserPool`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the user pool, such as `arn:aws:cognito-idp:us-east-1:123412341234:userpool/us-east-1_123412341` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The provider name of the Amazon Cognito user pool, specified as a `String` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProviderName() {
        return software.amazon.jsii.Kernel.get(this, "attrProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the provider of the Amazon Cognito user pool, specified as a `String` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProviderUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrProviderUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tag keys and values to assign to the user pool.
     * <p>
     * A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
     * <p>
     * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccountRecoverySetting() {
        return software.amazon.jsii.Kernel.get(this, "accountRecoverySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
     * <p>
     * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountRecoverySetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty value) {
        software.amazon.jsii.Kernel.set(this, "accountRecoverySetting", value);
    }

    /**
     * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
     * <p>
     * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountRecoverySetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accountRecoverySetting", value);
    }

    /**
     * The configuration for creating a new user profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdminCreateUserConfig() {
        return software.amazon.jsii.Kernel.get(this, "adminCreateUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for creating a new user profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdminCreateUserConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "adminCreateUserConfig", value);
    }

    /**
     * The configuration for creating a new user profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdminCreateUserConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "adminCreateUserConfig", value);
    }

    /**
     * Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
     * <p>
     * <blockquote>
     * <p>
     * This user pool property cannot be updated.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliasAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "aliasAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
     * <p>
     * <blockquote>
     * <p>
     * This user pool property cannot be updated.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAliasAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "aliasAttributes", value);
    }

    /**
     * The attributes to be auto-verified.
     * <p>
     * Possible values: <em>email</em> , <em>phone_number</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoVerifiedAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "autoVerifiedAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The attributes to be auto-verified.
     * <p>
     * Possible values: <em>email</em> , <em>phone_number</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoVerifiedAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "autoVerifiedAttributes", value);
    }

    /**
     * `AWS::Cognito::UserPool.DeletionProtection`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Cognito::UserPool.DeletionProtection`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The device-remembering configuration for a user pool.
     * <p>
     * A null value indicates that you have deactivated device remembering in your user pool.
     * <p>
     * <blockquote>
     * <p>
     * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeviceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "deviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The device-remembering configuration for a user pool.
     * <p>
     * A null value indicates that you have deactivated device remembering in your user pool.
     * <p>
     * <blockquote>
     * <p>
     * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "deviceConfiguration", value);
    }

    /**
     * The device-remembering configuration for a user pool.
     * <p>
     * A null value indicates that you have deactivated device remembering in your user pool.
     * <p>
     * <blockquote>
     * <p>
     * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deviceConfiguration", value);
    }

    /**
     * The email configuration of your user pool.
     * <p>
     * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEmailConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "emailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The email configuration of your user pool.
     * <p>
     * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "emailConfiguration", value);
    }

    /**
     * The email configuration of your user pool.
     * <p>
     * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "emailConfiguration", value);
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationMessage() {
        return software.amazon.jsii.Kernel.get(this, "emailVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailVerificationMessage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "emailVerificationMessage", value);
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationSubject() {
        return software.amazon.jsii.Kernel.get(this, "emailVerificationSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailVerificationSubject(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "emailVerificationSubject", value);
    }

    /**
     * Enables MFA on a specified user pool.
     * <p>
     * To disable all MFAs after it has been enabled, set MfaConfiguration to “OFF” and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to “OFF”. Can be one of the following values:
     * <p>
     * <ul>
     * <li><code>SMS_MFA</code> - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.</li>
     * <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
     * </ul>
     * <p>
     * Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledMfas() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enabledMfas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Enables MFA on a specified user pool.
     * <p>
     * To disable all MFAs after it has been enabled, set MfaConfiguration to “OFF” and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to “OFF”. Can be one of the following values:
     * <p>
     * <ul>
     * <li><code>SMS_MFA</code> - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.</li>
     * <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
     * </ul>
     * <p>
     * Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabledMfas(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enabledMfas", value);
    }

    /**
     * The Lambda trigger configuration information for the new user pool.
     * <p>
     * <blockquote>
     * <p>
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
     * <p>
     * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
     * <p>
     * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Lambda trigger configuration information for the new user pool.
     * <p>
     * <blockquote>
     * <p>
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
     * <p>
     * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
     * <p>
     * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "lambdaConfig", value);
    }

    /**
     * The Lambda trigger configuration information for the new user pool.
     * <p>
     * <blockquote>
     * <p>
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
     * <p>
     * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
     * <p>
     * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lambdaConfig", value);
    }

    /**
     * The multi-factor authentication (MFA) configuration. Valid values include:.
     * <p>
     * <ul>
     * <li><code>OFF</code> MFA won't be used for any users.</li>
     * <li><code>ON</code> MFA is required for all users to sign in.</li>
     * <li><code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMfaConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "mfaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The multi-factor authentication (MFA) configuration. Valid values include:.
     * <p>
     * <ul>
     * <li><code>OFF</code> MFA won't be used for any users.</li>
     * <li><code>ON</code> MFA is required for all users to sign in.</li>
     * <li><code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMfaConfiguration(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mfaConfiguration", value);
    }

    /**
     * The policy associated with a user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The policy associated with a user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * The policy associated with a user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policies", value);
    }

    /**
     * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
     * <p>
     * <blockquote>
     * <p>
     * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
     * <p>
     * <blockquote>
     * <p>
     * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schema", value);
    }

    /**
     * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
     * <p>
     * <blockquote>
     * <p>
     * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cognito.CfnUserPool.SchemaAttributeProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cognito.CfnUserPool.SchemaAttributeProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "schema", value);
    }

    /**
     * A string representing the SMS authentication message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSmsAuthenticationMessage() {
        return software.amazon.jsii.Kernel.get(this, "smsAuthenticationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string representing the SMS authentication message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSmsAuthenticationMessage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "smsAuthenticationMessage", value);
    }

    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service.
     * <p>
     * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSmsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "smsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service.
     * <p>
     * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSmsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "smsConfiguration", value);
    }

    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service.
     * <p>
     * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSmsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "smsConfiguration", value);
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSmsVerificationMessage() {
        return software.amazon.jsii.Kernel.get(this, "smsVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This parameter is no longer used.
     * <p>
     * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSmsVerificationMessage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "smsVerificationMessage", value);
    }

    /**
     * The settings for updates to user attributes.
     * <p>
     * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
     * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
     * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserAttributeUpdateSettings() {
        return software.amazon.jsii.Kernel.get(this, "userAttributeUpdateSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for updates to user attributes.
     * <p>
     * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
     * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
     * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserAttributeUpdateSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.UserAttributeUpdateSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "userAttributeUpdateSettings", value);
    }

    /**
     * The settings for updates to user attributes.
     * <p>
     * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
     * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
     * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserAttributeUpdateSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userAttributeUpdateSettings", value);
    }

    /**
     * Determines whether email addresses or phone numbers can be specified as user names when a user signs up.
     * <p>
     * Possible values: <code>phone_number</code> or <code>email</code> .
     * <p>
     * This user pool property cannot be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsernameAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "usernameAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Determines whether email addresses or phone numbers can be specified as user names when a user signs up.
     * <p>
     * Possible values: <code>phone_number</code> or <code>email</code> .
     * <p>
     * This user pool property cannot be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsernameAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "usernameAttributes", value);
    }

    /**
     * You can choose to set case sensitivity on the username input for the selected sign-in option.
     * <p>
     * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUsernameConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "usernameConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * You can choose to set case sensitivity on the username input for the selected sign-in option.
     * <p>
     * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsernameConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "usernameConfiguration", value);
    }

    /**
     * You can choose to set case sensitivity on the username input for the selected sign-in option.
     * <p>
     * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsernameConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "usernameConfiguration", value);
    }

    /**
     * Enables advanced security risk detection.
     * <p>
     * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolAddOns() {
        return software.amazon.jsii.Kernel.get(this, "userPoolAddOns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables advanced security risk detection.
     * <p>
     * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolAddOns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty value) {
        software.amazon.jsii.Kernel.set(this, "userPoolAddOns", value);
    }

    /**
     * Enables advanced security risk detection.
     * <p>
     * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolAddOns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userPoolAddOns", value);
    }

    /**
     * A string used to name the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserPoolName() {
        return software.amazon.jsii.Kernel.get(this, "userPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string used to name the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolName", value);
    }

    /**
     * The template for the verification message that the user sees when the app requests permission to access the user's information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVerificationMessageTemplate() {
        return software.amazon.jsii.Kernel.get(this, "verificationMessageTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The template for the verification message that the user sees when the app requests permission to access the user's information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVerificationMessageTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty value) {
        software.amazon.jsii.Kernel.set(this, "verificationMessageTemplate", value);
    }

    /**
     * The template for the verification message that the user sees when the app requests permission to access the user's information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVerificationMessageTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "verificationMessageTemplate", value);
    }
    /**
     * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
     * <p>
     * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AccountRecoverySettingProperty accountRecoverySettingProperty = AccountRecoverySettingProperty.builder()
     *         .recoveryMechanisms(List.of(RecoveryOptionProperty.builder()
     *                 .name("name")
     *                 .priority(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.AccountRecoverySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountRecoverySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountRecoverySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of `RecoveryOptionTypes` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecoveryMechanisms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountRecoverySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountRecoverySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountRecoverySettingProperty> {
            java.lang.Object recoveryMechanisms;

            /**
             * Sets the value of {@link AccountRecoverySettingProperty#getRecoveryMechanisms}
             * @param recoveryMechanisms The list of `RecoveryOptionTypes` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryMechanisms(software.amazon.awscdk.core.IResolvable recoveryMechanisms) {
                this.recoveryMechanisms = recoveryMechanisms;
                return this;
            }

            /**
             * Sets the value of {@link AccountRecoverySettingProperty#getRecoveryMechanisms}
             * @param recoveryMechanisms The list of `RecoveryOptionTypes` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryMechanisms(java.util.List<? extends java.lang.Object> recoveryMechanisms) {
                this.recoveryMechanisms = recoveryMechanisms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountRecoverySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountRecoverySettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountRecoverySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountRecoverySettingProperty {
            private final java.lang.Object recoveryMechanisms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recoveryMechanisms = software.amazon.jsii.Kernel.get(this, "recoveryMechanisms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recoveryMechanisms = builder.recoveryMechanisms;
            }

            @Override
            public final java.lang.Object getRecoveryMechanisms() {
                return this.recoveryMechanisms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecoveryMechanisms() != null) {
                    data.set("recoveryMechanisms", om.valueToTree(this.getRecoveryMechanisms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.AccountRecoverySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountRecoverySettingProperty.Jsii$Proxy that = (AccountRecoverySettingProperty.Jsii$Proxy) o;

                return this.recoveryMechanisms != null ? this.recoveryMechanisms.equals(that.recoveryMechanisms) : that.recoveryMechanisms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recoveryMechanisms != null ? this.recoveryMechanisms.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for `AdminCreateUser` requests.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AdminCreateUserConfigProperty adminCreateUserConfigProperty = AdminCreateUserConfigProperty.builder()
     *         .allowAdminCreateUserOnly(false)
     *         .inviteMessageTemplate(InviteMessageTemplateProperty.builder()
     *                 .emailMessage("emailMessage")
     *                 .emailSubject("emailSubject")
     *                 .smsMessage("smsMessage")
     *                 .build())
     *         .unusedAccountValidityDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.AdminCreateUserConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AdminCreateUserConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdminCreateUserConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set to `True` if only the administrator is allowed to create user profiles.
         * <p>
         * Set to <code>False</code> if users can sign themselves up via an app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowAdminCreateUserOnly() {
            return null;
        }

        /**
         * The message template to be used for the welcome message to new users.
         * <p>
         * See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInviteMessageTemplate() {
            return null;
        }

        /**
         * The user account expiration limit, in days, after which a new account that hasn't signed in is no longer usable.
         * <p>
         * To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7.
         * <p>
         * <blockquote>
         * <p>
         * If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code> , that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnusedAccountValidityDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdminCreateUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdminCreateUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdminCreateUserConfigProperty> {
            java.lang.Object allowAdminCreateUserOnly;
            java.lang.Object inviteMessageTemplate;
            java.lang.Number unusedAccountValidityDays;

            /**
             * Sets the value of {@link AdminCreateUserConfigProperty#getAllowAdminCreateUserOnly}
             * @param allowAdminCreateUserOnly Set to `True` if only the administrator is allowed to create user profiles.
             *                                 Set to <code>False</code> if users can sign themselves up via an app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAdminCreateUserOnly(java.lang.Boolean allowAdminCreateUserOnly) {
                this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
                return this;
            }

            /**
             * Sets the value of {@link AdminCreateUserConfigProperty#getAllowAdminCreateUserOnly}
             * @param allowAdminCreateUserOnly Set to `True` if only the administrator is allowed to create user profiles.
             *                                 Set to <code>False</code> if users can sign themselves up via an app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAdminCreateUserOnly(software.amazon.awscdk.core.IResolvable allowAdminCreateUserOnly) {
                this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
                return this;
            }

            /**
             * Sets the value of {@link AdminCreateUserConfigProperty#getInviteMessageTemplate}
             * @param inviteMessageTemplate The message template to be used for the welcome message to new users.
             *                              See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inviteMessageTemplate(software.amazon.awscdk.services.cognito.CfnUserPool.InviteMessageTemplateProperty inviteMessageTemplate) {
                this.inviteMessageTemplate = inviteMessageTemplate;
                return this;
            }

            /**
             * Sets the value of {@link AdminCreateUserConfigProperty#getInviteMessageTemplate}
             * @param inviteMessageTemplate The message template to be used for the welcome message to new users.
             *                              See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inviteMessageTemplate(software.amazon.awscdk.core.IResolvable inviteMessageTemplate) {
                this.inviteMessageTemplate = inviteMessageTemplate;
                return this;
            }

            /**
             * Sets the value of {@link AdminCreateUserConfigProperty#getUnusedAccountValidityDays}
             * @param unusedAccountValidityDays The user account expiration limit, in days, after which a new account that hasn't signed in is no longer usable.
             *                                  To reset the account after that time limit, you must call <code>AdminCreateUser</code> again, specifying <code>"RESEND"</code> for the <code>MessageAction</code> parameter. The default value for this parameter is 7.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  If you set a value for <code>TemporaryPasswordValidityDays</code> in <code>PasswordPolicy</code> , that value will be used, and <code>UnusedAccountValidityDays</code> will be no longer be an available parameter for that user pool.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unusedAccountValidityDays(java.lang.Number unusedAccountValidityDays) {
                this.unusedAccountValidityDays = unusedAccountValidityDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdminCreateUserConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdminCreateUserConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdminCreateUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdminCreateUserConfigProperty {
            private final java.lang.Object allowAdminCreateUserOnly;
            private final java.lang.Object inviteMessageTemplate;
            private final java.lang.Number unusedAccountValidityDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowAdminCreateUserOnly = software.amazon.jsii.Kernel.get(this, "allowAdminCreateUserOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inviteMessageTemplate = software.amazon.jsii.Kernel.get(this, "inviteMessageTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unusedAccountValidityDays = software.amazon.jsii.Kernel.get(this, "unusedAccountValidityDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowAdminCreateUserOnly = builder.allowAdminCreateUserOnly;
                this.inviteMessageTemplate = builder.inviteMessageTemplate;
                this.unusedAccountValidityDays = builder.unusedAccountValidityDays;
            }

            @Override
            public final java.lang.Object getAllowAdminCreateUserOnly() {
                return this.allowAdminCreateUserOnly;
            }

            @Override
            public final java.lang.Object getInviteMessageTemplate() {
                return this.inviteMessageTemplate;
            }

            @Override
            public final java.lang.Number getUnusedAccountValidityDays() {
                return this.unusedAccountValidityDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowAdminCreateUserOnly() != null) {
                    data.set("allowAdminCreateUserOnly", om.valueToTree(this.getAllowAdminCreateUserOnly()));
                }
                if (this.getInviteMessageTemplate() != null) {
                    data.set("inviteMessageTemplate", om.valueToTree(this.getInviteMessageTemplate()));
                }
                if (this.getUnusedAccountValidityDays() != null) {
                    data.set("unusedAccountValidityDays", om.valueToTree(this.getUnusedAccountValidityDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.AdminCreateUserConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdminCreateUserConfigProperty.Jsii$Proxy that = (AdminCreateUserConfigProperty.Jsii$Proxy) o;

                if (this.allowAdminCreateUserOnly != null ? !this.allowAdminCreateUserOnly.equals(that.allowAdminCreateUserOnly) : that.allowAdminCreateUserOnly != null) return false;
                if (this.inviteMessageTemplate != null ? !this.inviteMessageTemplate.equals(that.inviteMessageTemplate) : that.inviteMessageTemplate != null) return false;
                return this.unusedAccountValidityDays != null ? this.unusedAccountValidityDays.equals(that.unusedAccountValidityDays) : that.unusedAccountValidityDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowAdminCreateUserOnly != null ? this.allowAdminCreateUserOnly.hashCode() : 0;
                result = 31 * result + (this.inviteMessageTemplate != null ? this.inviteMessageTemplate.hashCode() : 0);
                result = 31 * result + (this.unusedAccountValidityDays != null ? this.unusedAccountValidityDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom email sender AWS Lambda trigger.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CustomEmailSenderProperty customEmailSenderProperty = CustomEmailSenderProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .lambdaVersion("lambdaVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.CustomEmailSenderProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomEmailSenderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomEmailSenderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Cognito triggers to send email notifications to users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaArn() {
            return null;
        }

        /**
         * The Lambda version represents the signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom email sender AWS Lambda function.
         * <p>
         * The only supported value is <code>V1_0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomEmailSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomEmailSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomEmailSenderProperty> {
            java.lang.String lambdaArn;
            java.lang.String lambdaVersion;

            /**
             * Sets the value of {@link CustomEmailSenderProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Cognito triggers to send email notifications to users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomEmailSenderProperty#getLambdaVersion}
             * @param lambdaVersion The Lambda version represents the signature of the "request" attribute in the "event" information that Amazon Cognito passes to your custom email sender AWS Lambda function.
             *                      The only supported value is <code>V1_0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaVersion(java.lang.String lambdaVersion) {
                this.lambdaVersion = lambdaVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomEmailSenderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomEmailSenderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomEmailSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomEmailSenderProperty {
            private final java.lang.String lambdaArn;
            private final java.lang.String lambdaVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaVersion = software.amazon.jsii.Kernel.get(this, "lambdaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = builder.lambdaArn;
                this.lambdaVersion = builder.lambdaVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            public final java.lang.String getLambdaVersion() {
                return this.lambdaVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaArn() != null) {
                    data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                }
                if (this.getLambdaVersion() != null) {
                    data.set("lambdaVersion", om.valueToTree(this.getLambdaVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.CustomEmailSenderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomEmailSenderProperty.Jsii$Proxy that = (CustomEmailSenderProperty.Jsii$Proxy) o;

                if (this.lambdaArn != null ? !this.lambdaArn.equals(that.lambdaArn) : that.lambdaArn != null) return false;
                return this.lambdaVersion != null ? this.lambdaVersion.equals(that.lambdaVersion) : that.lambdaVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn != null ? this.lambdaArn.hashCode() : 0;
                result = 31 * result + (this.lambdaVersion != null ? this.lambdaVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom SMS sender AWS Lambda trigger.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CustomSMSSenderProperty customSMSSenderProperty = CustomSMSSenderProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .lambdaVersion("lambdaVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.CustomSMSSenderProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomSMSSenderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomSMSSenderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Cognito triggers to send SMS notifications to users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaArn() {
            return null;
        }

        /**
         * The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS sender Lambda function.
         * <p>
         * The only supported value is <code>V1_0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomSMSSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomSMSSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomSMSSenderProperty> {
            java.lang.String lambdaArn;
            java.lang.String lambdaVersion;

            /**
             * Sets the value of {@link CustomSMSSenderProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Cognito triggers to send SMS notifications to users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomSMSSenderProperty#getLambdaVersion}
             * @param lambdaVersion The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS sender Lambda function.
             *                      The only supported value is <code>V1_0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaVersion(java.lang.String lambdaVersion) {
                this.lambdaVersion = lambdaVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomSMSSenderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomSMSSenderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomSMSSenderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomSMSSenderProperty {
            private final java.lang.String lambdaArn;
            private final java.lang.String lambdaVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaVersion = software.amazon.jsii.Kernel.get(this, "lambdaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = builder.lambdaArn;
                this.lambdaVersion = builder.lambdaVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            public final java.lang.String getLambdaVersion() {
                return this.lambdaVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaArn() != null) {
                    data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                }
                if (this.getLambdaVersion() != null) {
                    data.set("lambdaVersion", om.valueToTree(this.getLambdaVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.CustomSMSSenderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomSMSSenderProperty.Jsii$Proxy that = (CustomSMSSenderProperty.Jsii$Proxy) o;

                if (this.lambdaArn != null ? !this.lambdaArn.equals(that.lambdaArn) : that.lambdaArn != null) return false;
                return this.lambdaVersion != null ? this.lambdaVersion.equals(that.lambdaVersion) : that.lambdaVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn != null ? this.lambdaArn.hashCode() : 0;
                result = 31 * result + (this.lambdaVersion != null ? this.lambdaVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The device-remembering configuration for a user pool.
     * <p>
     * A <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html">DescribeUserPool</a> request returns a null value for this object when the user pool isn't configured to remember devices. When device remembering is active, you can remember a user's device with a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html">ConfirmDevice</a> API request. Additionally. when the property <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>true</code> , you must follow <code>ConfirmDevice</code> with an <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html">UpdateDeviceStatus</a> API request that sets the user's device to <code>remembered</code> or <code>not_remembered</code> .
     * <p>
     * To sign in with a remembered device, include <code>DEVICE_KEY</code> in the authentication parameters in your user's <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html">InitiateAuth</a> request. If your app doesn't include a <code>DEVICE_KEY</code> parameter, the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html#API_InitiateAuth_ResponseSyntax">response</a> from Amazon Cognito includes newly-generated <code>DEVICE_KEY</code> and <code>DEVICE_GROUP_KEY</code> values under <code>NewDeviceMetadata</code> . Store these values to use in future device-authentication requests.
     * <p>
     * <blockquote>
     * <p>
     * When you provide a value for any property of <code>DeviceConfiguration</code> , you activate the device remembering for the user pool.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * DeviceConfigurationProperty deviceConfigurationProperty = DeviceConfigurationProperty.builder()
     *         .challengeRequiredOnNewDevice(false)
     *         .deviceOnlyRememberedOnUserPrompt(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.DeviceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
         * <p>
         * <blockquote>
         * <p>
         * Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChallengeRequiredOnNewDevice() {
            return null;
        }

        /**
         * When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a [ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an [UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request.
         * <p>
         * When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code> , Amazon Cognito immediately remembers devices that you register in a <code>ConfirmDevice</code> API request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceOnlyRememberedOnUserPrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceConfigurationProperty> {
            java.lang.Object challengeRequiredOnNewDevice;
            java.lang.Object deviceOnlyRememberedOnUserPrompt;

            /**
             * Sets the value of {@link DeviceConfigurationProperty#getChallengeRequiredOnNewDevice}
             * @param challengeRequiredOnNewDevice When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
             *                                     <blockquote>
             *                                     <p>
             *                                     Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
             *                                     <p>
             *                                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder challengeRequiredOnNewDevice(java.lang.Boolean challengeRequiredOnNewDevice) {
                this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
                return this;
            }

            /**
             * Sets the value of {@link DeviceConfigurationProperty#getChallengeRequiredOnNewDevice}
             * @param challengeRequiredOnNewDevice When true, a remembered device can sign in with device authentication instead of SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
             *                                     <blockquote>
             *                                     <p>
             *                                     Whether or not <code>ChallengeRequiredOnNewDevice</code> is true, users who sign in with devices that have not been confirmed or remembered must still provide a second factor in a user pool that requires MFA.
             *                                     <p>
             *                                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder challengeRequiredOnNewDevice(software.amazon.awscdk.core.IResolvable challengeRequiredOnNewDevice) {
                this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
                return this;
            }

            /**
             * Sets the value of {@link DeviceConfigurationProperty#getDeviceOnlyRememberedOnUserPrompt}
             * @param deviceOnlyRememberedOnUserPrompt When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a [ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an [UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request.
             *                                         When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code> , Amazon Cognito immediately remembers devices that you register in a <code>ConfirmDevice</code> API request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceOnlyRememberedOnUserPrompt(java.lang.Boolean deviceOnlyRememberedOnUserPrompt) {
                this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
                return this;
            }

            /**
             * Sets the value of {@link DeviceConfigurationProperty#getDeviceOnlyRememberedOnUserPrompt}
             * @param deviceOnlyRememberedOnUserPrompt When true, Amazon Cognito doesn't automatically remember a user's device when your app sends a [ConfirmDevice](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html) API request. In your app, create a prompt for your user to choose whether they want to remember their device. Return the user's choice in an [UpdateDeviceStatus](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html) API request.
             *                                         When <code>DeviceOnlyRememberedOnUserPrompt</code> is <code>false</code> , Amazon Cognito immediately remembers devices that you register in a <code>ConfirmDevice</code> API request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceOnlyRememberedOnUserPrompt(software.amazon.awscdk.core.IResolvable deviceOnlyRememberedOnUserPrompt) {
                this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceConfigurationProperty {
            private final java.lang.Object challengeRequiredOnNewDevice;
            private final java.lang.Object deviceOnlyRememberedOnUserPrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.challengeRequiredOnNewDevice = software.amazon.jsii.Kernel.get(this, "challengeRequiredOnNewDevice", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deviceOnlyRememberedOnUserPrompt = software.amazon.jsii.Kernel.get(this, "deviceOnlyRememberedOnUserPrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.challengeRequiredOnNewDevice = builder.challengeRequiredOnNewDevice;
                this.deviceOnlyRememberedOnUserPrompt = builder.deviceOnlyRememberedOnUserPrompt;
            }

            @Override
            public final java.lang.Object getChallengeRequiredOnNewDevice() {
                return this.challengeRequiredOnNewDevice;
            }

            @Override
            public final java.lang.Object getDeviceOnlyRememberedOnUserPrompt() {
                return this.deviceOnlyRememberedOnUserPrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChallengeRequiredOnNewDevice() != null) {
                    data.set("challengeRequiredOnNewDevice", om.valueToTree(this.getChallengeRequiredOnNewDevice()));
                }
                if (this.getDeviceOnlyRememberedOnUserPrompt() != null) {
                    data.set("deviceOnlyRememberedOnUserPrompt", om.valueToTree(this.getDeviceOnlyRememberedOnUserPrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.DeviceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceConfigurationProperty.Jsii$Proxy that = (DeviceConfigurationProperty.Jsii$Proxy) o;

                if (this.challengeRequiredOnNewDevice != null ? !this.challengeRequiredOnNewDevice.equals(that.challengeRequiredOnNewDevice) : that.challengeRequiredOnNewDevice != null) return false;
                return this.deviceOnlyRememberedOnUserPrompt != null ? this.deviceOnlyRememberedOnUserPrompt.equals(that.deviceOnlyRememberedOnUserPrompt) : that.deviceOnlyRememberedOnUserPrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.challengeRequiredOnNewDevice != null ? this.challengeRequiredOnNewDevice.hashCode() : 0;
                result = 31 * result + (this.deviceOnlyRememberedOnUserPrompt != null ? this.deviceOnlyRememberedOnUserPrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The email configuration of your user pool.
     * <p>
     * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * EmailConfigurationProperty emailConfigurationProperty = EmailConfigurationProperty.builder()
     *         .configurationSet("configurationSet")
     *         .emailSendingAccount("emailSendingAccount")
     *         .from("from")
     *         .replyToEmailAddress("replyToEmailAddress")
     *         .sourceArn("sourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.EmailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The set of configuration rules that can be applied to emails sent using Amazon SES.
         * <p>
         * A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails:
         * <p>
         * <ul>
         * <li>Event publishing – Amazon SES can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other AWS services such as SNS and CloudWatch.</li>
         * <li>IP pool management – When leasing dedicated IP addresses with Amazon SES, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSet() {
            return null;
        }

        /**
         * Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration.
         * <p>
         * Specify one of the following values:
         * <p>
         * <ul>
         * <li><strong>COGNITO_DEFAULT</strong> - When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</li>
         * </ul>
         * <p>
         * To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits</a> in the <em>Amazon Cognito Developer Guide</em> .
         * <p>
         * The default FROM address is <code>no-reply&#64;verificationemail.com</code> . To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         * <p>
         * <ul>
         * <li><strong>DEVELOPER</strong> - When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS account .</li>
         * </ul>
         * <p>
         * If you use this option, provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
         * <p>
         * Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <em>service-linked role</em> , which is a type of role in your AWS account . This role contains the permissions that allow you to access Amazon SES and send email messages from your email address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <em>Amazon Cognito Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailSendingAccount() {
            return null;
        }

        /**
         * Identifies either the sender's email address or the sender's name with their email address.
         * <p>
         * For example, <code>testuser&#64;example.com</code> or <code>Test User &lt;testuser&#64;example.com&gt;</code> . This address appears before the body of the email.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrom() {
            return null;
        }

        /**
         * The destination to which the receiver of the email should reply.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplyToEmailAddress() {
            return null;
        }

        /**
         * The ARN of a verified email address in Amazon SES.
         * <p>
         * Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:
         * <p>
         * <ul>
         * <li>If you specify <code>COGNITO_DEFAULT</code> , Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</li>
         * <li>If you specify <code>DEVELOPER</code> , Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</li>
         * </ul>
         * <p>
         * The Region value of the <code>SourceArn</code> parameter must indicate a supported AWS Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailConfigurationProperty> {
            java.lang.String configurationSet;
            java.lang.String emailSendingAccount;
            java.lang.String from;
            java.lang.String replyToEmailAddress;
            java.lang.String sourceArn;

            /**
             * Sets the value of {@link EmailConfigurationProperty#getConfigurationSet}
             * @param configurationSet The set of configuration rules that can be applied to emails sent using Amazon SES.
             *                         A configuration set is applied to an email by including a reference to the configuration set in the headers of the email. Once applied, all of the rules in that configuration set are applied to the email. Configuration sets can be used to apply the following types of rules to emails:
             *                         <p>
             *                         <ul>
             *                         <li>Event publishing – Amazon SES can track the number of send, delivery, open, click, bounce, and complaint events for each email sent. Use event publishing to send information about these events to other AWS services such as SNS and CloudWatch.</li>
             *                         <li>IP pool management – When leasing dedicated IP addresses with Amazon SES, you can create groups of IP addresses, called dedicated IP pools. You can then associate the dedicated IP pools with configuration sets.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationSet(java.lang.String configurationSet) {
                this.configurationSet = configurationSet;
                return this;
            }

            /**
             * Sets the value of {@link EmailConfigurationProperty#getEmailSendingAccount}
             * @param emailSendingAccount Specifies whether Amazon Cognito uses its built-in functionality to send your users email messages, or uses your Amazon Simple Email Service email configuration.
             *                            Specify one of the following values:
             *                            <p>
             *                            <ul>
             *                            <li><strong>COGNITO_DEFAULT</strong> - When Amazon Cognito emails your users, it uses its built-in email functionality. When you use the default option, Amazon Cognito allows only a limited number of emails each day for your user pool. For typical production environments, the default email limit is less than the required delivery volume. To achieve a higher delivery volume, specify DEVELOPER to use your Amazon SES email configuration.</li>
             *                            </ul>
             *                            <p>
             *                            To look up the email delivery limit for the default option, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html">Limits</a> in the <em>Amazon Cognito Developer Guide</em> .
             *                            <p>
             *                            The default FROM address is <code>no-reply&#64;verificationemail.com</code> . To customize the FROM address, provide the Amazon Resource Name (ARN) of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
             *                            <p>
             *                            <ul>
             *                            <li><strong>DEVELOPER</strong> - When Amazon Cognito emails your users, it uses your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to send email from your verified email address. When you use this option, the email delivery limits are the same limits that apply to your Amazon SES verified email address in your AWS account .</li>
             *                            </ul>
             *                            <p>
             *                            If you use this option, provide the ARN of an Amazon SES verified email address for the <code>SourceArn</code> parameter.
             *                            <p>
             *                            Before Amazon Cognito can email your users, it requires additional permissions to call Amazon SES on your behalf. When you update your user pool with this option, Amazon Cognito creates a <em>service-linked role</em> , which is a type of role in your AWS account . This role contains the permissions that allow you to access Amazon SES and send email messages from your email address. For more information about the service-linked role that Amazon Cognito creates, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon Cognito</a> in the <em>Amazon Cognito Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailSendingAccount(java.lang.String emailSendingAccount) {
                this.emailSendingAccount = emailSendingAccount;
                return this;
            }

            /**
             * Sets the value of {@link EmailConfigurationProperty#getFrom}
             * @param from Identifies either the sender's email address or the sender's name with their email address.
             *             For example, <code>testuser&#64;example.com</code> or <code>Test User &lt;testuser&#64;example.com&gt;</code> . This address appears before the body of the email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder from(java.lang.String from) {
                this.from = from;
                return this;
            }

            /**
             * Sets the value of {@link EmailConfigurationProperty#getReplyToEmailAddress}
             * @param replyToEmailAddress The destination to which the receiver of the email should reply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replyToEmailAddress(java.lang.String replyToEmailAddress) {
                this.replyToEmailAddress = replyToEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link EmailConfigurationProperty#getSourceArn}
             * @param sourceArn The ARN of a verified email address in Amazon SES.
             *                  Amazon Cognito uses this email address in one of the following ways, depending on the value that you specify for the <code>EmailSendingAccount</code> parameter:
             *                  <p>
             *                  <ul>
             *                  <li>If you specify <code>COGNITO_DEFAULT</code> , Amazon Cognito uses this address as the custom FROM address when it emails your users using its built-in email account.</li>
             *                  <li>If you specify <code>DEVELOPER</code> , Amazon Cognito emails your users with this address by calling Amazon SES on your behalf.</li>
             *                  </ul>
             *                  <p>
             *                  The Region value of the <code>SourceArn</code> parameter must indicate a supported AWS Region of your user pool. Typically, the Region in the <code>SourceArn</code> and the user pool Region are the same. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping">Amazon SES email configuration regions</a> in the <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailConfigurationProperty {
            private final java.lang.String configurationSet;
            private final java.lang.String emailSendingAccount;
            private final java.lang.String from;
            private final java.lang.String replyToEmailAddress;
            private final java.lang.String sourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationSet = software.amazon.jsii.Kernel.get(this, "configurationSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailSendingAccount = software.amazon.jsii.Kernel.get(this, "emailSendingAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replyToEmailAddress = software.amazon.jsii.Kernel.get(this, "replyToEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationSet = builder.configurationSet;
                this.emailSendingAccount = builder.emailSendingAccount;
                this.from = builder.from;
                this.replyToEmailAddress = builder.replyToEmailAddress;
                this.sourceArn = builder.sourceArn;
            }

            @Override
            public final java.lang.String getConfigurationSet() {
                return this.configurationSet;
            }

            @Override
            public final java.lang.String getEmailSendingAccount() {
                return this.emailSendingAccount;
            }

            @Override
            public final java.lang.String getFrom() {
                return this.from;
            }

            @Override
            public final java.lang.String getReplyToEmailAddress() {
                return this.replyToEmailAddress;
            }

            @Override
            public final java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurationSet() != null) {
                    data.set("configurationSet", om.valueToTree(this.getConfigurationSet()));
                }
                if (this.getEmailSendingAccount() != null) {
                    data.set("emailSendingAccount", om.valueToTree(this.getEmailSendingAccount()));
                }
                if (this.getFrom() != null) {
                    data.set("from", om.valueToTree(this.getFrom()));
                }
                if (this.getReplyToEmailAddress() != null) {
                    data.set("replyToEmailAddress", om.valueToTree(this.getReplyToEmailAddress()));
                }
                if (this.getSourceArn() != null) {
                    data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.EmailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailConfigurationProperty.Jsii$Proxy that = (EmailConfigurationProperty.Jsii$Proxy) o;

                if (this.configurationSet != null ? !this.configurationSet.equals(that.configurationSet) : that.configurationSet != null) return false;
                if (this.emailSendingAccount != null ? !this.emailSendingAccount.equals(that.emailSendingAccount) : that.emailSendingAccount != null) return false;
                if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
                if (this.replyToEmailAddress != null ? !this.replyToEmailAddress.equals(that.replyToEmailAddress) : that.replyToEmailAddress != null) return false;
                return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationSet != null ? this.configurationSet.hashCode() : 0;
                result = 31 * result + (this.emailSendingAccount != null ? this.emailSendingAccount.hashCode() : 0);
                result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
                result = 31 * result + (this.replyToEmailAddress != null ? this.replyToEmailAddress.hashCode() : 0);
                result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The message template to be used for the welcome message to new users.
     * <p>
     * See also <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization">Customizing User Invitation Messages</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * InviteMessageTemplateProperty inviteMessageTemplateProperty = InviteMessageTemplateProperty.builder()
     *         .emailMessage("emailMessage")
     *         .emailSubject("emailSubject")
     *         .smsMessage("smsMessage")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.InviteMessageTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(InviteMessageTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InviteMessageTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message template for email messages.
         * <p>
         * EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailMessage() {
            return null;
        }

        /**
         * The subject line for email messages.
         * <p>
         * EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailSubject() {
            return null;
        }

        /**
         * The message template for SMS messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSmsMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InviteMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InviteMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InviteMessageTemplateProperty> {
            java.lang.String emailMessage;
            java.lang.String emailSubject;
            java.lang.String smsMessage;

            /**
             * Sets the value of {@link InviteMessageTemplateProperty#getEmailMessage}
             * @param emailMessage The message template for email messages.
             *                     EmailMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessage(java.lang.String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            /**
             * Sets the value of {@link InviteMessageTemplateProperty#getEmailSubject}
             * @param emailSubject The subject line for email messages.
             *                     EmailSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailSubject(java.lang.String emailSubject) {
                this.emailSubject = emailSubject;
                return this;
            }

            /**
             * Sets the value of {@link InviteMessageTemplateProperty#getSmsMessage}
             * @param smsMessage The message template for SMS messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessage(java.lang.String smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InviteMessageTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InviteMessageTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InviteMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InviteMessageTemplateProperty {
            private final java.lang.String emailMessage;
            private final java.lang.String emailSubject;
            private final java.lang.String smsMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailMessage = software.amazon.jsii.Kernel.get(this, "emailMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailSubject = software.amazon.jsii.Kernel.get(this, "emailSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smsMessage = software.amazon.jsii.Kernel.get(this, "smsMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailMessage = builder.emailMessage;
                this.emailSubject = builder.emailSubject;
                this.smsMessage = builder.smsMessage;
            }

            @Override
            public final java.lang.String getEmailMessage() {
                return this.emailMessage;
            }

            @Override
            public final java.lang.String getEmailSubject() {
                return this.emailSubject;
            }

            @Override
            public final java.lang.String getSmsMessage() {
                return this.smsMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailMessage() != null) {
                    data.set("emailMessage", om.valueToTree(this.getEmailMessage()));
                }
                if (this.getEmailSubject() != null) {
                    data.set("emailSubject", om.valueToTree(this.getEmailSubject()));
                }
                if (this.getSmsMessage() != null) {
                    data.set("smsMessage", om.valueToTree(this.getSmsMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.InviteMessageTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InviteMessageTemplateProperty.Jsii$Proxy that = (InviteMessageTemplateProperty.Jsii$Proxy) o;

                if (this.emailMessage != null ? !this.emailMessage.equals(that.emailMessage) : that.emailMessage != null) return false;
                if (this.emailSubject != null ? !this.emailSubject.equals(that.emailSubject) : that.emailSubject != null) return false;
                return this.smsMessage != null ? this.smsMessage.equals(that.smsMessage) : that.smsMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailMessage != null ? this.emailMessage.hashCode() : 0;
                result = 31 * result + (this.emailSubject != null ? this.emailSubject.hashCode() : 0);
                result = 31 * result + (this.smsMessage != null ? this.smsMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for AWS Lambda triggers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * LambdaConfigProperty lambdaConfigProperty = LambdaConfigProperty.builder()
     *         .createAuthChallenge("createAuthChallenge")
     *         .customEmailSender(CustomEmailSenderProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .lambdaVersion("lambdaVersion")
     *                 .build())
     *         .customMessage("customMessage")
     *         .customSmsSender(CustomSMSSenderProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .lambdaVersion("lambdaVersion")
     *                 .build())
     *         .defineAuthChallenge("defineAuthChallenge")
     *         .kmsKeyId("kmsKeyId")
     *         .postAuthentication("postAuthentication")
     *         .postConfirmation("postConfirmation")
     *         .preAuthentication("preAuthentication")
     *         .preSignUp("preSignUp")
     *         .preTokenGeneration("preTokenGeneration")
     *         .userMigration("userMigration")
     *         .verifyAuthChallengeResponse("verifyAuthChallengeResponse")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.LambdaConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Creates an authentication challenge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreateAuthChallenge() {
            return null;
        }

        /**
         * A custom email sender AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomEmailSender() {
            return null;
        }

        /**
         * A custom Message AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomMessage() {
            return null;
        }

        /**
         * A custom SMS sender AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomSmsSender() {
            return null;
        }

        /**
         * Defines the authentication challenge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefineAuthChallenge() {
            return null;
        }

        /**
         * The Amazon Resource Name of a AWS Key Management Service ( AWS KMS ) key.
         * <p>
         * Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * A post-authentication AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostAuthentication() {
            return null;
        }

        /**
         * A post-confirmation AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostConfirmation() {
            return null;
        }

        /**
         * A pre-authentication AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreAuthentication() {
            return null;
        }

        /**
         * A pre-registration AWS Lambda trigger.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreSignUp() {
            return null;
        }

        /**
         * A Lambda trigger that is invoked before token generation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreTokenGeneration() {
            return null;
        }

        /**
         * The user migration Lambda config type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserMigration() {
            return null;
        }

        /**
         * Verifies the authentication challenge response.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVerifyAuthChallengeResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaConfigProperty> {
            java.lang.String createAuthChallenge;
            java.lang.Object customEmailSender;
            java.lang.String customMessage;
            java.lang.Object customSmsSender;
            java.lang.String defineAuthChallenge;
            java.lang.String kmsKeyId;
            java.lang.String postAuthentication;
            java.lang.String postConfirmation;
            java.lang.String preAuthentication;
            java.lang.String preSignUp;
            java.lang.String preTokenGeneration;
            java.lang.String userMigration;
            java.lang.String verifyAuthChallengeResponse;

            /**
             * Sets the value of {@link LambdaConfigProperty#getCreateAuthChallenge}
             * @param createAuthChallenge Creates an authentication challenge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAuthChallenge(java.lang.String createAuthChallenge) {
                this.createAuthChallenge = createAuthChallenge;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getCustomEmailSender}
             * @param customEmailSender A custom email sender AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEmailSender(software.amazon.awscdk.services.cognito.CfnUserPool.CustomEmailSenderProperty customEmailSender) {
                this.customEmailSender = customEmailSender;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getCustomEmailSender}
             * @param customEmailSender A custom email sender AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEmailSender(software.amazon.awscdk.core.IResolvable customEmailSender) {
                this.customEmailSender = customEmailSender;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getCustomMessage}
             * @param customMessage A custom Message AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMessage(java.lang.String customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getCustomSmsSender}
             * @param customSmsSender A custom SMS sender AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSmsSender(software.amazon.awscdk.services.cognito.CfnUserPool.CustomSMSSenderProperty customSmsSender) {
                this.customSmsSender = customSmsSender;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getCustomSmsSender}
             * @param customSmsSender A custom SMS sender AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSmsSender(software.amazon.awscdk.core.IResolvable customSmsSender) {
                this.customSmsSender = customSmsSender;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getDefineAuthChallenge}
             * @param defineAuthChallenge Defines the authentication challenge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defineAuthChallenge(java.lang.String defineAuthChallenge) {
                this.defineAuthChallenge = defineAuthChallenge;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getKmsKeyId}
             * @param kmsKeyId The Amazon Resource Name of a AWS Key Management Service ( AWS KMS ) key.
             *                 Amazon Cognito uses the key to encrypt codes and temporary passwords sent to <code>CustomEmailSender</code> and <code>CustomSMSSender</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getPostAuthentication}
             * @param postAuthentication A post-authentication AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postAuthentication(java.lang.String postAuthentication) {
                this.postAuthentication = postAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getPostConfirmation}
             * @param postConfirmation A post-confirmation AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postConfirmation(java.lang.String postConfirmation) {
                this.postConfirmation = postConfirmation;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getPreAuthentication}
             * @param preAuthentication A pre-authentication AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preAuthentication(java.lang.String preAuthentication) {
                this.preAuthentication = preAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getPreSignUp}
             * @param preSignUp A pre-registration AWS Lambda trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preSignUp(java.lang.String preSignUp) {
                this.preSignUp = preSignUp;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getPreTokenGeneration}
             * @param preTokenGeneration A Lambda trigger that is invoked before token generation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preTokenGeneration(java.lang.String preTokenGeneration) {
                this.preTokenGeneration = preTokenGeneration;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getUserMigration}
             * @param userMigration The user migration Lambda config type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userMigration(java.lang.String userMigration) {
                this.userMigration = userMigration;
                return this;
            }

            /**
             * Sets the value of {@link LambdaConfigProperty#getVerifyAuthChallengeResponse}
             * @param verifyAuthChallengeResponse Verifies the authentication challenge response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verifyAuthChallengeResponse(java.lang.String verifyAuthChallengeResponse) {
                this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConfigProperty {
            private final java.lang.String createAuthChallenge;
            private final java.lang.Object customEmailSender;
            private final java.lang.String customMessage;
            private final java.lang.Object customSmsSender;
            private final java.lang.String defineAuthChallenge;
            private final java.lang.String kmsKeyId;
            private final java.lang.String postAuthentication;
            private final java.lang.String postConfirmation;
            private final java.lang.String preAuthentication;
            private final java.lang.String preSignUp;
            private final java.lang.String preTokenGeneration;
            private final java.lang.String userMigration;
            private final java.lang.String verifyAuthChallengeResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.createAuthChallenge = software.amazon.jsii.Kernel.get(this, "createAuthChallenge", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customEmailSender = software.amazon.jsii.Kernel.get(this, "customEmailSender", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customMessage = software.amazon.jsii.Kernel.get(this, "customMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customSmsSender = software.amazon.jsii.Kernel.get(this, "customSmsSender", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defineAuthChallenge = software.amazon.jsii.Kernel.get(this, "defineAuthChallenge", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.postAuthentication = software.amazon.jsii.Kernel.get(this, "postAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.postConfirmation = software.amazon.jsii.Kernel.get(this, "postConfirmation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preAuthentication = software.amazon.jsii.Kernel.get(this, "preAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preSignUp = software.amazon.jsii.Kernel.get(this, "preSignUp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preTokenGeneration = software.amazon.jsii.Kernel.get(this, "preTokenGeneration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userMigration = software.amazon.jsii.Kernel.get(this, "userMigration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.verifyAuthChallengeResponse = software.amazon.jsii.Kernel.get(this, "verifyAuthChallengeResponse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.createAuthChallenge = builder.createAuthChallenge;
                this.customEmailSender = builder.customEmailSender;
                this.customMessage = builder.customMessage;
                this.customSmsSender = builder.customSmsSender;
                this.defineAuthChallenge = builder.defineAuthChallenge;
                this.kmsKeyId = builder.kmsKeyId;
                this.postAuthentication = builder.postAuthentication;
                this.postConfirmation = builder.postConfirmation;
                this.preAuthentication = builder.preAuthentication;
                this.preSignUp = builder.preSignUp;
                this.preTokenGeneration = builder.preTokenGeneration;
                this.userMigration = builder.userMigration;
                this.verifyAuthChallengeResponse = builder.verifyAuthChallengeResponse;
            }

            @Override
            public final java.lang.String getCreateAuthChallenge() {
                return this.createAuthChallenge;
            }

            @Override
            public final java.lang.Object getCustomEmailSender() {
                return this.customEmailSender;
            }

            @Override
            public final java.lang.String getCustomMessage() {
                return this.customMessage;
            }

            @Override
            public final java.lang.Object getCustomSmsSender() {
                return this.customSmsSender;
            }

            @Override
            public final java.lang.String getDefineAuthChallenge() {
                return this.defineAuthChallenge;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getPostAuthentication() {
                return this.postAuthentication;
            }

            @Override
            public final java.lang.String getPostConfirmation() {
                return this.postConfirmation;
            }

            @Override
            public final java.lang.String getPreAuthentication() {
                return this.preAuthentication;
            }

            @Override
            public final java.lang.String getPreSignUp() {
                return this.preSignUp;
            }

            @Override
            public final java.lang.String getPreTokenGeneration() {
                return this.preTokenGeneration;
            }

            @Override
            public final java.lang.String getUserMigration() {
                return this.userMigration;
            }

            @Override
            public final java.lang.String getVerifyAuthChallengeResponse() {
                return this.verifyAuthChallengeResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCreateAuthChallenge() != null) {
                    data.set("createAuthChallenge", om.valueToTree(this.getCreateAuthChallenge()));
                }
                if (this.getCustomEmailSender() != null) {
                    data.set("customEmailSender", om.valueToTree(this.getCustomEmailSender()));
                }
                if (this.getCustomMessage() != null) {
                    data.set("customMessage", om.valueToTree(this.getCustomMessage()));
                }
                if (this.getCustomSmsSender() != null) {
                    data.set("customSmsSender", om.valueToTree(this.getCustomSmsSender()));
                }
                if (this.getDefineAuthChallenge() != null) {
                    data.set("defineAuthChallenge", om.valueToTree(this.getDefineAuthChallenge()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getPostAuthentication() != null) {
                    data.set("postAuthentication", om.valueToTree(this.getPostAuthentication()));
                }
                if (this.getPostConfirmation() != null) {
                    data.set("postConfirmation", om.valueToTree(this.getPostConfirmation()));
                }
                if (this.getPreAuthentication() != null) {
                    data.set("preAuthentication", om.valueToTree(this.getPreAuthentication()));
                }
                if (this.getPreSignUp() != null) {
                    data.set("preSignUp", om.valueToTree(this.getPreSignUp()));
                }
                if (this.getPreTokenGeneration() != null) {
                    data.set("preTokenGeneration", om.valueToTree(this.getPreTokenGeneration()));
                }
                if (this.getUserMigration() != null) {
                    data.set("userMigration", om.valueToTree(this.getUserMigration()));
                }
                if (this.getVerifyAuthChallengeResponse() != null) {
                    data.set("verifyAuthChallengeResponse", om.valueToTree(this.getVerifyAuthChallengeResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.LambdaConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConfigProperty.Jsii$Proxy that = (LambdaConfigProperty.Jsii$Proxy) o;

                if (this.createAuthChallenge != null ? !this.createAuthChallenge.equals(that.createAuthChallenge) : that.createAuthChallenge != null) return false;
                if (this.customEmailSender != null ? !this.customEmailSender.equals(that.customEmailSender) : that.customEmailSender != null) return false;
                if (this.customMessage != null ? !this.customMessage.equals(that.customMessage) : that.customMessage != null) return false;
                if (this.customSmsSender != null ? !this.customSmsSender.equals(that.customSmsSender) : that.customSmsSender != null) return false;
                if (this.defineAuthChallenge != null ? !this.defineAuthChallenge.equals(that.defineAuthChallenge) : that.defineAuthChallenge != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.postAuthentication != null ? !this.postAuthentication.equals(that.postAuthentication) : that.postAuthentication != null) return false;
                if (this.postConfirmation != null ? !this.postConfirmation.equals(that.postConfirmation) : that.postConfirmation != null) return false;
                if (this.preAuthentication != null ? !this.preAuthentication.equals(that.preAuthentication) : that.preAuthentication != null) return false;
                if (this.preSignUp != null ? !this.preSignUp.equals(that.preSignUp) : that.preSignUp != null) return false;
                if (this.preTokenGeneration != null ? !this.preTokenGeneration.equals(that.preTokenGeneration) : that.preTokenGeneration != null) return false;
                if (this.userMigration != null ? !this.userMigration.equals(that.userMigration) : that.userMigration != null) return false;
                return this.verifyAuthChallengeResponse != null ? this.verifyAuthChallengeResponse.equals(that.verifyAuthChallengeResponse) : that.verifyAuthChallengeResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.createAuthChallenge != null ? this.createAuthChallenge.hashCode() : 0;
                result = 31 * result + (this.customEmailSender != null ? this.customEmailSender.hashCode() : 0);
                result = 31 * result + (this.customMessage != null ? this.customMessage.hashCode() : 0);
                result = 31 * result + (this.customSmsSender != null ? this.customSmsSender.hashCode() : 0);
                result = 31 * result + (this.defineAuthChallenge != null ? this.defineAuthChallenge.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.postAuthentication != null ? this.postAuthentication.hashCode() : 0);
                result = 31 * result + (this.postConfirmation != null ? this.postConfirmation.hashCode() : 0);
                result = 31 * result + (this.preAuthentication != null ? this.preAuthentication.hashCode() : 0);
                result = 31 * result + (this.preSignUp != null ? this.preSignUp.hashCode() : 0);
                result = 31 * result + (this.preTokenGeneration != null ? this.preTokenGeneration.hashCode() : 0);
                result = 31 * result + (this.userMigration != null ? this.userMigration.hashCode() : 0);
                result = 31 * result + (this.verifyAuthChallengeResponse != null ? this.verifyAuthChallengeResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum values of an attribute that is of the number data type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * NumberAttributeConstraintsProperty numberAttributeConstraintsProperty = NumberAttributeConstraintsProperty.builder()
     *         .maxValue("maxValue")
     *         .minValue("minValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.NumberAttributeConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(NumberAttributeConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumberAttributeConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum value of an attribute that is of the number data type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxValue() {
            return null;
        }

        /**
         * The minimum value of an attribute that is of the number data type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NumberAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumberAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumberAttributeConstraintsProperty> {
            java.lang.String maxValue;
            java.lang.String minValue;

            /**
             * Sets the value of {@link NumberAttributeConstraintsProperty#getMaxValue}
             * @param maxValue The maximum value of an attribute that is of the number data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.String maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link NumberAttributeConstraintsProperty#getMinValue}
             * @param minValue The minimum value of an attribute that is of the number data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.String minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumberAttributeConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumberAttributeConstraintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumberAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberAttributeConstraintsProperty {
            private final java.lang.String maxValue;
            private final java.lang.String minValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = builder.maxValue;
                this.minValue = builder.minValue;
            }

            @Override
            public final java.lang.String getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.String getMinValue() {
                return this.minValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxValue() != null) {
                    data.set("maxValue", om.valueToTree(this.getMaxValue()));
                }
                if (this.getMinValue() != null) {
                    data.set("minValue", om.valueToTree(this.getMinValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.NumberAttributeConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumberAttributeConstraintsProperty.Jsii$Proxy that = (NumberAttributeConstraintsProperty.Jsii$Proxy) o;

                if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) return false;
                return this.minValue != null ? this.minValue.equals(that.minValue) : that.minValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue != null ? this.maxValue.hashCode() : 0;
                result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The password policy type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * PasswordPolicyProperty passwordPolicyProperty = PasswordPolicyProperty.builder()
     *         .minimumLength(123)
     *         .requireLowercase(false)
     *         .requireNumbers(false)
     *         .requireSymbols(false)
     *         .requireUppercase(false)
     *         .temporaryPasswordValidityDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.PasswordPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(PasswordPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PasswordPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum length of the password in the policy that you have set.
         * <p>
         * This value can't be less than 6.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumLength() {
            return null;
        }

        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireLowercase() {
            return null;
        }

        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one number in their password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireNumbers() {
            return null;
        }

        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireSymbols() {
            return null;
        }

        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireUppercase() {
            return null;
        }

        /**
         * The number of days a temporary password is valid in the password policy.
         * <p>
         * If the user doesn't sign in during this time, an administrator must reset their password.
         * <p>
         * <blockquote>
         * <p>
         * When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value for the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTemporaryPasswordValidityDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PasswordPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PasswordPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PasswordPolicyProperty> {
            java.lang.Number minimumLength;
            java.lang.Object requireLowercase;
            java.lang.Object requireNumbers;
            java.lang.Object requireSymbols;
            java.lang.Object requireUppercase;
            java.lang.Number temporaryPasswordValidityDays;

            /**
             * Sets the value of {@link PasswordPolicyProperty#getMinimumLength}
             * @param minimumLength The minimum length of the password in the policy that you have set.
             *                      This value can't be less than 6.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumLength(java.lang.Number minimumLength) {
                this.minimumLength = minimumLength;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireLowercase}
             * @param requireLowercase In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireLowercase(java.lang.Boolean requireLowercase) {
                this.requireLowercase = requireLowercase;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireLowercase}
             * @param requireLowercase In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireLowercase(software.amazon.awscdk.core.IResolvable requireLowercase) {
                this.requireLowercase = requireLowercase;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireNumbers}
             * @param requireNumbers In the password policy that you have set, refers to whether you have required users to use at least one number in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireNumbers(java.lang.Boolean requireNumbers) {
                this.requireNumbers = requireNumbers;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireNumbers}
             * @param requireNumbers In the password policy that you have set, refers to whether you have required users to use at least one number in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireNumbers(software.amazon.awscdk.core.IResolvable requireNumbers) {
                this.requireNumbers = requireNumbers;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireSymbols}
             * @param requireSymbols In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireSymbols(java.lang.Boolean requireSymbols) {
                this.requireSymbols = requireSymbols;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireSymbols}
             * @param requireSymbols In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireSymbols(software.amazon.awscdk.core.IResolvable requireSymbols) {
                this.requireSymbols = requireSymbols;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireUppercase}
             * @param requireUppercase In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireUppercase(java.lang.Boolean requireUppercase) {
                this.requireUppercase = requireUppercase;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getRequireUppercase}
             * @param requireUppercase In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireUppercase(software.amazon.awscdk.core.IResolvable requireUppercase) {
                this.requireUppercase = requireUppercase;
                return this;
            }

            /**
             * Sets the value of {@link PasswordPolicyProperty#getTemporaryPasswordValidityDays}
             * @param temporaryPasswordValidityDays The number of days a temporary password is valid in the password policy.
             *                                      If the user doesn't sign in during this time, an administrator must reset their password.
             *                                      <p>
             *                                      <blockquote>
             *                                      <p>
             *                                      When you set <code>TemporaryPasswordValidityDays</code> for a user pool, you can no longer set a value for the legacy <code>UnusedAccountValidityDays</code> parameter in that user pool.
             *                                      <p>
             *                                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temporaryPasswordValidityDays(java.lang.Number temporaryPasswordValidityDays) {
                this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PasswordPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PasswordPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PasswordPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PasswordPolicyProperty {
            private final java.lang.Number minimumLength;
            private final java.lang.Object requireLowercase;
            private final java.lang.Object requireNumbers;
            private final java.lang.Object requireSymbols;
            private final java.lang.Object requireUppercase;
            private final java.lang.Number temporaryPasswordValidityDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumLength = software.amazon.jsii.Kernel.get(this, "minimumLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireLowercase = software.amazon.jsii.Kernel.get(this, "requireLowercase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireNumbers = software.amazon.jsii.Kernel.get(this, "requireNumbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireSymbols = software.amazon.jsii.Kernel.get(this, "requireSymbols", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requireUppercase = software.amazon.jsii.Kernel.get(this, "requireUppercase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.temporaryPasswordValidityDays = software.amazon.jsii.Kernel.get(this, "temporaryPasswordValidityDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumLength = builder.minimumLength;
                this.requireLowercase = builder.requireLowercase;
                this.requireNumbers = builder.requireNumbers;
                this.requireSymbols = builder.requireSymbols;
                this.requireUppercase = builder.requireUppercase;
                this.temporaryPasswordValidityDays = builder.temporaryPasswordValidityDays;
            }

            @Override
            public final java.lang.Number getMinimumLength() {
                return this.minimumLength;
            }

            @Override
            public final java.lang.Object getRequireLowercase() {
                return this.requireLowercase;
            }

            @Override
            public final java.lang.Object getRequireNumbers() {
                return this.requireNumbers;
            }

            @Override
            public final java.lang.Object getRequireSymbols() {
                return this.requireSymbols;
            }

            @Override
            public final java.lang.Object getRequireUppercase() {
                return this.requireUppercase;
            }

            @Override
            public final java.lang.Number getTemporaryPasswordValidityDays() {
                return this.temporaryPasswordValidityDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMinimumLength() != null) {
                    data.set("minimumLength", om.valueToTree(this.getMinimumLength()));
                }
                if (this.getRequireLowercase() != null) {
                    data.set("requireLowercase", om.valueToTree(this.getRequireLowercase()));
                }
                if (this.getRequireNumbers() != null) {
                    data.set("requireNumbers", om.valueToTree(this.getRequireNumbers()));
                }
                if (this.getRequireSymbols() != null) {
                    data.set("requireSymbols", om.valueToTree(this.getRequireSymbols()));
                }
                if (this.getRequireUppercase() != null) {
                    data.set("requireUppercase", om.valueToTree(this.getRequireUppercase()));
                }
                if (this.getTemporaryPasswordValidityDays() != null) {
                    data.set("temporaryPasswordValidityDays", om.valueToTree(this.getTemporaryPasswordValidityDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.PasswordPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PasswordPolicyProperty.Jsii$Proxy that = (PasswordPolicyProperty.Jsii$Proxy) o;

                if (this.minimumLength != null ? !this.minimumLength.equals(that.minimumLength) : that.minimumLength != null) return false;
                if (this.requireLowercase != null ? !this.requireLowercase.equals(that.requireLowercase) : that.requireLowercase != null) return false;
                if (this.requireNumbers != null ? !this.requireNumbers.equals(that.requireNumbers) : that.requireNumbers != null) return false;
                if (this.requireSymbols != null ? !this.requireSymbols.equals(that.requireSymbols) : that.requireSymbols != null) return false;
                if (this.requireUppercase != null ? !this.requireUppercase.equals(that.requireUppercase) : that.requireUppercase != null) return false;
                return this.temporaryPasswordValidityDays != null ? this.temporaryPasswordValidityDays.equals(that.temporaryPasswordValidityDays) : that.temporaryPasswordValidityDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.minimumLength != null ? this.minimumLength.hashCode() : 0;
                result = 31 * result + (this.requireLowercase != null ? this.requireLowercase.hashCode() : 0);
                result = 31 * result + (this.requireNumbers != null ? this.requireNumbers.hashCode() : 0);
                result = 31 * result + (this.requireSymbols != null ? this.requireSymbols.hashCode() : 0);
                result = 31 * result + (this.requireUppercase != null ? this.requireUppercase.hashCode() : 0);
                result = 31 * result + (this.temporaryPasswordValidityDays != null ? this.temporaryPasswordValidityDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The policy associated with a user pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * PoliciesProperty policiesProperty = PoliciesProperty.builder()
     *         .passwordPolicy(PasswordPolicyProperty.builder()
     *                 .minimumLength(123)
     *                 .requireLowercase(false)
     *                 .requireNumbers(false)
     *                 .requireSymbols(false)
     *                 .requireUppercase(false)
     *                 .temporaryPasswordValidityDays(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.PoliciesProperty")
    @software.amazon.jsii.Jsii.Proxy(PoliciesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PoliciesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPasswordPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PoliciesProperty> {
            java.lang.Object passwordPolicy;

            /**
             * Sets the value of {@link PoliciesProperty#getPasswordPolicy}
             * @param passwordPolicy The password policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordPolicy(software.amazon.awscdk.services.cognito.CfnUserPool.PasswordPolicyProperty passwordPolicy) {
                this.passwordPolicy = passwordPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PoliciesProperty#getPasswordPolicy}
             * @param passwordPolicy The password policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordPolicy(software.amazon.awscdk.core.IResolvable passwordPolicy) {
                this.passwordPolicy = passwordPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PoliciesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PoliciesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PoliciesProperty {
            private final java.lang.Object passwordPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.passwordPolicy = software.amazon.jsii.Kernel.get(this, "passwordPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.passwordPolicy = builder.passwordPolicy;
            }

            @Override
            public final java.lang.Object getPasswordPolicy() {
                return this.passwordPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPasswordPolicy() != null) {
                    data.set("passwordPolicy", om.valueToTree(this.getPasswordPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.PoliciesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PoliciesProperty.Jsii$Proxy that = (PoliciesProperty.Jsii$Proxy) o;

                return this.passwordPolicy != null ? this.passwordPolicy.equals(that.passwordPolicy) : that.passwordPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.passwordPolicy != null ? this.passwordPolicy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A map containing a priority as a key, and recovery method name as a value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * RecoveryOptionProperty recoveryOptionProperty = RecoveryOptionProperty.builder()
     *         .name("name")
     *         .priority(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.RecoveryOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(RecoveryOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecoveryOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the recovery method for a user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A positive integer specifying priority of a method with 1 being the highest priority.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecoveryOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecoveryOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecoveryOptionProperty> {
            java.lang.String name;
            java.lang.Number priority;

            /**
             * Sets the value of {@link RecoveryOptionProperty#getName}
             * @param name Specifies the recovery method for a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecoveryOptionProperty#getPriority}
             * @param priority A positive integer specifying priority of a method with 1 being the highest priority.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecoveryOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecoveryOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecoveryOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecoveryOptionProperty {
            private final java.lang.String name;
            private final java.lang.Number priority;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.priority = builder.priority;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.RecoveryOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecoveryOptionProperty.Jsii$Proxy that = (RecoveryOptionProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the schema attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * SchemaAttributeProperty schemaAttributeProperty = SchemaAttributeProperty.builder()
     *         .attributeDataType("attributeDataType")
     *         .developerOnlyAttribute(false)
     *         .mutable(false)
     *         .name("name")
     *         .numberAttributeConstraints(NumberAttributeConstraintsProperty.builder()
     *                 .maxValue("maxValue")
     *                 .minValue("minValue")
     *                 .build())
     *         .required(false)
     *         .stringAttributeConstraints(StringAttributeConstraintsProperty.builder()
     *                 .maxLength("maxLength")
     *                 .minLength("minLength")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.SchemaAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The attribute data type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeDataType() {
            return null;
        }

        /**
         * > We recommend that you use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute` .
         * <p>
         * Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users will not be able to modify this attribute using their access token.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeveloperOnlyAttribute() {
            return null;
        }

        /**
         * Specifies whether the value of the attribute can be changed.
         * <p>
         * For any user pool attribute that is mapped to an IdP attribute, you must set this parameter to <code>true</code> . Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMutable() {
            return null;
        }

        /**
         * A schema attribute of the name type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Specifies the constraints for an attribute of the number type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumberAttributeConstraints() {
            return null;
        }

        /**
         * Specifies whether a user pool attribute is required.
         * <p>
         * If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequired() {
            return null;
        }

        /**
         * Specifies the constraints for an attribute of the string type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringAttributeConstraints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaAttributeProperty> {
            java.lang.String attributeDataType;
            java.lang.Object developerOnlyAttribute;
            java.lang.Object mutable;
            java.lang.String name;
            java.lang.Object numberAttributeConstraints;
            java.lang.Object required;
            java.lang.Object stringAttributeConstraints;

            /**
             * Sets the value of {@link SchemaAttributeProperty#getAttributeDataType}
             * @param attributeDataType The attribute data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeDataType(java.lang.String attributeDataType) {
                this.attributeDataType = attributeDataType;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getDeveloperOnlyAttribute}
             * @param developerOnlyAttribute > We recommend that you use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute` .
             *                               Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users will not be able to modify this attribute using their access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder developerOnlyAttribute(java.lang.Boolean developerOnlyAttribute) {
                this.developerOnlyAttribute = developerOnlyAttribute;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getDeveloperOnlyAttribute}
             * @param developerOnlyAttribute > We recommend that you use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute` .
             *                               Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users will not be able to modify this attribute using their access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder developerOnlyAttribute(software.amazon.awscdk.core.IResolvable developerOnlyAttribute) {
                this.developerOnlyAttribute = developerOnlyAttribute;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getMutable}
             * @param mutable Specifies whether the value of the attribute can be changed.
             *                For any user pool attribute that is mapped to an IdP attribute, you must set this parameter to <code>true</code> . Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutable(java.lang.Boolean mutable) {
                this.mutable = mutable;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getMutable}
             * @param mutable Specifies whether the value of the attribute can be changed.
             *                For any user pool attribute that is mapped to an IdP attribute, you must set this parameter to <code>true</code> . Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your User Pool</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mutable(software.amazon.awscdk.core.IResolvable mutable) {
                this.mutable = mutable;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getName}
             * @param name A schema attribute of the name type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getNumberAttributeConstraints}
             * @param numberAttributeConstraints Specifies the constraints for an attribute of the number type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberAttributeConstraints(software.amazon.awscdk.services.cognito.CfnUserPool.NumberAttributeConstraintsProperty numberAttributeConstraints) {
                this.numberAttributeConstraints = numberAttributeConstraints;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getNumberAttributeConstraints}
             * @param numberAttributeConstraints Specifies the constraints for an attribute of the number type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberAttributeConstraints(software.amazon.awscdk.core.IResolvable numberAttributeConstraints) {
                this.numberAttributeConstraints = numberAttributeConstraints;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getRequired}
             * @param required Specifies whether a user pool attribute is required.
             *                 If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getRequired}
             * @param required Specifies whether a user pool attribute is required.
             *                 If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.core.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getStringAttributeConstraints}
             * @param stringAttributeConstraints Specifies the constraints for an attribute of the string type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringAttributeConstraints(software.amazon.awscdk.services.cognito.CfnUserPool.StringAttributeConstraintsProperty stringAttributeConstraints) {
                this.stringAttributeConstraints = stringAttributeConstraints;
                return this;
            }

            /**
             * Sets the value of {@link SchemaAttributeProperty#getStringAttributeConstraints}
             * @param stringAttributeConstraints Specifies the constraints for an attribute of the string type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringAttributeConstraints(software.amazon.awscdk.core.IResolvable stringAttributeConstraints) {
                this.stringAttributeConstraints = stringAttributeConstraints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaAttributeProperty {
            private final java.lang.String attributeDataType;
            private final java.lang.Object developerOnlyAttribute;
            private final java.lang.Object mutable;
            private final java.lang.String name;
            private final java.lang.Object numberAttributeConstraints;
            private final java.lang.Object required;
            private final java.lang.Object stringAttributeConstraints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeDataType = software.amazon.jsii.Kernel.get(this, "attributeDataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.developerOnlyAttribute = software.amazon.jsii.Kernel.get(this, "developerOnlyAttribute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberAttributeConstraints = software.amazon.jsii.Kernel.get(this, "numberAttributeConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringAttributeConstraints = software.amazon.jsii.Kernel.get(this, "stringAttributeConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeDataType = builder.attributeDataType;
                this.developerOnlyAttribute = builder.developerOnlyAttribute;
                this.mutable = builder.mutable;
                this.name = builder.name;
                this.numberAttributeConstraints = builder.numberAttributeConstraints;
                this.required = builder.required;
                this.stringAttributeConstraints = builder.stringAttributeConstraints;
            }

            @Override
            public final java.lang.String getAttributeDataType() {
                return this.attributeDataType;
            }

            @Override
            public final java.lang.Object getDeveloperOnlyAttribute() {
                return this.developerOnlyAttribute;
            }

            @Override
            public final java.lang.Object getMutable() {
                return this.mutable;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getNumberAttributeConstraints() {
                return this.numberAttributeConstraints;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            public final java.lang.Object getStringAttributeConstraints() {
                return this.stringAttributeConstraints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributeDataType() != null) {
                    data.set("attributeDataType", om.valueToTree(this.getAttributeDataType()));
                }
                if (this.getDeveloperOnlyAttribute() != null) {
                    data.set("developerOnlyAttribute", om.valueToTree(this.getDeveloperOnlyAttribute()));
                }
                if (this.getMutable() != null) {
                    data.set("mutable", om.valueToTree(this.getMutable()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getNumberAttributeConstraints() != null) {
                    data.set("numberAttributeConstraints", om.valueToTree(this.getNumberAttributeConstraints()));
                }
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }
                if (this.getStringAttributeConstraints() != null) {
                    data.set("stringAttributeConstraints", om.valueToTree(this.getStringAttributeConstraints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.SchemaAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaAttributeProperty.Jsii$Proxy that = (SchemaAttributeProperty.Jsii$Proxy) o;

                if (this.attributeDataType != null ? !this.attributeDataType.equals(that.attributeDataType) : that.attributeDataType != null) return false;
                if (this.developerOnlyAttribute != null ? !this.developerOnlyAttribute.equals(that.developerOnlyAttribute) : that.developerOnlyAttribute != null) return false;
                if (this.mutable != null ? !this.mutable.equals(that.mutable) : that.mutable != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.numberAttributeConstraints != null ? !this.numberAttributeConstraints.equals(that.numberAttributeConstraints) : that.numberAttributeConstraints != null) return false;
                if (this.required != null ? !this.required.equals(that.required) : that.required != null) return false;
                return this.stringAttributeConstraints != null ? this.stringAttributeConstraints.equals(that.stringAttributeConstraints) : that.stringAttributeConstraints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeDataType != null ? this.attributeDataType.hashCode() : 0;
                result = 31 * result + (this.developerOnlyAttribute != null ? this.developerOnlyAttribute.hashCode() : 0);
                result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.numberAttributeConstraints != null ? this.numberAttributeConstraints.hashCode() : 0);
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                result = 31 * result + (this.stringAttributeConstraints != null ? this.stringAttributeConstraints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SMS configuration type that includes the settings the Cognito User Pool needs to call for the Amazon SNS service to send an SMS message from your AWS account .
     * <p>
     * The Cognito User Pool makes the request to the Amazon SNS Service by using an IAM role that you provide for your AWS account .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * SmsConfigurationProperty smsConfigurationProperty = SmsConfigurationProperty.builder()
     *         .externalId("externalId")
     *         .snsCallerArn("snsCallerArn")
     *         .snsRegion("snsRegion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.SmsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The external ID is a value.
         * <p>
         * We recommend you use <code>ExternalId</code> to add security to your IAM role, which is used to call Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code> , the Cognito User Pool uses it when attempting to assume your IAM role. You can also set your roles trust policy to require the <code>ExternalID</code> . If you use the Cognito Management Console to create a role for SMS MFA, Cognito creates a role with the required permissions and a trust policy that uses <code>ExternalId</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS caller.
         * <p>
         * This is the ARN of the IAM role in your AWS account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnsCallerArn() {
            return null;
        }

        /**
         * The AWS Region to use with Amazon SNS integration.
         * <p>
         * You can choose the same Region as your user pool, or a supported <em>Legacy Amazon SNS alternate Region</em> .
         * <p>
         * Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnsRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsConfigurationProperty> {
            java.lang.String externalId;
            java.lang.String snsCallerArn;
            java.lang.String snsRegion;

            /**
             * Sets the value of {@link SmsConfigurationProperty#getExternalId}
             * @param externalId The external ID is a value.
             *                   We recommend you use <code>ExternalId</code> to add security to your IAM role, which is used to call Amazon SNS to send SMS messages for your user pool. If you provide an <code>ExternalId</code> , the Cognito User Pool uses it when attempting to assume your IAM role. You can also set your roles trust policy to require the <code>ExternalID</code> . If you use the Cognito Management Console to create a role for SMS MFA, Cognito creates a role with the required permissions and a trust policy that uses <code>ExternalId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link SmsConfigurationProperty#getSnsCallerArn}
             * @param snsCallerArn The Amazon Resource Name (ARN) of the Amazon SNS caller.
             *                     This is the ARN of the IAM role in your AWS account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html">spending limit</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsCallerArn(java.lang.String snsCallerArn) {
                this.snsCallerArn = snsCallerArn;
                return this;
            }

            /**
             * Sets the value of {@link SmsConfigurationProperty#getSnsRegion}
             * @param snsRegion The AWS Region to use with Amazon SNS integration.
             *                  You can choose the same Region as your user pool, or a supported <em>Legacy Amazon SNS alternate Region</em> .
             *                  <p>
             *                  Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings for Amazon Cognito user pools</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsRegion(java.lang.String snsRegion) {
                this.snsRegion = snsRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsConfigurationProperty {
            private final java.lang.String externalId;
            private final java.lang.String snsCallerArn;
            private final java.lang.String snsRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snsCallerArn = software.amazon.jsii.Kernel.get(this, "snsCallerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snsRegion = software.amazon.jsii.Kernel.get(this, "snsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.externalId = builder.externalId;
                this.snsCallerArn = builder.snsCallerArn;
                this.snsRegion = builder.snsRegion;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getSnsCallerArn() {
                return this.snsCallerArn;
            }

            @Override
            public final java.lang.String getSnsRegion() {
                return this.snsRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getSnsCallerArn() != null) {
                    data.set("snsCallerArn", om.valueToTree(this.getSnsCallerArn()));
                }
                if (this.getSnsRegion() != null) {
                    data.set("snsRegion", om.valueToTree(this.getSnsRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.SmsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsConfigurationProperty.Jsii$Proxy that = (SmsConfigurationProperty.Jsii$Proxy) o;

                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.snsCallerArn != null ? !this.snsCallerArn.equals(that.snsCallerArn) : that.snsCallerArn != null) return false;
                return this.snsRegion != null ? this.snsRegion.equals(that.snsRegion) : that.snsRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.externalId != null ? this.externalId.hashCode() : 0;
                result = 31 * result + (this.snsCallerArn != null ? this.snsCallerArn.hashCode() : 0);
                result = 31 * result + (this.snsRegion != null ? this.snsRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `StringAttributeConstraints` property type defines the string attribute constraints of an Amazon Cognito user pool.
     * <p>
     * <code>StringAttributeConstraints</code> is a subproperty of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-schemaattribute.html">SchemaAttribute</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * StringAttributeConstraintsProperty stringAttributeConstraintsProperty = StringAttributeConstraintsProperty.builder()
     *         .maxLength("maxLength")
     *         .minLength("minLength")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.StringAttributeConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(StringAttributeConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringAttributeConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum length.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxLength() {
            return null;
        }

        /**
         * The minimum length.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinLength() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StringAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringAttributeConstraintsProperty> {
            java.lang.String maxLength;
            java.lang.String minLength;

            /**
             * Sets the value of {@link StringAttributeConstraintsProperty#getMaxLength}
             * @param maxLength The maximum length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLength(java.lang.String maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            /**
             * Sets the value of {@link StringAttributeConstraintsProperty#getMinLength}
             * @param minLength The minimum length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minLength(java.lang.String minLength) {
                this.minLength = minLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringAttributeConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringAttributeConstraintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringAttributeConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringAttributeConstraintsProperty {
            private final java.lang.String maxLength;
            private final java.lang.String minLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxLength = software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minLength = software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxLength = builder.maxLength;
                this.minLength = builder.minLength;
            }

            @Override
            public final java.lang.String getMaxLength() {
                return this.maxLength;
            }

            @Override
            public final java.lang.String getMinLength() {
                return this.minLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxLength() != null) {
                    data.set("maxLength", om.valueToTree(this.getMaxLength()));
                }
                if (this.getMinLength() != null) {
                    data.set("minLength", om.valueToTree(this.getMinLength()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.StringAttributeConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringAttributeConstraintsProperty.Jsii$Proxy that = (StringAttributeConstraintsProperty.Jsii$Proxy) o;

                if (this.maxLength != null ? !this.maxLength.equals(that.maxLength) : that.maxLength != null) return false;
                return this.minLength != null ? this.minLength.equals(that.minLength) : that.minLength == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxLength != null ? this.maxLength.hashCode() : 0;
                result = 31 * result + (this.minLength != null ? this.minLength.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for updates to user attributes.
     * <p>
     * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
     * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
     * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * UserAttributeUpdateSettingsProperty userAttributeUpdateSettingsProperty = UserAttributeUpdateSettingsProperty.builder()
     *         .attributesRequireVerificationBeforeUpdate(List.of("attributesRequireVerificationBeforeUpdate"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.UserAttributeUpdateSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(UserAttributeUpdateSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserAttributeUpdateSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Requires that your user verifies their email address, phone number, or both before Amazon Cognito updates the value of that attribute.
         * <p>
         * When you update a user attribute that has this option activated, Amazon Cognito sends a verification message to the new phone number or email address. Amazon Cognito doesn’t change the value of the attribute until your user responds to the verification message and confirms the new value.
         * <p>
         * You can verify an updated email address or phone number with a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html">VerifyUserAttribute</a> API request. You can also call the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a> API and set <code>email_verified</code> or <code>phone_number_verified</code> to true.
         * <p>
         * When <code>AttributesRequireVerificationBeforeUpdate</code> is false, your user pool doesn't require that your users verify attribute changes before Amazon Cognito updates them. In a user pool where <code>AttributesRequireVerificationBeforeUpdate</code> is false, API operations that change attribute values can immediately update a user’s <code>email</code> or <code>phone_number</code> attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttributesRequireVerificationBeforeUpdate();

        /**
         * @return a {@link Builder} of {@link UserAttributeUpdateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserAttributeUpdateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserAttributeUpdateSettingsProperty> {
            java.util.List<java.lang.String> attributesRequireVerificationBeforeUpdate;

            /**
             * Sets the value of {@link UserAttributeUpdateSettingsProperty#getAttributesRequireVerificationBeforeUpdate}
             * @param attributesRequireVerificationBeforeUpdate Requires that your user verifies their email address, phone number, or both before Amazon Cognito updates the value of that attribute. This parameter is required.
             *                                                  When you update a user attribute that has this option activated, Amazon Cognito sends a verification message to the new phone number or email address. Amazon Cognito doesn’t change the value of the attribute until your user responds to the verification message and confirms the new value.
             *                                                  <p>
             *                                                  You can verify an updated email address or phone number with a <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html">VerifyUserAttribute</a> API request. You can also call the <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html">AdminUpdateUserAttributes</a> API and set <code>email_verified</code> or <code>phone_number_verified</code> to true.
             *                                                  <p>
             *                                                  When <code>AttributesRequireVerificationBeforeUpdate</code> is false, your user pool doesn't require that your users verify attribute changes before Amazon Cognito updates them. In a user pool where <code>AttributesRequireVerificationBeforeUpdate</code> is false, API operations that change attribute values can immediately update a user’s <code>email</code> or <code>phone_number</code> attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributesRequireVerificationBeforeUpdate(java.util.List<java.lang.String> attributesRequireVerificationBeforeUpdate) {
                this.attributesRequireVerificationBeforeUpdate = attributesRequireVerificationBeforeUpdate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserAttributeUpdateSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserAttributeUpdateSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserAttributeUpdateSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserAttributeUpdateSettingsProperty {
            private final java.util.List<java.lang.String> attributesRequireVerificationBeforeUpdate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributesRequireVerificationBeforeUpdate = software.amazon.jsii.Kernel.get(this, "attributesRequireVerificationBeforeUpdate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributesRequireVerificationBeforeUpdate = java.util.Objects.requireNonNull(builder.attributesRequireVerificationBeforeUpdate, "attributesRequireVerificationBeforeUpdate is required");
            }

            @Override
            public final java.util.List<java.lang.String> getAttributesRequireVerificationBeforeUpdate() {
                return this.attributesRequireVerificationBeforeUpdate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributesRequireVerificationBeforeUpdate", om.valueToTree(this.getAttributesRequireVerificationBeforeUpdate()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.UserAttributeUpdateSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserAttributeUpdateSettingsProperty.Jsii$Proxy that = (UserAttributeUpdateSettingsProperty.Jsii$Proxy) o;

                return this.attributesRequireVerificationBeforeUpdate.equals(that.attributesRequireVerificationBeforeUpdate);
            }

            @Override
            public final int hashCode() {
                int result = this.attributesRequireVerificationBeforeUpdate.hashCode();
                return result;
            }
        }
    }
    /**
     * The user pool add-ons type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * UserPoolAddOnsProperty userPoolAddOnsProperty = UserPoolAddOnsProperty.builder()
     *         .advancedSecurityMode("advancedSecurityMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.UserPoolAddOnsProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPoolAddOnsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPoolAddOnsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The advanced security mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdvancedSecurityMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPoolAddOnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPoolAddOnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPoolAddOnsProperty> {
            java.lang.String advancedSecurityMode;

            /**
             * Sets the value of {@link UserPoolAddOnsProperty#getAdvancedSecurityMode}
             * @param advancedSecurityMode The advanced security mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedSecurityMode(java.lang.String advancedSecurityMode) {
                this.advancedSecurityMode = advancedSecurityMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPoolAddOnsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPoolAddOnsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPoolAddOnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolAddOnsProperty {
            private final java.lang.String advancedSecurityMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.advancedSecurityMode = software.amazon.jsii.Kernel.get(this, "advancedSecurityMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.advancedSecurityMode = builder.advancedSecurityMode;
            }

            @Override
            public final java.lang.String getAdvancedSecurityMode() {
                return this.advancedSecurityMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdvancedSecurityMode() != null) {
                    data.set("advancedSecurityMode", om.valueToTree(this.getAdvancedSecurityMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.UserPoolAddOnsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPoolAddOnsProperty.Jsii$Proxy that = (UserPoolAddOnsProperty.Jsii$Proxy) o;

                return this.advancedSecurityMode != null ? this.advancedSecurityMode.equals(that.advancedSecurityMode) : that.advancedSecurityMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.advancedSecurityMode != null ? this.advancedSecurityMode.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `UsernameConfiguration` property type specifies case sensitivity on the username input for the selected sign-in option.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * UsernameConfigurationProperty usernameConfigurationProperty = UsernameConfigurationProperty.builder()
     *         .caseSensitive(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.UsernameConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(UsernameConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UsernameConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.
         * <p>
         * For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><strong>True</strong> - Enables case sensitivity for all username input. When this option is set to <code>True</code> , users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</li>
         * <li><strong>False</strong> - Enables case insensitivity for all username input. For example, when this option is set to <code>False</code> , users can sign in using <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> . This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaseSensitive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UsernameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UsernameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UsernameConfigurationProperty> {
            java.lang.Object caseSensitive;

            /**
             * Sets the value of {@link UsernameConfigurationProperty#getCaseSensitive}
             * @param caseSensitive Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.
             *                      For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
             *                      <p>
             *                      Valid values include:
             *                      <p>
             *                      <ul>
             *                      <li><strong>True</strong> - Enables case sensitivity for all username input. When this option is set to <code>True</code> , users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</li>
             *                      <li><strong>False</strong> - Enables case insensitivity for all username input. For example, when this option is set to <code>False</code> , users can sign in using <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> . This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseSensitive(java.lang.Boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                return this;
            }

            /**
             * Sets the value of {@link UsernameConfigurationProperty#getCaseSensitive}
             * @param caseSensitive Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs.
             *                      For most use cases, set case sensitivity to <code>False</code> (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
             *                      <p>
             *                      Valid values include:
             *                      <p>
             *                      <ul>
             *                      <li><strong>True</strong> - Enables case sensitivity for all username input. When this option is set to <code>True</code> , users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.</li>
             *                      <li><strong>False</strong> - Enables case insensitivity for all username input. For example, when this option is set to <code>False</code> , users can sign in using <code>username</code> , <code>USERNAME</code> , or <code>UserName</code> . This option also enables both <code>preferred_username</code> and <code>email</code> alias to be case insensitive, in addition to the <code>username</code> attribute.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseSensitive(software.amazon.awscdk.core.IResolvable caseSensitive) {
                this.caseSensitive = caseSensitive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UsernameConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UsernameConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UsernameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsernameConfigurationProperty {
            private final java.lang.Object caseSensitive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.caseSensitive = software.amazon.jsii.Kernel.get(this, "caseSensitive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.caseSensitive = builder.caseSensitive;
            }

            @Override
            public final java.lang.Object getCaseSensitive() {
                return this.caseSensitive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaseSensitive() != null) {
                    data.set("caseSensitive", om.valueToTree(this.getCaseSensitive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.UsernameConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UsernameConfigurationProperty.Jsii$Proxy that = (UsernameConfigurationProperty.Jsii$Proxy) o;

                return this.caseSensitive != null ? this.caseSensitive.equals(that.caseSensitive) : that.caseSensitive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.caseSensitive != null ? this.caseSensitive.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The template for verification messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * VerificationMessageTemplateProperty verificationMessageTemplateProperty = VerificationMessageTemplateProperty.builder()
     *         .defaultEmailOption("defaultEmailOption")
     *         .emailMessage("emailMessage")
     *         .emailMessageByLink("emailMessageByLink")
     *         .emailSubject("emailSubject")
     *         .emailSubjectByLink("emailSubjectByLink")
     *         .smsMessage("smsMessage")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.CfnUserPool.VerificationMessageTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(VerificationMessageTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VerificationMessageTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default email option.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultEmailOption() {
            return null;
        }

        /**
         * The template for email messages that Amazon Cognito sends to your users.
         * <p>
         * You can set an <code>EmailMessage</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailMessage() {
            return null;
        }

        /**
         * The email message template for sending a confirmation link to the user.
         * <p>
         * You can set an <code>EmailMessageByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailMessageByLink() {
            return null;
        }

        /**
         * The subject line for the email message template.
         * <p>
         * You can set an <code>EmailSubject</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailSubject() {
            return null;
        }

        /**
         * The subject line for the email message template for sending a confirmation link to the user.
         * <p>
         * You can set an <code>EmailSubjectByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailSubjectByLink() {
            return null;
        }

        /**
         * The template for SMS messages that Amazon Cognito sends to your users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSmsMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VerificationMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VerificationMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VerificationMessageTemplateProperty> {
            java.lang.String defaultEmailOption;
            java.lang.String emailMessage;
            java.lang.String emailMessageByLink;
            java.lang.String emailSubject;
            java.lang.String emailSubjectByLink;
            java.lang.String smsMessage;

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getDefaultEmailOption}
             * @param defaultEmailOption The default email option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEmailOption(java.lang.String defaultEmailOption) {
                this.defaultEmailOption = defaultEmailOption;
                return this;
            }

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getEmailMessage}
             * @param emailMessage The template for email messages that Amazon Cognito sends to your users.
             *                     You can set an <code>EmailMessage</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessage(java.lang.String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getEmailMessageByLink}
             * @param emailMessageByLink The email message template for sending a confirmation link to the user.
             *                           You can set an <code>EmailMessageByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessageByLink(java.lang.String emailMessageByLink) {
                this.emailMessageByLink = emailMessageByLink;
                return this;
            }

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getEmailSubject}
             * @param emailSubject The subject line for the email message template.
             *                     You can set an <code>EmailSubject</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailSubject(java.lang.String emailSubject) {
                this.emailSubject = emailSubject;
                return this;
            }

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getEmailSubjectByLink}
             * @param emailSubjectByLink The subject line for the email message template for sending a confirmation link to the user.
             *                           You can set an <code>EmailSubjectByLink</code> template only if the value of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> . When your <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is <code>DEVELOPER</code> , your user pool sends email messages with your own Amazon SES configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailSubjectByLink(java.lang.String emailSubjectByLink) {
                this.emailSubjectByLink = emailSubjectByLink;
                return this;
            }

            /**
             * Sets the value of {@link VerificationMessageTemplateProperty#getSmsMessage}
             * @param smsMessage The template for SMS messages that Amazon Cognito sends to your users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessage(java.lang.String smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VerificationMessageTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VerificationMessageTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VerificationMessageTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VerificationMessageTemplateProperty {
            private final java.lang.String defaultEmailOption;
            private final java.lang.String emailMessage;
            private final java.lang.String emailMessageByLink;
            private final java.lang.String emailSubject;
            private final java.lang.String emailSubjectByLink;
            private final java.lang.String smsMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultEmailOption = software.amazon.jsii.Kernel.get(this, "defaultEmailOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailMessage = software.amazon.jsii.Kernel.get(this, "emailMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailMessageByLink = software.amazon.jsii.Kernel.get(this, "emailMessageByLink", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailSubject = software.amazon.jsii.Kernel.get(this, "emailSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emailSubjectByLink = software.amazon.jsii.Kernel.get(this, "emailSubjectByLink", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smsMessage = software.amazon.jsii.Kernel.get(this, "smsMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultEmailOption = builder.defaultEmailOption;
                this.emailMessage = builder.emailMessage;
                this.emailMessageByLink = builder.emailMessageByLink;
                this.emailSubject = builder.emailSubject;
                this.emailSubjectByLink = builder.emailSubjectByLink;
                this.smsMessage = builder.smsMessage;
            }

            @Override
            public final java.lang.String getDefaultEmailOption() {
                return this.defaultEmailOption;
            }

            @Override
            public final java.lang.String getEmailMessage() {
                return this.emailMessage;
            }

            @Override
            public final java.lang.String getEmailMessageByLink() {
                return this.emailMessageByLink;
            }

            @Override
            public final java.lang.String getEmailSubject() {
                return this.emailSubject;
            }

            @Override
            public final java.lang.String getEmailSubjectByLink() {
                return this.emailSubjectByLink;
            }

            @Override
            public final java.lang.String getSmsMessage() {
                return this.smsMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultEmailOption() != null) {
                    data.set("defaultEmailOption", om.valueToTree(this.getDefaultEmailOption()));
                }
                if (this.getEmailMessage() != null) {
                    data.set("emailMessage", om.valueToTree(this.getEmailMessage()));
                }
                if (this.getEmailMessageByLink() != null) {
                    data.set("emailMessageByLink", om.valueToTree(this.getEmailMessageByLink()));
                }
                if (this.getEmailSubject() != null) {
                    data.set("emailSubject", om.valueToTree(this.getEmailSubject()));
                }
                if (this.getEmailSubjectByLink() != null) {
                    data.set("emailSubjectByLink", om.valueToTree(this.getEmailSubjectByLink()));
                }
                if (this.getSmsMessage() != null) {
                    data.set("smsMessage", om.valueToTree(this.getSmsMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_cognito.CfnUserPool.VerificationMessageTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VerificationMessageTemplateProperty.Jsii$Proxy that = (VerificationMessageTemplateProperty.Jsii$Proxy) o;

                if (this.defaultEmailOption != null ? !this.defaultEmailOption.equals(that.defaultEmailOption) : that.defaultEmailOption != null) return false;
                if (this.emailMessage != null ? !this.emailMessage.equals(that.emailMessage) : that.emailMessage != null) return false;
                if (this.emailMessageByLink != null ? !this.emailMessageByLink.equals(that.emailMessageByLink) : that.emailMessageByLink != null) return false;
                if (this.emailSubject != null ? !this.emailSubject.equals(that.emailSubject) : that.emailSubject != null) return false;
                if (this.emailSubjectByLink != null ? !this.emailSubjectByLink.equals(that.emailSubjectByLink) : that.emailSubjectByLink != null) return false;
                return this.smsMessage != null ? this.smsMessage.equals(that.smsMessage) : that.smsMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultEmailOption != null ? this.defaultEmailOption.hashCode() : 0;
                result = 31 * result + (this.emailMessage != null ? this.emailMessage.hashCode() : 0);
                result = 31 * result + (this.emailMessageByLink != null ? this.emailMessageByLink.hashCode() : 0);
                result = 31 * result + (this.emailSubject != null ? this.emailSubject.hashCode() : 0);
                result = 31 * result + (this.emailSubjectByLink != null ? this.emailSubjectByLink.hashCode() : 0);
                result = 31 * result + (this.smsMessage != null ? this.smsMessage.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cognito.CfnUserPoolProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
         * <p>
         * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
         * <p>
         * @return {@code this}
         * @param accountRecoverySetting Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(final software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty accountRecoverySetting) {
            this.props().accountRecoverySetting(accountRecoverySetting);
            return this;
        }
        /**
         * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
         * <p>
         * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
         * <p>
         * @return {@code this}
         * @param accountRecoverySetting Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(final software.amazon.awscdk.core.IResolvable accountRecoverySetting) {
            this.props().accountRecoverySetting(accountRecoverySetting);
            return this;
        }

        /**
         * The configuration for creating a new user profile.
         * <p>
         * @return {@code this}
         * @param adminCreateUserConfig The configuration for creating a new user profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(final software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty adminCreateUserConfig) {
            this.props().adminCreateUserConfig(adminCreateUserConfig);
            return this;
        }
        /**
         * The configuration for creating a new user profile.
         * <p>
         * @return {@code this}
         * @param adminCreateUserConfig The configuration for creating a new user profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(final software.amazon.awscdk.core.IResolvable adminCreateUserConfig) {
            this.props().adminCreateUserConfig(adminCreateUserConfig);
            return this;
        }

        /**
         * Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
         * <p>
         * <blockquote>
         * <p>
         * This user pool property cannot be updated.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param aliasAttributes Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasAttributes(final java.util.List<java.lang.String> aliasAttributes) {
            this.props().aliasAttributes(aliasAttributes);
            return this;
        }

        /**
         * The attributes to be auto-verified.
         * <p>
         * Possible values: <em>email</em> , <em>phone_number</em> .
         * <p>
         * @return {@code this}
         * @param autoVerifiedAttributes The attributes to be auto-verified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoVerifiedAttributes(final java.util.List<java.lang.String> autoVerifiedAttributes) {
            this.props().autoVerifiedAttributes(autoVerifiedAttributes);
            return this;
        }

        /**
         * `AWS::Cognito::UserPool.DeletionProtection`.
         * <p>
         * @return {@code this}
         * @param deletionProtection `AWS::Cognito::UserPool.DeletionProtection`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.String deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The device-remembering configuration for a user pool.
         * <p>
         * A null value indicates that you have deactivated device remembering in your user pool.
         * <p>
         * <blockquote>
         * <p>
         * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deviceConfiguration The device-remembering configuration for a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty deviceConfiguration) {
            this.props().deviceConfiguration(deviceConfiguration);
            return this;
        }
        /**
         * The device-remembering configuration for a user pool.
         * <p>
         * A null value indicates that you have deactivated device remembering in your user pool.
         * <p>
         * <blockquote>
         * <p>
         * When you provide a value for any <code>DeviceConfiguration</code> field, you activate the Amazon Cognito device-remembering feature.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param deviceConfiguration The device-remembering configuration for a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(final software.amazon.awscdk.core.IResolvable deviceConfiguration) {
            this.props().deviceConfiguration(deviceConfiguration);
            return this;
        }

        /**
         * The email configuration of your user pool.
         * <p>
         * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
         * <p>
         * @return {@code this}
         * @param emailConfiguration The email configuration of your user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty emailConfiguration) {
            this.props().emailConfiguration(emailConfiguration);
            return this;
        }
        /**
         * The email configuration of your user pool.
         * <p>
         * The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
         * <p>
         * @return {@code this}
         * @param emailConfiguration The email configuration of your user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(final software.amazon.awscdk.core.IResolvable emailConfiguration) {
            this.props().emailConfiguration(emailConfiguration);
            return this;
        }

        /**
         * This parameter is no longer used.
         * <p>
         * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
         * <p>
         * @return {@code this}
         * @param emailVerificationMessage This parameter is no longer used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationMessage(final java.lang.String emailVerificationMessage) {
            this.props().emailVerificationMessage(emailVerificationMessage);
            return this;
        }

        /**
         * This parameter is no longer used.
         * <p>
         * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
         * <p>
         * @return {@code this}
         * @param emailVerificationSubject This parameter is no longer used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationSubject(final java.lang.String emailVerificationSubject) {
            this.props().emailVerificationSubject(emailVerificationSubject);
            return this;
        }

        /**
         * Enables MFA on a specified user pool.
         * <p>
         * To disable all MFAs after it has been enabled, set MfaConfiguration to “OFF” and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to “OFF”. Can be one of the following values:
         * <p>
         * <ul>
         * <li><code>SMS_MFA</code> - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.</li>
         * <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
         * </ul>
         * <p>
         * Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code>
         * <p>
         * @return {@code this}
         * @param enabledMfas Enables MFA on a specified user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabledMfas(final java.util.List<java.lang.String> enabledMfas) {
            this.props().enabledMfas(enabledMfas);
            return this;
        }

        /**
         * The Lambda trigger configuration information for the new user pool.
         * <p>
         * <blockquote>
         * <p>
         * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
         * <p>
         * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
         * <p>
         * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param lambdaConfig The Lambda trigger configuration information for the new user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(final software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty lambdaConfig) {
            this.props().lambdaConfig(lambdaConfig);
            return this;
        }
        /**
         * The Lambda trigger configuration information for the new user pool.
         * <p>
         * <blockquote>
         * <p>
         * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
         * <p>
         * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
         * <p>
         * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param lambdaConfig The Lambda trigger configuration information for the new user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(final software.amazon.awscdk.core.IResolvable lambdaConfig) {
            this.props().lambdaConfig(lambdaConfig);
            return this;
        }

        /**
         * The multi-factor authentication (MFA) configuration. Valid values include:.
         * <p>
         * <ul>
         * <li><code>OFF</code> MFA won't be used for any users.</li>
         * <li><code>ON</code> MFA is required for all users to sign in.</li>
         * <li><code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param mfaConfiguration The multi-factor authentication (MFA) configuration. Valid values include:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfaConfiguration(final java.lang.String mfaConfiguration) {
            this.props().mfaConfiguration(mfaConfiguration);
            return this;
        }

        /**
         * The policy associated with a user pool.
         * <p>
         * @return {@code this}
         * @param policies The policy associated with a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty policies) {
            this.props().policies(policies);
            return this;
        }
        /**
         * The policy associated with a user pool.
         * <p>
         * @return {@code this}
         * @param policies The policy associated with a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(final software.amazon.awscdk.core.IResolvable policies) {
            this.props().policies(policies);
            return this;
        }

        /**
         * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
         * <p>
         * <blockquote>
         * <p>
         * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param schema The schema attributes for the new user pool. These attributes can be standard or custom attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final software.amazon.awscdk.core.IResolvable schema) {
            this.props().schema(schema);
            return this;
        }
        /**
         * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
         * <p>
         * <blockquote>
         * <p>
         * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param schema The schema attributes for the new user pool. These attributes can be standard or custom attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final java.util.List<? extends java.lang.Object> schema) {
            this.props().schema(schema);
            return this;
        }

        /**
         * A string representing the SMS authentication message.
         * <p>
         * @return {@code this}
         * @param smsAuthenticationMessage A string representing the SMS authentication message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsAuthenticationMessage(final java.lang.String smsAuthenticationMessage) {
            this.props().smsAuthenticationMessage(smsAuthenticationMessage);
            return this;
        }

        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service.
         * <p>
         * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
         * <p>
         * @return {@code this}
         * @param smsConfiguration The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty smsConfiguration) {
            this.props().smsConfiguration(smsConfiguration);
            return this;
        }
        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service.
         * <p>
         * To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
         * <p>
         * @return {@code this}
         * @param smsConfiguration The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(final software.amazon.awscdk.core.IResolvable smsConfiguration) {
            this.props().smsConfiguration(smsConfiguration);
            return this;
        }

        /**
         * This parameter is no longer used.
         * <p>
         * See <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html">VerificationMessageTemplateType</a> .
         * <p>
         * @return {@code this}
         * @param smsVerificationMessage This parameter is no longer used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsVerificationMessage(final java.lang.String smsVerificationMessage) {
            this.props().smsVerificationMessage(smsVerificationMessage);
            return this;
        }

        /**
         * The settings for updates to user attributes.
         * <p>
         * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
         * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
         * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
         * <p>
         * @return {@code this}
         * @param userAttributeUpdateSettings The settings for updates to user attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributeUpdateSettings(final software.amazon.awscdk.services.cognito.CfnUserPool.UserAttributeUpdateSettingsProperty userAttributeUpdateSettings) {
            this.props().userAttributeUpdateSettings(userAttributeUpdateSettings);
            return this;
        }
        /**
         * The settings for updates to user attributes.
         * <p>
         * These settings include the property <code>AttributesRequireVerificationBeforeUpdate</code> ,
         * a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
         * more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates">Verifying updates to email addresses and phone numbers</a> .
         * <p>
         * @return {@code this}
         * @param userAttributeUpdateSettings The settings for updates to user attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributeUpdateSettings(final software.amazon.awscdk.core.IResolvable userAttributeUpdateSettings) {
            this.props().userAttributeUpdateSettings(userAttributeUpdateSettings);
            return this;
        }

        /**
         * Determines whether email addresses or phone numbers can be specified as user names when a user signs up.
         * <p>
         * Possible values: <code>phone_number</code> or <code>email</code> .
         * <p>
         * This user pool property cannot be updated.
         * <p>
         * @return {@code this}
         * @param usernameAttributes Determines whether email addresses or phone numbers can be specified as user names when a user signs up. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameAttributes(final java.util.List<java.lang.String> usernameAttributes) {
            this.props().usernameAttributes(usernameAttributes);
            return this;
        }

        /**
         * You can choose to set case sensitivity on the username input for the selected sign-in option.
         * <p>
         * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
         * <p>
         * @return {@code this}
         * @param usernameConfiguration You can choose to set case sensitivity on the username input for the selected sign-in option. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty usernameConfiguration) {
            this.props().usernameConfiguration(usernameConfiguration);
            return this;
        }
        /**
         * You can choose to set case sensitivity on the username input for the selected sign-in option.
         * <p>
         * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
         * <p>
         * @return {@code this}
         * @param usernameConfiguration You can choose to set case sensitivity on the username input for the selected sign-in option. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(final software.amazon.awscdk.core.IResolvable usernameConfiguration) {
            this.props().usernameConfiguration(usernameConfiguration);
            return this;
        }

        /**
         * Enables advanced security risk detection.
         * <p>
         * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
         * <p>
         * @return {@code this}
         * @param userPoolAddOns Enables advanced security risk detection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(final software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty userPoolAddOns) {
            this.props().userPoolAddOns(userPoolAddOns);
            return this;
        }
        /**
         * Enables advanced security risk detection.
         * <p>
         * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
         * <p>
         * @return {@code this}
         * @param userPoolAddOns Enables advanced security risk detection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(final software.amazon.awscdk.core.IResolvable userPoolAddOns) {
            this.props().userPoolAddOns(userPoolAddOns);
            return this;
        }

        /**
         * A string used to name the user pool.
         * <p>
         * @return {@code this}
         * @param userPoolName A string used to name the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolName(final java.lang.String userPoolName) {
            this.props().userPoolName(userPoolName);
            return this;
        }

        /**
         * The tag keys and values to assign to the user pool.
         * <p>
         * A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * <p>
         * @return {@code this}
         * @param userPoolTags The tag keys and values to assign to the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolTags(final java.lang.Object userPoolTags) {
            this.props().userPoolTags(userPoolTags);
            return this;
        }

        /**
         * The template for the verification message that the user sees when the app requests permission to access the user's information.
         * <p>
         * @return {@code this}
         * @param verificationMessageTemplate The template for the verification message that the user sees when the app requests permission to access the user's information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(final software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty verificationMessageTemplate) {
            this.props().verificationMessageTemplate(verificationMessageTemplate);
            return this;
        }
        /**
         * The template for the verification message that the user sees when the app requests permission to access the user's information.
         * <p>
         * @return {@code this}
         * @param verificationMessageTemplate The template for the verification message that the user sees when the app requests permission to access the user's information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(final software.amazon.awscdk.core.IResolvable verificationMessageTemplate) {
            this.props().verificationMessageTemplate(verificationMessageTemplate);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPool build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPool(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cognito.CfnUserPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolProps.Builder();
            }
            return this.props;
        }
    }
}
