package software.amazon.awscdk.services.cognito;

/**
 * (experimental) Types of OAuth grant flows.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = UserPool.Builder.create(this, "UserPool").build();
 * UserPoolClient client = userpool.addClient("Client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 .flows(OAuthFlows.builder()
 *                         .implicitCodeGrant(true)
 *                         .build())
 *                 .callbackUrls(List.of("https://myapp.com/home", "https://myapp.com/users"))
 *                 .build())
 *         .build());
 * UserPoolDomain domain = userpool.addDomain("Domain", UserPoolDomainOptions.builder().build());
 * String signInUrl = domain.signInUrl(client, SignInUrlOptions.builder()
 *         .redirectUri("https://myapp.com/home")
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="- the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html">- the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.919Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.OAuthFlows")
@software.amazon.jsii.Jsii.Proxy(OAuthFlows.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OAuthFlows extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Initiate an authorization code grant flow, which provides an authorization code as the response.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAuthorizationCodeGrant() {
        return null;
    }

    /**
     * (experimental) Client should get the access token and ID token from the token endpoint using a combination of client and client_secret.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getClientCredentials() {
        return null;
    }

    /**
     * (experimental) The client should get the access token and ID token directly.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getImplicitCodeGrant() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OAuthFlows}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OAuthFlows}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<OAuthFlows> {
        java.lang.Boolean authorizationCodeGrant;
        java.lang.Boolean clientCredentials;
        java.lang.Boolean implicitCodeGrant;

        /**
         * Sets the value of {@link OAuthFlows#getAuthorizationCodeGrant}
         * @param authorizationCodeGrant Initiate an authorization code grant flow, which provides an authorization code as the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizationCodeGrant(java.lang.Boolean authorizationCodeGrant) {
            this.authorizationCodeGrant = authorizationCodeGrant;
            return this;
        }

        /**
         * Sets the value of {@link OAuthFlows#getClientCredentials}
         * @param clientCredentials Client should get the access token and ID token from the token endpoint using a combination of client and client_secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientCredentials(java.lang.Boolean clientCredentials) {
            this.clientCredentials = clientCredentials;
            return this;
        }

        /**
         * Sets the value of {@link OAuthFlows#getImplicitCodeGrant}
         * @param implicitCodeGrant The client should get the access token and ID token directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder implicitCodeGrant(java.lang.Boolean implicitCodeGrant) {
            this.implicitCodeGrant = implicitCodeGrant;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OAuthFlows}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public OAuthFlows build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OAuthFlows}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthFlows {
        private final java.lang.Boolean authorizationCodeGrant;
        private final java.lang.Boolean clientCredentials;
        private final java.lang.Boolean implicitCodeGrant;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationCodeGrant = software.amazon.jsii.Kernel.get(this, "authorizationCodeGrant", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.clientCredentials = software.amazon.jsii.Kernel.get(this, "clientCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.implicitCodeGrant = software.amazon.jsii.Kernel.get(this, "implicitCodeGrant", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationCodeGrant = builder.authorizationCodeGrant;
            this.clientCredentials = builder.clientCredentials;
            this.implicitCodeGrant = builder.implicitCodeGrant;
        }

        @Override
        public final java.lang.Boolean getAuthorizationCodeGrant() {
            return this.authorizationCodeGrant;
        }

        @Override
        public final java.lang.Boolean getClientCredentials() {
            return this.clientCredentials;
        }

        @Override
        public final java.lang.Boolean getImplicitCodeGrant() {
            return this.implicitCodeGrant;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizationCodeGrant() != null) {
                data.set("authorizationCodeGrant", om.valueToTree(this.getAuthorizationCodeGrant()));
            }
            if (this.getClientCredentials() != null) {
                data.set("clientCredentials", om.valueToTree(this.getClientCredentials()));
            }
            if (this.getImplicitCodeGrant() != null) {
                data.set("implicitCodeGrant", om.valueToTree(this.getImplicitCodeGrant()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito.OAuthFlows"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OAuthFlows.Jsii$Proxy that = (OAuthFlows.Jsii$Proxy) o;

            if (this.authorizationCodeGrant != null ? !this.authorizationCodeGrant.equals(that.authorizationCodeGrant) : that.authorizationCodeGrant != null) return false;
            if (this.clientCredentials != null ? !this.clientCredentials.equals(that.clientCredentials) : that.clientCredentials != null) return false;
            return this.implicitCodeGrant != null ? this.implicitCodeGrant.equals(that.implicitCodeGrant) : that.implicitCodeGrant == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationCodeGrant != null ? this.authorizationCodeGrant.hashCode() : 0;
            result = 31 * result + (this.clientCredentials != null ? this.clientCredentials.hashCode() : 0);
            result = 31 * result + (this.implicitCodeGrant != null ? this.implicitCodeGrant.hashCode() : 0);
            return result;
        }
    }
}
