package software.amazon.awscdk.services.cognito;

/**
 * (experimental) An attribute available from a third party identity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .userPool(userpool)
 *         .attributeMapping(AttributeMapping.builder()
 *                 .email(ProviderAttribute.AMAZON_EMAIL)
 *                 .website(ProviderAttribute.other("url")) // use other() when an attribute is not pre-defined in the CDK
 *                 .custom(Map.of(
 *                         // custom user pool attributes go here
 *                         "uniqueId", ProviderAttribute.AMAZON_USER_ID))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.925Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.ProviderAttribute")
public class ProviderAttribute extends software.amazon.jsii.JsiiObject {

    protected ProviderAttribute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProviderAttribute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_POSTAL_CODE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_POSTAL_CODE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_USER_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_USER_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_FIRST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_FIRST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_LAST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_LAST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_BIRTHDAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_BIRTHDAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_FIRST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_FIRST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_GENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_GENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_LAST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_LAST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_LOCALE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_LOCALE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_MIDDLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_MIDDLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_BIRTHDAYS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_BIRTHDAYS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_FAMILY_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_FAMILY_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_GENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_GENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_GIVEN_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_GIVEN_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_NAMES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_NAMES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_PHONE_NUMBERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_PHONE_NUMBERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_PICTURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_PICTURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
    }

    /**
     * (experimental) Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * <p>
     * @param attributeName the attribute value string as recognized by the provider. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ProviderAttribute other(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "other", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * (experimental) The email attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_EMAIL;

    /**
     * (experimental) The name attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_NAME;

    /**
     * (experimental) The postal code attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_POSTAL_CODE;

    /**
     * (experimental) The user id attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_USER_ID;

    /**
     * (experimental) The email attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_EMAIL;

    /**
     * (experimental) The first name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_FIRST_NAME;

    /**
     * (experimental) The last name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_LAST_NAME;

    /**
     * (experimental) The name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_NAME;

    /**
     * (experimental) The birthday attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_BIRTHDAY;

    /**
     * (experimental) The email attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_EMAIL;

    /**
     * (experimental) The first name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_FIRST_NAME;

    /**
     * (experimental) The gender attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_GENDER;

    /**
     * (experimental) The user id attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_ID;

    /**
     * (experimental) The last name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_LAST_NAME;

    /**
     * (experimental) The locale attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_LOCALE;

    /**
     * (experimental) The middle name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_MIDDLE_NAME;

    /**
     * (experimental) The name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_NAME;

    /**
     * (experimental) The birthday attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_BIRTHDAYS;

    /**
     * (experimental) The email attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_EMAIL;

    /**
     * (experimental) The family name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_FAMILY_NAME;

    /**
     * (experimental) The gender attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_GENDER;

    /**
     * (experimental) The given name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_GIVEN_NAME;

    /**
     * (experimental) The name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_NAME;

    /**
     * (experimental) The name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_NAMES;

    /**
     * (experimental) The phone number attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_PHONE_NUMBERS;

    /**
     * (experimental) The picture attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_PICTURE;

    /**
     * (experimental) The attribute value string as recognized by the provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttributeName() {
        return software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
