package software.amazon.awscdk.services.cognito;

/**
 * (experimental) Identity providers supported by the UserPoolClient.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .supportedIdentityProviders(List.of(UserPoolClientIdentityProvider.AMAZON, UserPoolClientIdentityProvider.COGNITO))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.944Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.UserPoolClientIdentityProvider")
public class UserPoolClientIdentityProvider extends software.amazon.jsii.JsiiObject {

    protected UserPoolClientIdentityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolClientIdentityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "AMAZON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        APPLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "APPLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        COGNITO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "COGNITO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        FACEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "FACEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        GOOGLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "GOOGLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
    }

    /**
     * (experimental) Specify a provider not yet supported by the CDK.
     * <p>
     * @param name name of the identity provider as recognized by CloudFormation property `SupportedIdentityProviders`. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider custom(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) Allow users to sign in using 'Login With Amazon'.
     * <p>
     * A <code>UserPoolIdentityProviderAmazon</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider AMAZON;

    /**
     * (experimental) Allow users to sign in using 'Sign In With Apple'.
     * <p>
     * A <code>UserPoolIdentityProviderApple</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider APPLE;

    /**
     * (experimental) Allow users to sign in directly as a user of the User Pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider COGNITO;

    /**
     * (experimental) Allow users to sign in using 'Facebook Login'.
     * <p>
     * A <code>UserPoolIdentityProviderFacebook</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider FACEBOOK;

    /**
     * (experimental) Allow users to sign in using 'Google Login'.
     * <p>
     * A <code>UserPoolIdentityProviderGoogle</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider GOOGLE;

    /**
     * (experimental) The name of the identity provider as recognized by CloudFormation property `SupportedIdentityProviders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
