package software.amazon.awscdk.services.cognito;

/**
 * (experimental) Props for the UserPool construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .selfSignUpEnabled(true)
 *         .userVerification(UserVerificationConfig.builder()
 *                 .emailSubject("Verify your email for our awesome app!")
 *                 .emailBody("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .emailStyle(VerificationEmailStyle.CODE)
 *                 .smsMessage("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:57.973Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito.UserPoolProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) How will a user be able to recover their account?
     * <p>
     * Default: AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AccountRecovery getAccountRecovery() {
        return null;
    }

    /**
     * (experimental) Attributes which Cognito will look to verify automatically upon user sign up.
     * <p>
     * EMAIL and PHONE are the only available options.
     * <p>
     * Default: - If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default.
     * If absent, no attributes will be auto-verified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AutoVerifiedAttrs getAutoVerify() {
        return null;
    }

    /**
     * (experimental) Define a set of custom attributes that can be configured for each user in the user pool.
     * <p>
     * Default: - No custom attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> getCustomAttributes() {
        return null;
    }

    /**
     * (experimental) This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.
     * <p>
     * Default: - no key ID configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getCustomSenderKmsKey() {
        return null;
    }

    /**
     * (experimental) Device tracking settings.
     * <p>
     * Default: - see defaults on each property of DeviceTracking.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.DeviceTracking getDeviceTracking() {
        return null;
    }

    /**
     * (experimental) Email settings for a user pool.
     * <p>
     * Default: - cognito will use the default email configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolEmail getEmail() {
        return null;
    }

    /**
     * (deprecated) Email settings for a user pool.
     * <p>
     * Default: - see defaults on each property of EmailSettings.
     * <p>
     * @deprecated Use 'email' instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.EmailSettings getEmailSettings() {
        return null;
    }

    /**
     * (experimental) Setting this would explicitly enable or disable SMS role creation.
     * <p>
     * When left unspecified, CDK will determine based on other properties if a role is needed or not.
     * <p>
     * Default: - CDK will determine based on other properties of the user pool if an SMS role should be created or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableSmsRole() {
        return null;
    }

    /**
     * (experimental) Lambda functions to use for supported Cognito triggers.
     * <p>
     * Default: - No Lambda triggers.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolTriggers getLambdaTriggers() {
        return null;
    }

    /**
     * (experimental) Configure whether users of this user pool can or are required use MFA to sign in.
     * <p>
     * Default: Mfa.OFF
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.Mfa getMfa() {
        return null;
    }

    /**
     * (experimental) The SMS message template sent during MFA verification.
     * <p>
     * Use '{####}' in the template where Cognito should insert the verification code.
     * <p>
     * Default: 'Your authentication code is {####}.'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getMfaMessage() {
        return null;
    }

    /**
     * (experimental) Configure the MFA types that users can use in this user pool.
     * <p>
     * Ignored if <code>mfa</code> is set to <code>OFF</code>.
     * <p>
     * Default: - { sms: true, otp: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`.
     * { sms: false, otp: false }, otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.MfaSecondFactor getMfaSecondFactor() {
        return null;
    }

    /**
     * (experimental) Password policy for this user pool.
     * <p>
     * Default: - see defaults on each property of PasswordPolicy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.PasswordPolicy getPasswordPolicy() {
        return null;
    }

    /**
     * (experimental) Policy to apply when the user pool is removed from the stack.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) Whether self sign up should be enabled.
     * <p>
     * This can be further configured via the <code>selfSignUp</code> property.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSelfSignUpEnabled() {
        return null;
    }

    /**
     * (experimental) Methods in which a user registers or signs in to a user pool.
     * <p>
     * Allows either username with aliases OR sign in with email, phone, or both.
     * <p>
     * Read the sections on usernames and aliases to learn more -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     * <p>
     * To match with 'Option 1' in the above link, with a verified email, this property should be set to
     * <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
     * number, this property should be set to <code>{ email: true, phone: true }</code>.
     * <p>
     * Default: { username: true }
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.SignInAliases getSignInAliases() {
        return null;
    }

    /**
     * (experimental) Whether sign-in aliases should be evaluated with case sensitivity.
     * <p>
     * For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSignInCaseSensitive() {
        return null;
    }

    /**
     * (experimental) The IAM role that Cognito will assume while sending SMS messages.
     * <p>
     * Default: - a new IAM role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getSmsRole() {
        return null;
    }

    /**
     * (experimental) The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
     * <p>
     * Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
     * <p>
     * This property will be ignored if <code>smsRole</code> is not specified.
     * <p>
     * Default: - No external id will be configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsRoleExternalId() {
        return null;
    }

    /**
     * (experimental) The region to integrate with SNS to send SMS messages.
     * <p>
     * This property will do nothing if SMS configuration is not configured
     * <p>
     * Default: - The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnsRegion() {
        return null;
    }

    /**
     * (experimental) The set of attributes that are required for every user in the user pool.
     * <p>
     * Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     * <p>
     * Default: - All standard attributes are optional and mutable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttributes getStandardAttributes() {
        return null;
    }

    /**
     * (experimental) Configuration around admins signing up users into a user pool.
     * <p>
     * Default: - see defaults in UserInvitationConfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserInvitationConfig getUserInvitation() {
        return null;
    }

    /**
     * (experimental) Name of the user pool.
     * <p>
     * Default: - automatically generated name by CloudFormation at deploy time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolName() {
        return null;
    }

    /**
     * (experimental) Configuration around users signing themselves up to the user pool.
     * <p>
     * Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
     * <p>
     * Default: - see defaults in UserVerificationConfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserVerificationConfig getUserVerification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolProps> {
        software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery;
        software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes;
        software.amazon.awscdk.services.kms.IKey customSenderKmsKey;
        software.amazon.awscdk.services.cognito.DeviceTracking deviceTracking;
        software.amazon.awscdk.services.cognito.UserPoolEmail email;
        software.amazon.awscdk.services.cognito.EmailSettings emailSettings;
        java.lang.Boolean enableSmsRole;
        software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers;
        software.amazon.awscdk.services.cognito.Mfa mfa;
        java.lang.String mfaMessage;
        software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor;
        software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.lang.Boolean selfSignUpEnabled;
        software.amazon.awscdk.services.cognito.SignInAliases signInAliases;
        java.lang.Boolean signInCaseSensitive;
        software.amazon.awscdk.services.iam.IRole smsRole;
        java.lang.String smsRoleExternalId;
        java.lang.String snsRegion;
        software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes;
        software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation;
        java.lang.String userPoolName;
        software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification;

        /**
         * Sets the value of {@link UserPoolProps#getAccountRecovery}
         * @param accountRecovery How will a user be able to recover their account?.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accountRecovery(software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery) {
            this.accountRecovery = accountRecovery;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getAutoVerify}
         * @param autoVerify Attributes which Cognito will look to verify automatically upon user sign up.
         *                   EMAIL and PHONE are the only available options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoVerify(software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify) {
            this.autoVerify = autoVerify;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getCustomAttributes}
         * @param customAttributes Define a set of custom attributes that can be configured for each user in the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder customAttributes(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes) {
            this.customAttributes = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute>)customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getCustomSenderKmsKey}
         * @param customSenderKmsKey This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customSenderKmsKey(software.amazon.awscdk.services.kms.IKey customSenderKmsKey) {
            this.customSenderKmsKey = customSenderKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getDeviceTracking}
         * @param deviceTracking Device tracking settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deviceTracking(software.amazon.awscdk.services.cognito.DeviceTracking deviceTracking) {
            this.deviceTracking = deviceTracking;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getEmail}
         * @param email Email settings for a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder email(software.amazon.awscdk.services.cognito.UserPoolEmail email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getEmailSettings}
         * @param emailSettings Email settings for a user pool.
         * @return {@code this}
         * @deprecated Use 'email' instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder emailSettings(software.amazon.awscdk.services.cognito.EmailSettings emailSettings) {
            this.emailSettings = emailSettings;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getEnableSmsRole}
         * @param enableSmsRole Setting this would explicitly enable or disable SMS role creation.
         *                      When left unspecified, CDK will determine based on other properties if a role is needed or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableSmsRole(java.lang.Boolean enableSmsRole) {
            this.enableSmsRole = enableSmsRole;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getLambdaTriggers}
         * @param lambdaTriggers Lambda functions to use for supported Cognito triggers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaTriggers(software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers) {
            this.lambdaTriggers = lambdaTriggers;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getMfa}
         * @param mfa Configure whether users of this user pool can or are required use MFA to sign in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfa(software.amazon.awscdk.services.cognito.Mfa mfa) {
            this.mfa = mfa;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getMfaMessage}
         * @param mfaMessage The SMS message template sent during MFA verification.
         *                   Use '{####}' in the template where Cognito should insert the verification code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfaMessage(java.lang.String mfaMessage) {
            this.mfaMessage = mfaMessage;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getMfaSecondFactor}
         * @param mfaSecondFactor Configure the MFA types that users can use in this user pool.
         *                        Ignored if <code>mfa</code> is set to <code>OFF</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfaSecondFactor(software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor) {
            this.mfaSecondFactor = mfaSecondFactor;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getPasswordPolicy}
         * @param passwordPolicy Password policy for this user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder passwordPolicy(software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the user pool is removed from the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSelfSignUpEnabled}
         * @param selfSignUpEnabled Whether self sign up should be enabled.
         *                          This can be further configured via the <code>selfSignUp</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder selfSignUpEnabled(java.lang.Boolean selfSignUpEnabled) {
            this.selfSignUpEnabled = selfSignUpEnabled;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSignInAliases}
         * @param signInAliases Methods in which a user registers or signs in to a user pool.
         *                      Allows either username with aliases OR sign in with email, phone, or both.
         *                      <p>
         *                      Read the sections on usernames and aliases to learn more -
         *                      https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         *                      <p>
         *                      To match with 'Option 1' in the above link, with a verified email, this property should be set to
         *                      <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
         *                      number, this property should be set to <code>{ email: true, phone: true }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInAliases(software.amazon.awscdk.services.cognito.SignInAliases signInAliases) {
            this.signInAliases = signInAliases;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSignInCaseSensitive}
         * @param signInCaseSensitive Whether sign-in aliases should be evaluated with case sensitivity.
         *                            For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInCaseSensitive(java.lang.Boolean signInCaseSensitive) {
            this.signInCaseSensitive = signInCaseSensitive;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSmsRole}
         * @param smsRole The IAM role that Cognito will assume while sending SMS messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRole(software.amazon.awscdk.services.iam.IRole smsRole) {
            this.smsRole = smsRole;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSmsRoleExternalId}
         * @param smsRoleExternalId The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
         *                          Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
         *                          <p>
         *                          This property will be ignored if <code>smsRole</code> is not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRoleExternalId(java.lang.String smsRoleExternalId) {
            this.smsRoleExternalId = smsRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSnsRegion}
         * @param snsRegion The region to integrate with SNS to send SMS messages.
         *                  This property will do nothing if SMS configuration is not configured
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder snsRegion(java.lang.String snsRegion) {
            this.snsRegion = snsRegion;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getStandardAttributes}
         * @param standardAttributes The set of attributes that are required for every user in the user pool.
         *                           Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder standardAttributes(software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes) {
            this.standardAttributes = standardAttributes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserInvitation}
         * @param userInvitation Configuration around admins signing up users into a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userInvitation(software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation) {
            this.userInvitation = userInvitation;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserPoolName}
         * @param userPoolName Name of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolName(java.lang.String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserVerification}
         * @param userVerification Configuration around users signing themselves up to the user pool.
         *                         Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userVerification(software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolProps {
        private final software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery;
        private final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes;
        private final software.amazon.awscdk.services.kms.IKey customSenderKmsKey;
        private final software.amazon.awscdk.services.cognito.DeviceTracking deviceTracking;
        private final software.amazon.awscdk.services.cognito.UserPoolEmail email;
        private final software.amazon.awscdk.services.cognito.EmailSettings emailSettings;
        private final java.lang.Boolean enableSmsRole;
        private final software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers;
        private final software.amazon.awscdk.services.cognito.Mfa mfa;
        private final java.lang.String mfaMessage;
        private final software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor;
        private final software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.Boolean selfSignUpEnabled;
        private final software.amazon.awscdk.services.cognito.SignInAliases signInAliases;
        private final java.lang.Boolean signInCaseSensitive;
        private final software.amazon.awscdk.services.iam.IRole smsRole;
        private final java.lang.String smsRoleExternalId;
        private final java.lang.String snsRegion;
        private final software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes;
        private final software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation;
        private final java.lang.String userPoolName;
        private final software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountRecovery = software.amazon.jsii.Kernel.get(this, "accountRecovery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AccountRecovery.class));
            this.autoVerify = software.amazon.jsii.Kernel.get(this, "autoVerify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AutoVerifiedAttrs.class));
            this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ICustomAttribute.class)));
            this.customSenderKmsKey = software.amazon.jsii.Kernel.get(this, "customSenderKmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.deviceTracking = software.amazon.jsii.Kernel.get(this, "deviceTracking", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.DeviceTracking.class));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolEmail.class));
            this.emailSettings = software.amazon.jsii.Kernel.get(this, "emailSettings", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.EmailSettings.class));
            this.enableSmsRole = software.amazon.jsii.Kernel.get(this, "enableSmsRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lambdaTriggers = software.amazon.jsii.Kernel.get(this, "lambdaTriggers", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolTriggers.class));
            this.mfa = software.amazon.jsii.Kernel.get(this, "mfa", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.Mfa.class));
            this.mfaMessage = software.amazon.jsii.Kernel.get(this, "mfaMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mfaSecondFactor = software.amazon.jsii.Kernel.get(this, "mfaSecondFactor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.MfaSecondFactor.class));
            this.passwordPolicy = software.amazon.jsii.Kernel.get(this, "passwordPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.PasswordPolicy.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.selfSignUpEnabled = software.amazon.jsii.Kernel.get(this, "selfSignUpEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.signInAliases = software.amazon.jsii.Kernel.get(this, "signInAliases", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.SignInAliases.class));
            this.signInCaseSensitive = software.amazon.jsii.Kernel.get(this, "signInCaseSensitive", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.smsRole = software.amazon.jsii.Kernel.get(this, "smsRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.smsRoleExternalId = software.amazon.jsii.Kernel.get(this, "smsRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snsRegion = software.amazon.jsii.Kernel.get(this, "snsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.standardAttributes = software.amazon.jsii.Kernel.get(this, "standardAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttributes.class));
            this.userInvitation = software.amazon.jsii.Kernel.get(this, "userInvitation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserInvitationConfig.class));
            this.userPoolName = software.amazon.jsii.Kernel.get(this, "userPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userVerification = software.amazon.jsii.Kernel.get(this, "userVerification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserVerificationConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountRecovery = builder.accountRecovery;
            this.autoVerify = builder.autoVerify;
            this.customAttributes = (java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute>)builder.customAttributes;
            this.customSenderKmsKey = builder.customSenderKmsKey;
            this.deviceTracking = builder.deviceTracking;
            this.email = builder.email;
            this.emailSettings = builder.emailSettings;
            this.enableSmsRole = builder.enableSmsRole;
            this.lambdaTriggers = builder.lambdaTriggers;
            this.mfa = builder.mfa;
            this.mfaMessage = builder.mfaMessage;
            this.mfaSecondFactor = builder.mfaSecondFactor;
            this.passwordPolicy = builder.passwordPolicy;
            this.removalPolicy = builder.removalPolicy;
            this.selfSignUpEnabled = builder.selfSignUpEnabled;
            this.signInAliases = builder.signInAliases;
            this.signInCaseSensitive = builder.signInCaseSensitive;
            this.smsRole = builder.smsRole;
            this.smsRoleExternalId = builder.smsRoleExternalId;
            this.snsRegion = builder.snsRegion;
            this.standardAttributes = builder.standardAttributes;
            this.userInvitation = builder.userInvitation;
            this.userPoolName = builder.userPoolName;
            this.userVerification = builder.userVerification;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AccountRecovery getAccountRecovery() {
            return this.accountRecovery;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs getAutoVerify() {
            return this.autoVerify;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getCustomSenderKmsKey() {
            return this.customSenderKmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.DeviceTracking getDeviceTracking() {
            return this.deviceTracking;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.UserPoolEmail getEmail() {
            return this.email;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.EmailSettings getEmailSettings() {
            return this.emailSettings;
        }

        @Override
        public final java.lang.Boolean getEnableSmsRole() {
            return this.enableSmsRole;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.UserPoolTriggers getLambdaTriggers() {
            return this.lambdaTriggers;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.Mfa getMfa() {
            return this.mfa;
        }

        @Override
        public final java.lang.String getMfaMessage() {
            return this.mfaMessage;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.MfaSecondFactor getMfaSecondFactor() {
            return this.mfaSecondFactor;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.PasswordPolicy getPasswordPolicy() {
            return this.passwordPolicy;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.Boolean getSelfSignUpEnabled() {
            return this.selfSignUpEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.SignInAliases getSignInAliases() {
            return this.signInAliases;
        }

        @Override
        public final java.lang.Boolean getSignInCaseSensitive() {
            return this.signInCaseSensitive;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getSmsRole() {
            return this.smsRole;
        }

        @Override
        public final java.lang.String getSmsRoleExternalId() {
            return this.smsRoleExternalId;
        }

        @Override
        public final java.lang.String getSnsRegion() {
            return this.snsRegion;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttributes getStandardAttributes() {
            return this.standardAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.UserInvitationConfig getUserInvitation() {
            return this.userInvitation;
        }

        @Override
        public final java.lang.String getUserPoolName() {
            return this.userPoolName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.UserVerificationConfig getUserVerification() {
            return this.userVerification;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountRecovery() != null) {
                data.set("accountRecovery", om.valueToTree(this.getAccountRecovery()));
            }
            if (this.getAutoVerify() != null) {
                data.set("autoVerify", om.valueToTree(this.getAutoVerify()));
            }
            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getCustomSenderKmsKey() != null) {
                data.set("customSenderKmsKey", om.valueToTree(this.getCustomSenderKmsKey()));
            }
            if (this.getDeviceTracking() != null) {
                data.set("deviceTracking", om.valueToTree(this.getDeviceTracking()));
            }
            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getEmailSettings() != null) {
                data.set("emailSettings", om.valueToTree(this.getEmailSettings()));
            }
            if (this.getEnableSmsRole() != null) {
                data.set("enableSmsRole", om.valueToTree(this.getEnableSmsRole()));
            }
            if (this.getLambdaTriggers() != null) {
                data.set("lambdaTriggers", om.valueToTree(this.getLambdaTriggers()));
            }
            if (this.getMfa() != null) {
                data.set("mfa", om.valueToTree(this.getMfa()));
            }
            if (this.getMfaMessage() != null) {
                data.set("mfaMessage", om.valueToTree(this.getMfaMessage()));
            }
            if (this.getMfaSecondFactor() != null) {
                data.set("mfaSecondFactor", om.valueToTree(this.getMfaSecondFactor()));
            }
            if (this.getPasswordPolicy() != null) {
                data.set("passwordPolicy", om.valueToTree(this.getPasswordPolicy()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSelfSignUpEnabled() != null) {
                data.set("selfSignUpEnabled", om.valueToTree(this.getSelfSignUpEnabled()));
            }
            if (this.getSignInAliases() != null) {
                data.set("signInAliases", om.valueToTree(this.getSignInAliases()));
            }
            if (this.getSignInCaseSensitive() != null) {
                data.set("signInCaseSensitive", om.valueToTree(this.getSignInCaseSensitive()));
            }
            if (this.getSmsRole() != null) {
                data.set("smsRole", om.valueToTree(this.getSmsRole()));
            }
            if (this.getSmsRoleExternalId() != null) {
                data.set("smsRoleExternalId", om.valueToTree(this.getSmsRoleExternalId()));
            }
            if (this.getSnsRegion() != null) {
                data.set("snsRegion", om.valueToTree(this.getSnsRegion()));
            }
            if (this.getStandardAttributes() != null) {
                data.set("standardAttributes", om.valueToTree(this.getStandardAttributes()));
            }
            if (this.getUserInvitation() != null) {
                data.set("userInvitation", om.valueToTree(this.getUserInvitation()));
            }
            if (this.getUserPoolName() != null) {
                data.set("userPoolName", om.valueToTree(this.getUserPoolName()));
            }
            if (this.getUserVerification() != null) {
                data.set("userVerification", om.valueToTree(this.getUserVerification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito.UserPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolProps.Jsii$Proxy that = (UserPoolProps.Jsii$Proxy) o;

            if (this.accountRecovery != null ? !this.accountRecovery.equals(that.accountRecovery) : that.accountRecovery != null) return false;
            if (this.autoVerify != null ? !this.autoVerify.equals(that.autoVerify) : that.autoVerify != null) return false;
            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            if (this.customSenderKmsKey != null ? !this.customSenderKmsKey.equals(that.customSenderKmsKey) : that.customSenderKmsKey != null) return false;
            if (this.deviceTracking != null ? !this.deviceTracking.equals(that.deviceTracking) : that.deviceTracking != null) return false;
            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            if (this.emailSettings != null ? !this.emailSettings.equals(that.emailSettings) : that.emailSettings != null) return false;
            if (this.enableSmsRole != null ? !this.enableSmsRole.equals(that.enableSmsRole) : that.enableSmsRole != null) return false;
            if (this.lambdaTriggers != null ? !this.lambdaTriggers.equals(that.lambdaTriggers) : that.lambdaTriggers != null) return false;
            if (this.mfa != null ? !this.mfa.equals(that.mfa) : that.mfa != null) return false;
            if (this.mfaMessage != null ? !this.mfaMessage.equals(that.mfaMessage) : that.mfaMessage != null) return false;
            if (this.mfaSecondFactor != null ? !this.mfaSecondFactor.equals(that.mfaSecondFactor) : that.mfaSecondFactor != null) return false;
            if (this.passwordPolicy != null ? !this.passwordPolicy.equals(that.passwordPolicy) : that.passwordPolicy != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.selfSignUpEnabled != null ? !this.selfSignUpEnabled.equals(that.selfSignUpEnabled) : that.selfSignUpEnabled != null) return false;
            if (this.signInAliases != null ? !this.signInAliases.equals(that.signInAliases) : that.signInAliases != null) return false;
            if (this.signInCaseSensitive != null ? !this.signInCaseSensitive.equals(that.signInCaseSensitive) : that.signInCaseSensitive != null) return false;
            if (this.smsRole != null ? !this.smsRole.equals(that.smsRole) : that.smsRole != null) return false;
            if (this.smsRoleExternalId != null ? !this.smsRoleExternalId.equals(that.smsRoleExternalId) : that.smsRoleExternalId != null) return false;
            if (this.snsRegion != null ? !this.snsRegion.equals(that.snsRegion) : that.snsRegion != null) return false;
            if (this.standardAttributes != null ? !this.standardAttributes.equals(that.standardAttributes) : that.standardAttributes != null) return false;
            if (this.userInvitation != null ? !this.userInvitation.equals(that.userInvitation) : that.userInvitation != null) return false;
            if (this.userPoolName != null ? !this.userPoolName.equals(that.userPoolName) : that.userPoolName != null) return false;
            return this.userVerification != null ? this.userVerification.equals(that.userVerification) : that.userVerification == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountRecovery != null ? this.accountRecovery.hashCode() : 0;
            result = 31 * result + (this.autoVerify != null ? this.autoVerify.hashCode() : 0);
            result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
            result = 31 * result + (this.customSenderKmsKey != null ? this.customSenderKmsKey.hashCode() : 0);
            result = 31 * result + (this.deviceTracking != null ? this.deviceTracking.hashCode() : 0);
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            result = 31 * result + (this.emailSettings != null ? this.emailSettings.hashCode() : 0);
            result = 31 * result + (this.enableSmsRole != null ? this.enableSmsRole.hashCode() : 0);
            result = 31 * result + (this.lambdaTriggers != null ? this.lambdaTriggers.hashCode() : 0);
            result = 31 * result + (this.mfa != null ? this.mfa.hashCode() : 0);
            result = 31 * result + (this.mfaMessage != null ? this.mfaMessage.hashCode() : 0);
            result = 31 * result + (this.mfaSecondFactor != null ? this.mfaSecondFactor.hashCode() : 0);
            result = 31 * result + (this.passwordPolicy != null ? this.passwordPolicy.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.selfSignUpEnabled != null ? this.selfSignUpEnabled.hashCode() : 0);
            result = 31 * result + (this.signInAliases != null ? this.signInAliases.hashCode() : 0);
            result = 31 * result + (this.signInCaseSensitive != null ? this.signInCaseSensitive.hashCode() : 0);
            result = 31 * result + (this.smsRole != null ? this.smsRole.hashCode() : 0);
            result = 31 * result + (this.smsRoleExternalId != null ? this.smsRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.snsRegion != null ? this.snsRegion.hashCode() : 0);
            result = 31 * result + (this.standardAttributes != null ? this.standardAttributes.hashCode() : 0);
            result = 31 * result + (this.userInvitation != null ? this.userInvitation.hashCode() : 0);
            result = 31 * result + (this.userPoolName != null ? this.userPoolName.hashCode() : 0);
            result = 31 * result + (this.userVerification != null ? this.userVerification.hashCode() : 0);
            return result;
        }
    }
}
