package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Login Provider for Identity Federation using Amazon Credentials.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .authenticationProviders(IdentityPoolAuthenticationProviders.builder()
 *                 .amazon(IdentityPoolAmazonLoginProvider.builder()
 *                         .appId("amzn1.application.12312k3j234j13rjiwuenf")
 *                         .build())
 *                 .facebook(IdentityPoolFacebookLoginProvider.builder()
 *                         .appId("1234567890123")
 *                         .build())
 *                 .google(IdentityPoolGoogleLoginProvider.builder()
 *                         .clientId("12345678012.apps.googleusercontent.com")
 *                         .build())
 *                 .apple(IdentityPoolAppleLoginProvider.builder()
 *                         .servicesId("com.myappleapp.auth")
 *                         .build())
 *                 .twitter(IdentityPoolTwitterLoginProvider.builder()
 *                         .consumerKey("my-twitter-id")
 *                         .consumerSecret("my-twitter-secret")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.018Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPoolAmazonLoginProvider")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolAmazonLoginProvider.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IdentityPoolAmazonLoginProvider extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) App Id for Amazon Identity Federation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAppId();

    /**
     * @return a {@link Builder} of {@link IdentityPoolAmazonLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolAmazonLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolAmazonLoginProvider> {
        java.lang.String appId;

        /**
         * Sets the value of {@link IdentityPoolAmazonLoginProvider#getAppId}
         * @param appId App Id for Amazon Identity Federation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolAmazonLoginProvider}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IdentityPoolAmazonLoginProvider build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolAmazonLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolAmazonLoginProvider {
        private final java.lang.String appId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = java.util.Objects.requireNonNull(builder.appId, "appId is required");
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appId", om.valueToTree(this.getAppId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito_identitypool.IdentityPoolAmazonLoginProvider"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolAmazonLoginProvider.Jsii$Proxy that = (IdentityPoolAmazonLoginProvider.Jsii$Proxy) o;

            return this.appId.equals(that.appId);
        }

        @Override
        public final int hashCode() {
            int result = this.appId.hashCode();
            return result;
        }
    }
}
