package software.amazon.awscdk.services.cognito.identitypool;

/**
 * (experimental) Authentication providers for using in identity pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenIdConnectProvider openIdConnectProvider;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .authenticationProviders(IdentityPoolAuthenticationProviders.builder()
 *                 .google(IdentityPoolGoogleLoginProvider.builder()
 *                         .clientId("12345678012.apps.googleusercontent.com")
 *                         .build())
 *                 .openIdConnectProviders(List.of(openIdConnectProvider))
 *                 .customProvider("my-custom-provider.example.com")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:44:58.020Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_cognito_identitypool.IdentityPoolAuthenticationProviders")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolAuthenticationProviders.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IdentityPoolAuthenticationProviders extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviders {

    /**
     * (experimental) The Developer Provider Name to associate with this Identity Pool.
     * <p>
     * Default: - no Custom Provider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomProvider() {
        return null;
    }

    /**
     * (experimental) The OpenIdConnect Provider associated with this Identity Pool.
     * <p>
     * Default: - no OpenIdConnectProvider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider> getOpenIdConnectProviders() {
        return null;
    }

    /**
     * (experimental) The Security Assertion Markup Language Provider associated with this Identity Pool.
     * <p>
     * Default: - no SamlProvider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.ISamlProvider> getSamlProviders() {
        return null;
    }

    /**
     * (experimental) The User Pool Authentication Providers associated with this Identity Pool.
     * <p>
     * Default: - no User Pools Associated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider> getUserPools() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IdentityPoolAuthenticationProviders}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolAuthenticationProviders}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolAuthenticationProviders> {
        java.lang.String customProvider;
        java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider> openIdConnectProviders;
        java.util.List<software.amazon.awscdk.services.iam.ISamlProvider> samlProviders;
        java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider> userPools;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAmazonLoginProvider amazon;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAppleLoginProvider apple;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolDigitsLoginProvider digits;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolFacebookLoginProvider facebook;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolGoogleLoginProvider google;
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolTwitterLoginProvider twitter;

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getCustomProvider}
         * @param customProvider The Developer Provider Name to associate with this Identity Pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customProvider(java.lang.String customProvider) {
            this.customProvider = customProvider;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getOpenIdConnectProviders}
         * @param openIdConnectProviders The OpenIdConnect Provider associated with this Identity Pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder openIdConnectProviders(java.util.List<? extends software.amazon.awscdk.services.iam.IOpenIdConnectProvider> openIdConnectProviders) {
            this.openIdConnectProviders = (java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider>)openIdConnectProviders;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getSamlProviders}
         * @param samlProviders The Security Assertion Markup Language Provider associated with this Identity Pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder samlProviders(java.util.List<? extends software.amazon.awscdk.services.iam.ISamlProvider> samlProviders) {
            this.samlProviders = (java.util.List<software.amazon.awscdk.services.iam.ISamlProvider>)samlProviders;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getUserPools}
         * @param userPools The User Pool Authentication Providers associated with this Identity Pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder userPools(java.util.List<? extends software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider> userPools) {
            this.userPools = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider>)userPools;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getAmazon}
         * @param amazon App Id for Amazon Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder amazon(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAmazonLoginProvider amazon) {
            this.amazon = amazon;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getApple}
         * @param apple Services Id for Apple Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apple(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAppleLoginProvider apple) {
            this.apple = apple;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getDigits}
         * @param digits Consumer Key and Secret for Digits Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder digits(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolDigitsLoginProvider digits) {
            this.digits = digits;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getFacebook}
         * @param facebook App Id for Facebook Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder facebook(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolFacebookLoginProvider facebook) {
            this.facebook = facebook;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getGoogle}
         * @param google Client Id for Google Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder google(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolGoogleLoginProvider google) {
            this.google = google;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolAuthenticationProviders#getTwitter}
         * @param twitter Consumer Key and Secret for Twitter Identity Federation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder twitter(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolTwitterLoginProvider twitter) {
            this.twitter = twitter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolAuthenticationProviders}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public IdentityPoolAuthenticationProviders build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolAuthenticationProviders}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolAuthenticationProviders {
        private final java.lang.String customProvider;
        private final java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider> openIdConnectProviders;
        private final java.util.List<software.amazon.awscdk.services.iam.ISamlProvider> samlProviders;
        private final java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider> userPools;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAmazonLoginProvider amazon;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAppleLoginProvider apple;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolDigitsLoginProvider digits;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolFacebookLoginProvider facebook;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolGoogleLoginProvider google;
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolTwitterLoginProvider twitter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customProvider = software.amazon.jsii.Kernel.get(this, "customProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openIdConnectProviders = software.amazon.jsii.Kernel.get(this, "openIdConnectProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IOpenIdConnectProvider.class)));
            this.samlProviders = software.amazon.jsii.Kernel.get(this, "samlProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ISamlProvider.class)));
            this.userPools = software.amazon.jsii.Kernel.get(this, "userPools", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider.class)));
            this.amazon = software.amazon.jsii.Kernel.get(this, "amazon", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAmazonLoginProvider.class));
            this.apple = software.amazon.jsii.Kernel.get(this, "apple", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAppleLoginProvider.class));
            this.digits = software.amazon.jsii.Kernel.get(this, "digits", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolDigitsLoginProvider.class));
            this.facebook = software.amazon.jsii.Kernel.get(this, "facebook", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolFacebookLoginProvider.class));
            this.google = software.amazon.jsii.Kernel.get(this, "google", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolGoogleLoginProvider.class));
            this.twitter = software.amazon.jsii.Kernel.get(this, "twitter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolTwitterLoginProvider.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customProvider = builder.customProvider;
            this.openIdConnectProviders = (java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider>)builder.openIdConnectProviders;
            this.samlProviders = (java.util.List<software.amazon.awscdk.services.iam.ISamlProvider>)builder.samlProviders;
            this.userPools = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider>)builder.userPools;
            this.amazon = builder.amazon;
            this.apple = builder.apple;
            this.digits = builder.digits;
            this.facebook = builder.facebook;
            this.google = builder.google;
            this.twitter = builder.twitter;
        }

        @Override
        public final java.lang.String getCustomProvider() {
            return this.customProvider;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IOpenIdConnectProvider> getOpenIdConnectProviders() {
            return this.openIdConnectProviders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.ISamlProvider> getSamlProviders() {
            return this.samlProviders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider> getUserPools() {
            return this.userPools;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAmazonLoginProvider getAmazon() {
            return this.amazon;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAppleLoginProvider getApple() {
            return this.apple;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolDigitsLoginProvider getDigits() {
            return this.digits;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolFacebookLoginProvider getFacebook() {
            return this.facebook;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolGoogleLoginProvider getGoogle() {
            return this.google;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolTwitterLoginProvider getTwitter() {
            return this.twitter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCustomProvider() != null) {
                data.set("customProvider", om.valueToTree(this.getCustomProvider()));
            }
            if (this.getOpenIdConnectProviders() != null) {
                data.set("openIdConnectProviders", om.valueToTree(this.getOpenIdConnectProviders()));
            }
            if (this.getSamlProviders() != null) {
                data.set("samlProviders", om.valueToTree(this.getSamlProviders()));
            }
            if (this.getUserPools() != null) {
                data.set("userPools", om.valueToTree(this.getUserPools()));
            }
            if (this.getAmazon() != null) {
                data.set("amazon", om.valueToTree(this.getAmazon()));
            }
            if (this.getApple() != null) {
                data.set("apple", om.valueToTree(this.getApple()));
            }
            if (this.getDigits() != null) {
                data.set("digits", om.valueToTree(this.getDigits()));
            }
            if (this.getFacebook() != null) {
                data.set("facebook", om.valueToTree(this.getFacebook()));
            }
            if (this.getGoogle() != null) {
                data.set("google", om.valueToTree(this.getGoogle()));
            }
            if (this.getTwitter() != null) {
                data.set("twitter", om.valueToTree(this.getTwitter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_cognito_identitypool.IdentityPoolAuthenticationProviders"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolAuthenticationProviders.Jsii$Proxy that = (IdentityPoolAuthenticationProviders.Jsii$Proxy) o;

            if (this.customProvider != null ? !this.customProvider.equals(that.customProvider) : that.customProvider != null) return false;
            if (this.openIdConnectProviders != null ? !this.openIdConnectProviders.equals(that.openIdConnectProviders) : that.openIdConnectProviders != null) return false;
            if (this.samlProviders != null ? !this.samlProviders.equals(that.samlProviders) : that.samlProviders != null) return false;
            if (this.userPools != null ? !this.userPools.equals(that.userPools) : that.userPools != null) return false;
            if (this.amazon != null ? !this.amazon.equals(that.amazon) : that.amazon != null) return false;
            if (this.apple != null ? !this.apple.equals(that.apple) : that.apple != null) return false;
            if (this.digits != null ? !this.digits.equals(that.digits) : that.digits != null) return false;
            if (this.facebook != null ? !this.facebook.equals(that.facebook) : that.facebook != null) return false;
            if (this.google != null ? !this.google.equals(that.google) : that.google != null) return false;
            return this.twitter != null ? this.twitter.equals(that.twitter) : that.twitter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customProvider != null ? this.customProvider.hashCode() : 0;
            result = 31 * result + (this.openIdConnectProviders != null ? this.openIdConnectProviders.hashCode() : 0);
            result = 31 * result + (this.samlProviders != null ? this.samlProviders.hashCode() : 0);
            result = 31 * result + (this.userPools != null ? this.userPools.hashCode() : 0);
            result = 31 * result + (this.amazon != null ? this.amazon.hashCode() : 0);
            result = 31 * result + (this.apple != null ? this.apple.hashCode() : 0);
            result = 31 * result + (this.digits != null ? this.digits.hashCode() : 0);
            result = 31 * result + (this.facebook != null ? this.facebook.hashCode() : 0);
            result = 31 * result + (this.google != null ? this.google.hashCode() : 0);
            result = 31 * result + (this.twitter != null ? this.twitter.hashCode() : 0);
            return result;
        }
    }
}
